/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.file.FileCollection;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.impl.DefaultAfterExecutionState;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.IncrementalChangesContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildCacheStep
implements Step<IncrementalChangesContext, AfterExecutionResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildCacheStep.class);
    private final BuildCacheController buildCache;
    private final BuildCacheCommandFactory commandFactory;
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super IncrementalChangesContext, ? extends AfterExecutionResult> delegate;

    public BuildCacheStep(BuildCacheController buildCache, BuildCacheCommandFactory commandFactory, Deleter deleter, OutputChangeListener outputChangeListener, Step<? super IncrementalChangesContext, ? extends AfterExecutionResult> delegate) {
        this.buildCache = buildCache;
        this.commandFactory = commandFactory;
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public AfterExecutionResult execute(UnitOfWork work, IncrementalChangesContext context) {
        return context.getCachingState().fold(cachingEnabled -> this.executeWithCache(work, context, cachingEnabled.getKey(), cachingEnabled.getBeforeExecutionState()), cachingDisabled -> this.executeWithoutCache(work, context));
    }

    private AfterExecutionResult executeWithCache(final UnitOfWork work, final IncrementalChangesContext context, BuildCacheKey cacheKey, BeforeExecutionState beforeExecutionState) {
        CacheableWork cacheableWork = new CacheableWork(context.getIdentity().getUniqueId(), context.getWorkspace(), work);
        return Try.ofFailable(() -> work.isAllowedToLoadFromCache() ? this.buildCache.load(this.commandFactory.createLoad(cacheKey, cacheableWork)) : Optional.empty()).map(successfulLoad -> successfulLoad.map(cacheHit -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Loaded cache entry for {} with cache key {}", (Object)work.getDisplayName(), (Object)cacheKey.getHashCode());
            }
            this.cleanLocalState(context.getWorkspace(), work);
            final OriginMetadata originMetadata = cacheHit.getOriginMetadata();
            final DefaultAfterExecutionState afterExecutionState = new DefaultAfterExecutionState(beforeExecutionState, cacheHit.getResultingSnapshots(), originMetadata, true);
            return new AfterExecutionResult(){

                @Override
                public Try<ExecutionResult> getExecutionResult() {
                    return Try.successful(new ExecutionResult(){

                        @Override
                        public ExecutionOutcome getOutcome() {
                            return ExecutionOutcome.FROM_CACHE;
                        }

                        @Override
                        public Object getOutput() {
                            return work.loadRestoredOutput(context.getWorkspace());
                        }
                    });
                }

                @Override
                public Duration getDuration() {
                    return originMetadata.getExecutionTime();
                }

                @Override
                public Optional<AfterExecutionState> getAfterExecutionState() {
                    return Optional.of(afterExecutionState);
                }
            };
        }).orElseGet(() -> this.executeAndStoreInCache(cacheableWork, cacheKey, context))).getOrMapFailure(loadFailure -> {
            throw new RuntimeException(String.format("Failed to load cache entry for %s", work.getDisplayName()), (Throwable)loadFailure);
        });
    }

    private void cleanLocalState(File workspace, final UnitOfWork work) {
        work.visitOutputs(workspace, new UnitOfWork.OutputVisitor(){

            @Override
            public void visitLocalState(File localStateRoot) {
                try {
                    BuildCacheStep.this.outputChangeListener.beforeOutputChange((Iterable<String>)ImmutableList.of((Object)localStateRoot.getAbsolutePath()));
                    BuildCacheStep.this.deleter.deleteRecursively(localStateRoot);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", work.getDisplayName(), localStateRoot), ex);
                }
            }
        });
    }

    private AfterExecutionResult executeAndStoreInCache(CacheableWork cacheableWork, BuildCacheKey cacheKey, IncrementalChangesContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Did not find cache entry for {} with cache key {}, executing instead", (Object)cacheableWork.getDisplayName(), (Object)cacheKey.getHashCode());
        }
        AfterExecutionResult result2 = this.executeWithoutCache(cacheableWork.work, context);
        result2.getExecutionResult().ifSuccessfulOrElse(executionResult -> result2.getAfterExecutionState().ifPresent(afterExecutionState -> this.store(cacheableWork, cacheKey, afterExecutionState.getOutputFilesProducedByWork(), afterExecutionState.getOriginMetadata().getExecutionTime())), failure -> LOGGER.debug("Not storing result of {} in cache because the execution failed", (Object)cacheableWork.getDisplayName()));
        return result2;
    }

    private void store(CacheableWork work, BuildCacheKey cacheKey, ImmutableSortedMap<String, FileSystemSnapshot> outputFilesProducedByWork, Duration executionTime) {
        try {
            this.buildCache.store(this.commandFactory.createStore(cacheKey, work, (Map<String, ? extends FileSystemSnapshot>)outputFilesProducedByWork, executionTime));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stored cache entry for {} with cache key {}", (Object)work.getDisplayName(), (Object)cacheKey.getHashCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to store cache entry for %s", work.getDisplayName()), e);
        }
    }

    private AfterExecutionResult executeWithoutCache(UnitOfWork work, IncrementalChangesContext context) {
        return this.delegate.execute(work, context);
    }

    private static class CacheableWork
    implements CacheableEntity {
        private final String identity;
        private final File workspace;
        private final UnitOfWork work;

        public CacheableWork(String identity, File workspace, UnitOfWork work) {
            this.identity = identity;
            this.workspace = workspace;
            this.work = work;
        }

        @Override
        public String getIdentity() {
            return this.identity;
        }

        @Override
        public Class<?> getType() {
            return this.work.getClass();
        }

        @Override
        public String getDisplayName() {
            return this.work.getDisplayName();
        }

        @Override
        public void visitOutputTrees(final CacheableEntity.CacheableTreeVisitor visitor) {
            this.work.visitOutputs(this.workspace, new UnitOfWork.OutputVisitor(){

                @Override
                public void visitOutputProperty(String propertyName, TreeType type, File root, FileCollection contents) {
                    visitor.visitOutputTree(propertyName, type, root);
                }
            });
        }
    }
}

