/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jacoco.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.jacoco.rules.JacocoLimitImpl;
import org.gradle.testing.jacoco.tasks.rules.JacocoLimit;
import org.gradle.testing.jacoco.tasks.rules.JacocoViolationRule;

public class JacocoViolationRuleImpl
implements JacocoViolationRule {
    private boolean enabled = true;
    private String scope = "BUNDLE";
    private List<String> includes = ImmutableList.of((Object)"*");
    private List<String> excludes = ImmutableList.of();
    private final List<JacocoLimit> limits = new ArrayList<JacocoLimit>();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setElement(String element) {
        this.scope = element;
    }

    @Override
    public String getElement() {
        return this.scope;
    }

    @Override
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public List<String> getIncludes() {
        return Collections.unmodifiableList(this.includes);
    }

    @Override
    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    public List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    @Override
    public List<JacocoLimit> getLimits() {
        return Collections.unmodifiableList(this.limits);
    }

    @Override
    public JacocoLimit limit(Action<? super JacocoLimit> configureAction) {
        JacocoLimitImpl limit = new JacocoLimitImpl();
        configureAction.execute(limit);
        this.limits.add(limit);
        return limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacocoViolationRuleImpl that = (JacocoViolationRuleImpl)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        if (this.includes != null ? !this.includes.equals(that.includes) : that.includes != null) {
            return false;
        }
        if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) {
            return false;
        }
        return this.limits != null ? this.limits.equals(that.limits) : that.limits == null;
    }

    public int hashCode() {
        int result2 = this.enabled ? 1 : 0;
        result2 = 31 * result2 + (this.scope != null ? this.scope.hashCode() : 0);
        result2 = 31 * result2 + (this.includes != null ? this.includes.hashCode() : 0);
        result2 = 31 * result2 + (this.excludes != null ? this.excludes.hashCode() : 0);
        result2 = 31 * result2 + (this.limits != null ? this.limits.hashCode() : 0);
        return result2;
    }
}

