/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;

public class DefaultTypeValidationContext
extends ProblemRecordingTypeValidationContext {
    private final boolean reportCacheabilityProblems;
    private final ImmutableMap.Builder<String, Severity> problems = ImmutableMap.builder();

    public static DefaultTypeValidationContext withRootType(DocumentationRegistry documentationRegistry, Class<?> rootType, boolean cacheable) {
        return new DefaultTypeValidationContext(documentationRegistry, rootType, cacheable);
    }

    public static DefaultTypeValidationContext withoutRootType(DocumentationRegistry documentationRegistry, boolean reportCacheabilityProblems) {
        return new DefaultTypeValidationContext(documentationRegistry, null, reportCacheabilityProblems);
    }

    private DefaultTypeValidationContext(DocumentationRegistry documentationRegistry, @Nullable Class<?> rootType, boolean reportCacheabilityProblems) {
        super(documentationRegistry, rootType, null);
        this.reportCacheabilityProblems = reportCacheabilityProblems;
    }

    @Override
    protected void recordProblem(TypeValidationProblem problem) {
        boolean onlyAffectsCacheableWork = problem.isOnlyAffectsCacheableWork();
        if (onlyAffectsCacheableWork && !this.reportCacheabilityProblems) {
            return;
        }
        this.problems.put((Object)TypeValidationProblemRenderer.renderMinimalInformationAbout(problem), (Object)((Severity)((Object)problem.getSeverity())));
    }

    public ImmutableMap<String, Severity> getProblems() {
        return this.problems.build();
    }
}

