/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.util.internal.GUtil;

@Contextual
public class ArtifactResolveException
extends GradleException {
    public ArtifactResolveException(String message2) {
        super(message2);
    }

    public ArtifactResolveException(String message2, Throwable cause) {
        super(message2, cause);
    }

    public ArtifactResolveException(ComponentIdentifier component, Throwable cause) {
        super(ArtifactResolveException.format(component, ""), cause);
    }

    public ArtifactResolveException(ComponentIdentifier component, String message2) {
        super(ArtifactResolveException.format(component, message2));
    }

    public ArtifactResolveException(ComponentArtifactIdentifier artifact, Throwable cause) {
        super(ArtifactResolveException.format(artifact, ""), cause);
    }

    public ArtifactResolveException(ComponentArtifactIdentifier artifact, String message2) {
        super(ArtifactResolveException.format(artifact, message2));
    }

    private static String format(ComponentArtifactIdentifier artifact, String message2) {
        StringBuilder builder = new StringBuilder();
        builder.append("Could not download ");
        builder.append(artifact.getDisplayName());
        if (GUtil.isTrue(message2)) {
            builder.append(": ");
            builder.append(message2);
        }
        return builder.toString();
    }

    private static String format(ComponentIdentifier component, String message2) {
        StringBuilder builder = new StringBuilder();
        builder.append("Could not determine artifacts for ");
        builder.append(component.getDisplayName());
        if (GUtil.isTrue(message2)) {
            builder.append(": ");
            builder.append(message2);
        }
        return builder.toString();
    }
}

