/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public abstract class AbstractLocallyAvailableResource
implements LocallyAvailableResource {
    private Factory<HashCode> factory;
    private HashCode sha1;
    private Long contentLength;
    private Long lastModified;

    protected AbstractLocallyAvailableResource(Factory<HashCode> factory) {
        this.factory = factory;
    }

    protected AbstractLocallyAvailableResource(HashCode sha1) {
        this.sha1 = sha1;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.getFile().getPath();
    }

    @Override
    public HashCode getSha1() {
        if (this.sha1 == null) {
            this.sha1 = this.factory.create();
        }
        return this.sha1;
    }

    @Override
    public long getContentLength() {
        if (this.contentLength == null) {
            this.contentLength = this.getFile().length();
        }
        return this.contentLength;
    }

    @Override
    public long getLastModified() {
        if (this.lastModified == null) {
            this.lastModified = this.getFile().lastModified();
        }
        return this.lastModified;
    }
}

