/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.List;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;

public class LazyLocallyAvailableResourceCandidates
implements LocallyAvailableResourceCandidates {
    private final Factory<List<File>> filesFactory;
    private final ChecksumService checksumService;
    private List<File> files;

    public LazyLocallyAvailableResourceCandidates(Factory<List<File>> filesFactory, ChecksumService checksumService) {
        this.filesFactory = filesFactory;
        this.checksumService = checksumService;
    }

    protected List<File> getFiles() {
        if (this.files == null) {
            this.files = this.filesFactory.create();
        }
        return this.files;
    }

    @Override
    public boolean isNone() {
        return this.getFiles().isEmpty();
    }

    @Override
    public LocallyAvailableResource findByHashValue(HashCode targetHash) {
        for (File file : this.getFiles()) {
            HashCode thisHash = this.checksumService.sha1(file);
            if (!thisHash.equals(targetHash)) continue;
            return new DefaultLocallyAvailableResource(file, thisHash);
        }
        return null;
    }
}

