/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Output;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.serialize.AbstractEncoder;
import org.gradle.internal.serialize.FlushableEncoder;

public class StringDeduplicatingKryoBackedEncoder
extends AbstractEncoder
implements FlushableEncoder,
Closeable {
    private Map<String, Integer> strings;
    private final Output output;

    public StringDeduplicatingKryoBackedEncoder(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public StringDeduplicatingKryoBackedEncoder(OutputStream outputStream, int bufferSize) {
        this.output = new Output(outputStream, bufferSize);
    }

    @Override
    public void writeByte(byte value) {
        this.output.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) {
        this.output.writeBytes(bytes, offset, count);
    }

    @Override
    public void writeLong(long value) {
        this.output.writeLong(value);
    }

    @Override
    public void writeSmallLong(long value) {
        this.output.writeLong(value, true);
    }

    @Override
    public void writeInt(int value) {
        this.output.writeInt(value);
    }

    @Override
    public void writeSmallInt(int value) {
        this.output.writeInt(value, true);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.output.writeBoolean(value);
    }

    @Override
    public void writeString(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode a null string.");
        }
        this.writeNullableString(value);
    }

    @Override
    public void writeNullableString(@Nullable CharSequence value) {
        String key;
        Integer index;
        if (value == null) {
            this.output.writeInt(-1);
            return;
        }
        if (this.strings == null) {
            this.strings = Maps.newHashMapWithExpectedSize((int)1024);
        }
        if ((index = this.strings.get(key = value.toString())) == null) {
            index = this.strings.size();
            this.output.writeInt(index.intValue());
            this.strings.put(key, index);
            this.output.writeString(key);
        } else {
            this.output.writeInt(index.intValue());
        }
    }

    public long getWritePosition() {
        return this.output.total();
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }

    public void done() {
        this.strings = null;
    }
}

