/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.vfs.FileSystemAccess;

public class LocationsWrittenByCurrentBuild
implements FileSystemAccess.WriteListener {
    private final AtomicReference<FileHierarchySet> producedByCurrentBuild = new AtomicReference<FileHierarchySet>(FileHierarchySet.empty());
    private volatile boolean buildRunning;

    @Override
    public void locationsWritten(Iterable<String> locations) {
        if (this.buildRunning) {
            this.producedByCurrentBuild.updateAndGet(currentValue -> {
                FileHierarchySet newValue = currentValue;
                for (String location : locations) {
                    newValue = newValue.plus(location);
                }
                return newValue;
            });
        }
    }

    public boolean wasLocationWritten(String location) {
        return this.producedByCurrentBuild.get().contains(location);
    }

    public void buildStarted() {
        this.producedByCurrentBuild.set(FileHierarchySet.empty());
        this.buildRunning = true;
    }

    public void buildFinished() {
        this.buildRunning = false;
        this.producedByCurrentBuild.set(FileHierarchySet.empty());
    }
}

