/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import groovy.lang.Closure;
import java.util.Arrays;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;

public class ClosureBackedMethodInvocationDispatch
implements Dispatch<MethodInvocation> {
    private final String methodName;
    private final Closure closure;

    public ClosureBackedMethodInvocationDispatch(String methodName, Closure closure) {
        this.methodName = methodName;
        this.closure = closure;
    }

    @Override
    public void dispatch(MethodInvocation message2) {
        if (message2.getMethod().getName().equals(this.methodName)) {
            Object[] parameters = message2.getArguments();
            if (this.closure.getMaximumNumberOfParameters() < parameters.length) {
                parameters = Arrays.asList(parameters).subList(0, this.closure.getMaximumNumberOfParameters()).toArray();
            }
            this.closure.call(parameters);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosureBackedMethodInvocationDispatch that = (ClosureBackedMethodInvocationDispatch)o;
        if (!this.closure.equals(that.closure)) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    public int hashCode() {
        int result2 = this.methodName.hashCode();
        result2 = 31 * result2 + this.closure.hashCode();
        return result2;
    }
}

