/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.internal;

import javax.inject.Inject;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.internal.AbstractNativeBinaryRenderer;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.NativeTestSuiteSpec;

public class NativeTestSuiteBinaryRenderer
extends AbstractNativeBinaryRenderer<NativeTestSuiteBinarySpec> {
    @Inject
    public NativeTestSuiteBinaryRenderer(ModelSchemaStore schemaStore) {
        super(schemaStore);
    }

    @Override
    public Class<NativeTestSuiteBinarySpec> getTargetType() {
        return NativeTestSuiteBinarySpec.class;
    }

    @Override
    protected void renderTasks(NativeTestSuiteBinarySpec binary, TextReportBuilder builder) {
        builder.item("install using task", binary.getTasks().getInstall().getPath());
        builder.item("run using task", binary.getTasks().getRun().getPath());
    }

    @Override
    protected void renderOutputs(NativeTestSuiteBinarySpec binary, TextReportBuilder builder) {
        builder.item("executable file", binary.getExecutableFile());
    }

    @Override
    protected void renderDetails(NativeTestSuiteBinarySpec binary, TextReportBuilder builder) {
        NativeBinarySpec testedBinary;
        NativeTestSuiteSpec testSuite = binary.getTestSuite();
        NativeComponentSpec testedComponent = testSuite.getTestedComponent();
        if (testedComponent != null) {
            builder.item("component under test", testedComponent.getDisplayName());
        }
        if ((testedBinary = binary.getTestedBinary()) != null) {
            builder.item("binary under test", testedBinary.getDisplayName());
        }
        super.renderDetails(binary, builder);
    }
}

