/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.model.WbProperty;
import org.gradle.plugins.ide.eclipse.model.WbResource;
import org.gradle.plugins.ide.eclipse.model.WtpComponent;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.WtpComponentFactory;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.util.internal.ConfigureUtil;

public class EclipseWtpComponent {
    private final Project project;
    private final XmlFileContentMerger file;
    private Set<File> sourceDirs;
    private Set<Configuration> rootConfigurations = Sets.newLinkedHashSet();
    private Set<Configuration> libConfigurations = Sets.newLinkedHashSet();
    private Set<Configuration> minusConfigurations = Sets.newLinkedHashSet();
    private String deployName;
    private List<WbResource> resources = Lists.newArrayList();
    private List<WbProperty> properties = Lists.newArrayList();
    private String contextPath;
    private String classesDeployPath = "/WEB-INF/classes";
    private String libDeployPath;
    private Map<String, File> pathVariables = Maps.newHashMap();

    @Inject
    public EclipseWtpComponent(Project project, XmlFileContentMerger file) {
        this.project = project;
        this.file = file;
    }

    public Project getProject() {
        return this.project;
    }

    public XmlFileContentMerger getFile() {
        return this.file;
    }

    public void file(Closure closure) {
        ConfigureUtil.configure(closure, this.file);
    }

    public void file(Action<? super XmlFileContentMerger> action) {
        action.execute(this.file);
    }

    public Set<File> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(Set<File> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public Set<Configuration> getRootConfigurations() {
        return this.rootConfigurations;
    }

    public void setRootConfigurations(Set<Configuration> rootConfigurations) {
        this.rootConfigurations = rootConfigurations;
    }

    public Set<Configuration> getLibConfigurations() {
        return this.libConfigurations;
    }

    public void setLibConfigurations(Set<Configuration> libConfigurations) {
        this.libConfigurations = libConfigurations;
    }

    public Set<Configuration> getPlusConfigurations() {
        return this.getLibConfigurations();
    }

    public void setPlusConfigurations(Set<Configuration> plusConfigurations) {
        this.setLibConfigurations(plusConfigurations);
    }

    public Set<Configuration> getMinusConfigurations() {
        return this.minusConfigurations;
    }

    public void setMinusConfigurations(Set<Configuration> minusConfigurations) {
        this.minusConfigurations = minusConfigurations;
    }

    public String getDeployName() {
        return this.deployName;
    }

    public void setDeployName(String deployName) {
        this.deployName = deployName;
    }

    public List<WbResource> getResources() {
        return this.resources;
    }

    public void setResources(List<WbResource> resources) {
        this.resources = resources;
    }

    public void resource(Map<String, String> args) {
        this.resources = Lists.newArrayList((Iterable)Iterables.concat(this.getResources(), Collections.singleton(new WbResource(args.get("deployPath"), args.get("sourcePath")))));
    }

    public List<WbProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<WbProperty> properties) {
        this.properties = properties;
    }

    public void property(Map<String, String> args) {
        this.properties = Lists.newArrayList((Iterable)Iterables.concat(this.getProperties(), Collections.singleton(new WbProperty(args.get("name"), args.get("value")))));
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getClassesDeployPath() {
        return this.classesDeployPath;
    }

    public void setClassesDeployPath(String classesDeployPath) {
        this.classesDeployPath = classesDeployPath;
    }

    public String getLibDeployPath() {
        return this.libDeployPath;
    }

    public void setLibDeployPath(String libDeployPath) {
        this.libDeployPath = libDeployPath;
    }

    public Map<String, File> getPathVariables() {
        return this.pathVariables;
    }

    public void setPathVariables(Map<String, File> pathVariables) {
        this.pathVariables = pathVariables;
    }

    public FileReferenceFactory getFileReferenceFactory() {
        FileReferenceFactory referenceFactory = new FileReferenceFactory();
        for (Map.Entry<String, File> pathVariable : this.pathVariables.entrySet()) {
            referenceFactory.addPathVariable(pathVariable.getKey(), pathVariable.getValue());
        }
        return referenceFactory;
    }

    public void mergeXmlComponent(WtpComponent xmlComponent) {
        this.file.getBeforeMerged().execute(xmlComponent);
        ProjectInternal projectInternal = (ProjectInternal)this.project;
        IdeArtifactRegistry ideArtifactRegistry = projectInternal.getServices().get(IdeArtifactRegistry.class);
        ProjectStateRegistry projectRegistry = projectInternal.getServices().get(ProjectStateRegistry.class);
        new WtpComponentFactory(projectInternal, ideArtifactRegistry, projectRegistry).configure(this, xmlComponent);
        this.file.getWhenMerged().execute(xmlComponent);
    }
}

