/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.operations.CurrentBuildOperationPreservingRunnable;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.ExecHandleRunner;
import org.gradle.process.internal.ExecHandleShutdownHookAction;
import org.gradle.process.internal.ExecHandleState;
import org.gradle.process.internal.ProcessSettings;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.process.internal.shutdown.ShutdownHooks;
import org.gradle.process.internal.util.LongCommandLineDetectionUtil;

public class DefaultExecHandle
implements ExecHandle,
ProcessSettings {
    private static final Logger LOGGER = Logging.getLogger(DefaultExecHandle.class);
    private static final Joiner ARGUMENT_JOINER = Joiner.on((char)' ').useForNull("null");
    private final String displayName;
    private final File directory;
    private final String command;
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final StreamsHandler outputHandler;
    private final StreamsHandler inputHandler;
    private final boolean redirectErrorStream;
    private final ProcessLauncher processLauncher;
    private int timeoutMillis;
    private boolean daemon;
    private final Lock lock;
    private final Condition stateChanged;
    private final Executor executor;
    private ExecHandleState state;
    private ExecHandleRunner execHandleRunner;
    private ExecResultImpl execResult;
    private final ListenerBroadcast<ExecHandleListener> broadcast;
    private final ExecHandleShutdownHookAction shutdownHookAction;
    private final BuildCancellationToken buildCancellationToken;

    DefaultExecHandle(String displayName, File directory, String command, List<String> arguments, Map<String, String> environment, StreamsHandler outputHandler, StreamsHandler inputHandler, List<ExecHandleListener> listeners, boolean redirectErrorStream, int timeoutMillis, boolean daemon, Executor executor, BuildCancellationToken buildCancellationToken) {
        this.displayName = displayName;
        this.directory = directory;
        this.command = command;
        this.arguments = arguments;
        this.environment = environment;
        this.outputHandler = outputHandler;
        this.inputHandler = inputHandler;
        this.redirectErrorStream = redirectErrorStream;
        this.timeoutMillis = timeoutMillis;
        this.daemon = daemon;
        this.executor = executor;
        this.lock = new ReentrantLock();
        this.stateChanged = this.lock.newCondition();
        this.state = ExecHandleState.INIT;
        this.buildCancellationToken = buildCancellationToken;
        this.processLauncher = NativeServices.getInstance().get(ProcessLauncher.class);
        this.shutdownHookAction = new ExecHandleShutdownHookAction(this);
        this.broadcast = new ListenerBroadcast<ExecHandleListener>(ExecHandleListener.class);
        this.broadcast.addAll(listeners);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    @Override
    public ExecHandleState getState() {
        this.lock.lock();
        try {
            ExecHandleState execHandleState = this.state;
            return execHandleState;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setState(ExecHandleState state2) {
        this.lock.lock();
        try {
            LOGGER.debug("Changing state to: {}", (Object)state2);
            this.state = state2;
            this.stateChanged.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean stateIn(ExecHandleState ... states) {
        this.lock.lock();
        try {
            boolean bl = Arrays.asList(states).contains((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndStateInfo(ExecHandleState newState, int exitValue, Throwable failureCause) {
        ExecHandleState currentState;
        ShutdownHooks.removeShutdownHook(this.shutdownHookAction);
        this.buildCancellationToken.removeCallback(this.shutdownHookAction);
        this.lock.lock();
        try {
            currentState = this.state;
        }
        finally {
            this.lock.unlock();
        }
        ExecResultImpl newResult = new ExecResultImpl(exitValue, this.execExceptionFor(failureCause, currentState), this.displayName);
        if (!currentState.isTerminal() && newState != ExecHandleState.DETACHED) {
            try {
                this.broadcast.getSource().executionFinished(this, newResult);
            }
            catch (Exception e) {
                newResult = new ExecResultImpl(exitValue, this.execExceptionFor(e, currentState), this.displayName);
            }
        }
        this.lock.lock();
        try {
            this.setState(newState);
            this.execResult = newResult;
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.debug("Process '{}' finished with exit value {} (state: {})", new Object[]{this.displayName, exitValue, newState});
    }

    @Nullable
    private ExecException execExceptionFor(Throwable failureCause, ExecHandleState currentState) {
        return failureCause != null ? new ExecException(this.failureMessageFor(failureCause, currentState), failureCause) : null;
    }

    private String failureMessageFor(Throwable failureCause, ExecHandleState currentState) {
        if (currentState == ExecHandleState.STARTING) {
            if (LongCommandLineDetectionUtil.hasCommandLineExceedMaxLength(this.command, this.arguments) && LongCommandLineDetectionUtil.hasCommandLineExceedMaxLengthException(failureCause)) {
                return String.format("Process '%s' could not be started because the command line exceed operating system limits.", this.displayName);
            }
            return String.format("A problem occurred starting process '%s'", this.displayName);
        }
        return String.format("A problem occurred waiting for process '%s' to complete.", this.displayName);
    }

    @Override
    public ExecHandle start() {
        LOGGER.info("Starting process '{}'. Working directory: {} Command: {} {}", this.displayName, this.directory, this.command, ARGUMENT_JOINER.join(this.arguments));
        this.lock.lock();
        try {
            if (!this.stateIn(ExecHandleState.INIT)) {
                throw new IllegalStateException(String.format("Cannot start process '%s' because it has already been started", this.displayName));
            }
            this.setState(ExecHandleState.STARTING);
            this.execHandleRunner = new ExecHandleRunner(this, new CompositeStreamsHandler(), this.processLauncher, this.executor);
            this.executor.execute(new CurrentBuildOperationPreservingRunnable(this.execHandleRunner));
            while (this.stateIn(ExecHandleState.STARTING)) {
                LOGGER.debug("Waiting until process started: {}.", this.displayName);
                try {
                    this.stateChanged.await();
                }
                catch (InterruptedException e) {
                    this.execHandleRunner.abortProcess();
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            if (this.execResult != null) {
                this.execResult.rethrowFailure();
            }
            LOGGER.info("Successfully started process '{}'", this.displayName);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @Override
    public void abort() {
        this.lock.lock();
        try {
            if (this.stateIn(ExecHandleState.SUCCEEDED, ExecHandleState.FAILED, ExecHandleState.ABORTED)) {
                return;
            }
            if (!this.stateIn(ExecHandleState.STARTED, ExecHandleState.DETACHED)) {
                throw new IllegalStateException(String.format("Cannot abort process '%s' because it is not in started or detached state", this.displayName));
            }
            this.execHandleRunner.abortProcess();
            this.waitForFinish();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExecResult waitForFinish() {
        this.lock.lock();
        try {
            while (!this.state.isTerminal()) {
                try {
                    this.stateChanged.await();
                }
                catch (InterruptedException e) {
                    this.execHandleRunner.abortProcess();
                    throw UncheckedException.throwAsUncheckedException(e);
                    return this.result();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private ExecResult result() {
        this.lock.lock();
        try {
            ExecResult execResult = this.execResult.rethrowFailure();
            return execResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    void detached() {
        this.setEndStateInfo(ExecHandleState.DETACHED, 0, null);
    }

    void started() {
        ShutdownHooks.addShutdownHook(this.shutdownHookAction);
        this.buildCancellationToken.addCallback(this.shutdownHookAction);
        this.setState(ExecHandleState.STARTED);
        this.broadcast.getSource().executionStarted(this);
    }

    void finished(int exitCode) {
        if (exitCode != 0) {
            this.setEndStateInfo(ExecHandleState.FAILED, exitCode, null);
        } else {
            this.setEndStateInfo(ExecHandleState.SUCCEEDED, 0, null);
        }
    }

    void aborted(int exitCode) {
        if (exitCode == 0) {
            exitCode = -1;
        }
        this.setEndStateInfo(ExecHandleState.ABORTED, exitCode, null);
    }

    void failed(Throwable failureCause) {
        this.setEndStateInfo(ExecHandleState.FAILED, -1, failureCause);
    }

    @Override
    public void addListener(ExecHandleListener listener2) {
        this.broadcast.add(listener2);
    }

    @Override
    public void removeListener(ExecHandleListener listener2) {
        this.broadcast.remove(listener2);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean getRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    private class CompositeStreamsHandler
    implements StreamsHandler {
        private CompositeStreamsHandler() {
        }

        @Override
        public void connectStreams(Process process, String processName, Executor executor) {
            DefaultExecHandle.this.inputHandler.connectStreams(process, processName, executor);
            DefaultExecHandle.this.outputHandler.connectStreams(process, processName, executor);
        }

        @Override
        public void start() {
            DefaultExecHandle.this.inputHandler.start();
            DefaultExecHandle.this.outputHandler.start();
        }

        @Override
        public void stop() {
            DefaultExecHandle.this.outputHandler.stop();
            DefaultExecHandle.this.inputHandler.stop();
        }

        @Override
        public void disconnect() {
            DefaultExecHandle.this.outputHandler.disconnect();
            DefaultExecHandle.this.inputHandler.disconnect();
        }
    }

    private static class ExecResultImpl
    implements ExecResult {
        private final int exitValue;
        private final ExecException failure;
        private final String displayName;

        ExecResultImpl(int exitValue, ExecException failure, String displayName) {
            this.exitValue = exitValue;
            this.failure = failure;
            this.displayName = displayName;
        }

        @Override
        public int getExitValue() {
            return this.exitValue;
        }

        @Override
        public ExecResult assertNormalExitValue() throws ExecException {
            if (this.exitValue != 0) {
                throw new ExecException(String.format("Process '%s' finished with non-zero exit value %d", this.displayName, this.exitValue));
            }
            return this;
        }

        @Override
        public ExecResult rethrowFailure() throws ExecException {
            if (this.failure != null) {
                throw this.failure;
            }
            return this;
        }

        public String toString() {
            return "{exitValue=" + this.exitValue + ", failure=" + this.failure + "}";
        }
    }
}

