/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jacoco.AntJacocoReport;
import org.gradle.internal.jacoco.JacocoReportsContainerImpl;
import org.gradle.testing.jacoco.tasks.JacocoReportBase;
import org.gradle.testing.jacoco.tasks.JacocoReportsContainer;
import org.gradle.util.internal.ClosureBackedAction;

@CacheableTask
public class JacocoReport
extends JacocoReportBase
implements Reporting<JacocoReportsContainer> {
    private final Property<String> projectName = this.getProject().getObjects().property(String.class);
    private final JacocoReportsContainer reports;

    public JacocoReport() {
        this.projectName.value(this.getProject().getName()).disallowChanges();
        this.reports = this.getInstantiator().newInstance(JacocoReportsContainerImpl.class, this, this.getCallbackActionDecorator());
    }

    @Input
    public Property<String> getReportProjectName() {
        return this.projectName;
    }

    @Override
    @Nested
    public JacocoReportsContainer getReports() {
        return this.reports;
    }

    @Override
    public JacocoReportsContainer reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public JacocoReportsContainer reports(Action<? super JacocoReportsContainer> configureAction) {
        configureAction.execute(this.reports);
        return this.reports;
    }

    @TaskAction
    public void generate() {
        new AntJacocoReport(this.getAntBuilder()).execute(this.getJacocoClasspath(), (String)this.projectName.get(), this.getAllClassDirs().filter(File::exists), this.getAllSourceDirs().filter(File::exists), this.getExecutionData().filter(File::exists), this.getReports());
    }
}

