/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ClasspathHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;

public class InvocationExprent
extends Exprent {
    private static final int INVOKE_SPECIAL = 1;
    private static final int INVOKE_VIRTUAL = 2;
    private static final int INVOKE_STATIC = 3;
    private static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_DYNAMIC = 5;
    public static final int TYPE_GENERAL = 1;
    public static final int TYPE_INIT = 2;
    public static final int TYPE_CLINIT = 3;
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private String name;
    private String className;
    private boolean isStatic;
    private boolean canIgnoreBoxing = true;
    private int funcType = 1;
    private Exprent instance;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invokeDynamicClassSuffix;
    private int invocationType = 2;
    private List<Exprent> parameters = new ArrayList<Exprent>();
    private List<PooledConstant> bootstrapArguments;
    private static final Map<String, String> UNBOXING_METHODS = Map.of("booleanValue", "java/lang/Boolean", "byteValue", "java/lang/Byte", "shortValue", "java/lang/Short", "intValue", "java/lang/Integer", "longValue", "java/lang/Long", "floatValue", "java/lang/Float", "doubleValue", "java/lang/Double", "charValue", "java/lang/Character");

    public InvocationExprent() {
        super(8);
    }

    public InvocationExprent(int opcode, LinkConstant cn, List<PooledConstant> bootstrapArguments, ListStack<? extends Exprent> stack, Set<Integer> bytecodeOffsets) {
        this();
        this.name = cn.elementname;
        this.className = cn.classname;
        this.bootstrapArguments = bootstrapArguments;
        switch (opcode) {
            case 184: {
                this.invocationType = 3;
                break;
            }
            case 183: {
                this.invocationType = 1;
                break;
            }
            case 182: {
                this.invocationType = 2;
                break;
            }
            case 185: {
                this.invocationType = 4;
                break;
            }
            case 186: {
                this.invocationType = 5;
                this.className = "java/lang/Class";
                this.invokeDynamicClassSuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.funcType = 2;
        } else if ("<clinit>".equals(this.name)) {
            this.funcType = 3;
        }
        this.stringDescriptor = cn.descriptor;
        this.descriptor = MethodDescriptor.parseDescriptor(cn.descriptor);
        for (VarType ignored : this.descriptor.params) {
            this.parameters.add(0, stack.pop());
        }
        if (opcode == 186) {
            PooledConstant link;
            int dynamicInvocationType = -1;
            if (bootstrapArguments != null && bootstrapArguments.size() > 1 && (link = bootstrapArguments.get(1)) instanceof LinkConstant) {
                dynamicInvocationType = ((LinkConstant)link).index1;
            }
            if (dynamicInvocationType == 6) {
                this.isStatic = true;
            } else if (!this.parameters.isEmpty()) {
                this.instance = this.parameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    private InvocationExprent(InvocationExprent expr) {
        this();
        this.name = expr.getName();
        this.className = expr.getClassName();
        this.isStatic = expr.isStatic();
        this.canIgnoreBoxing = expr.canIgnoreBoxing;
        this.funcType = expr.getFuncType();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationType = expr.getInvocationType();
        this.invokeDynamicClassSuffix = expr.getInvokeDynamicClassSuffix();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        List<Exprent> parameters = expr.getParameters();
        this.parameters = new ArrayList<Exprent>(parameters.size());
        for (Exprent parameter : parameters) {
            this.parameters.add(parameter.copy());
        }
        this.addBytecodeOffsets(expr.bytecode);
        this.bootstrapArguments = expr.getBootstrapArguments();
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Exprent parameter = this.parameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.getTypeFamily()));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.parameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        int start;
        ClassesProcessor.ClassNode newNode;
        TextBuffer buf = new TextBuffer();
        String super_qualifier = null;
        boolean isInstanceThis = false;
        tracer.addMapping(this.bytecode);
        if (this.instance instanceof InvocationExprent) {
            ((InvocationExprent)this.instance).markUsingBoxingResult();
        }
        if (this.isStatic) {
            if (this.isBoxingCall() && this.canIgnoreBoxing) {
                ExprProcessor.getCastedExprent(this.parameters.get(0), this.descriptor.params[0], buf, indent, false, false, false, false, tracer);
                return buf;
            }
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.className.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getNestedNameInClassContext(ExprProcessor.buildJavaClassName(this.className)));
            }
        } else {
            if (this.instance != null && this.instance.type == 12) {
                MethodWrapper currentMethod;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair varPair = new VarVersionPair(instVar);
                VarProcessor varProc = instVar.getProcessor();
                if (varProc == null && (currentMethod = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER")) != null) {
                    varProc = currentMethod.varproc;
                }
                String this_classname = null;
                if (varProc != null) {
                    this_classname = varProc.getThisVars().get(varPair);
                }
                if (this_classname != null) {
                    isInstanceThis = true;
                    if (this.invocationType == 1 && !this.className.equals(this_classname)) {
                        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
                        boolean isInterface = cl != null && cl.hasModifier(512);
                        String string = super_qualifier = !isInterface ? this_classname : this.className;
                    }
                }
            }
            if (this.funcType == 1) {
                if (super_qualifier != null) {
                    TextUtil.writeQualifiedSuper(buf, super_qualifier);
                } else if (this.instance != null) {
                    TextBuffer res = this.instance.toJava(indent, tracer);
                    if (this.isUnboxingCall()) {
                        buf.append(res);
                        return buf;
                    }
                    VarType rightType = this.instance.getExprType();
                    VarType leftType = new VarType(8, 0, this.className);
                    if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType)) {
                        buf.append("((").append(ExprProcessor.getCastTypeName(leftType, Collections.emptyList())).append(")");
                        if (this.instance.getPrecedence() >= FunctionExprent.getPrecedence(29)) {
                            res.enclose("(", ")");
                        }
                        buf.append(res).append(")");
                    } else if (this.instance.getPrecedence() > this.getPrecedence()) {
                        buf.append("(").append(res).append(")");
                    } else {
                        buf.append(res);
                    }
                }
            }
        }
        switch (this.funcType) {
            case 1: {
                if ("<VAR_NAMELESS_ENCLOSURE>".equals(buf.toString())) {
                    buf = new TextBuffer();
                }
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(this.name);
                if (this.invocationType == 5) {
                    buf.append("<invokedynamic>");
                }
                buf.append("(");
                break;
            }
            case 3: {
                throw new RuntimeException("Explicit invocation of <clinit>");
            }
            case 2: {
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                if (this.instance != null) {
                    buf.append(this.instance.toJava(indent, tracer)).append(".<init>(");
                    break;
                }
                throw new RuntimeException("Unrecognized invocation of <init>");
            }
        }
        List<VarVersionPair> mask = null;
        boolean isEnum = false;
        if (this.funcType == 2 && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.className)) != null) {
            mask = ExprUtil.getSyntheticParametersMask(newNode, this.stringDescriptor, this.parameters.size());
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("den");
        }
        BitSet setAmbiguousParameters = this.getAmbiguousParameters();
        if (this.parameters.size() == this.descriptor.params.length && this.isVarArgCall()) {
            Exprent lastParam = this.parameters.get(this.parameters.size() - 1);
            if (lastParam.type == 10 && lastParam.getExprType().getArrayDim() >= 1) {
                ((NewExprent)lastParam).setVarArgParam(true);
            }
        }
        boolean firstParameter = true;
        for (int i = start = isEnum ? 2 : 0; i < this.parameters.size(); ++i) {
            if (mask != null && mask.get(i) != null) continue;
            TextBuffer buff = new TextBuffer();
            boolean ambiguous = setAmbiguousParameters.get(i);
            ExprProcessor.getCastedExprent(this.parameters.get(i), this.descriptor.params[i], buff, indent, true, ambiguous, true, true, tracer);
            if (buff.length() > 0) {
                if (!firstParameter) {
                    buf.append(", ");
                }
                buf.append(buff);
            }
            firstParameter = false;
        }
        buf.append(')');
        return buf;
    }

    private boolean isVarArgCall() {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
        if (cl != null) {
            StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
            if (mt != null) {
                return mt.hasModifier(128);
            }
        } else {
            Method mtd = ClasspathHelper.findMethod(this.className, this.name, this.descriptor);
            return mtd != null && mtd.isVarArgs();
        }
        return false;
    }

    public boolean isBoxingCall() {
        if (this.isStatic && "valueOf".equals(this.name) && this.parameters.size() == 1) {
            int paramType = this.parameters.get(0).getExprType().getType();
            if (this.parameters.get((int)0).type == 3) {
                if (this.parameters.get(0).getExprType().getTypeFamily() == 2 && this.className.equals("java/lang/Integer")) {
                    return true;
                }
                if ((paramType == 15 || paramType == 16) && this.className.equals("java/lang/Character")) {
                    return true;
                }
            }
            return this.className.equals(InvocationExprent.getClassNameForPrimitiveType(paramType));
        }
        return false;
    }

    public boolean isInstanceCall(@NotNull String className, @NotNull String methodName, int parametersCount) {
        if (className == null) {
            InvocationExprent.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            InvocationExprent.$$$reportNull$$$0(1);
        }
        return this.invocationType == 2 && this.className.equals(className) && methodName.equals(this.name) && this.parameters.size() == parametersCount;
    }

    public void markUsingBoxingResult() {
        this.canIgnoreBoxing = false;
    }

    private static String getClassNameForPrimitiveType(int type) {
        switch (type) {
            case 7: {
                return "java/lang/Boolean";
            }
            case 0: 
            case 15: {
                return "java/lang/Byte";
            }
            case 1: {
                return "java/lang/Character";
            }
            case 6: 
            case 16: {
                return "java/lang/Short";
            }
            case 4: {
                return "java/lang/Integer";
            }
            case 5: {
                return "java/lang/Long";
            }
            case 3: {
                return "java/lang/Float";
            }
            case 2: {
                return "java/lang/Double";
            }
        }
        return null;
    }

    private boolean isUnboxingCall() {
        return !this.isStatic && this.parameters.size() == 0 && this.className.equals(UNBOXING_METHODS.get(this.name));
    }

    private BitSet getAmbiguousParameters() {
        int i;
        StructClass cl = DecompilerContext.getStructContext().getClass(this.className);
        if (cl == null) {
            return EMPTY_BIT_SET;
        }
        ArrayList<MethodDescriptor> matches = new ArrayList<MethodDescriptor>();
        block0: for (StructMethod mt : cl.getMethods()) {
            if (!this.name.equals(mt.getName())) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length != this.descriptor.params.length) continue;
            for (i = 0; i < md.params.length; ++i) {
                if (md.params[i].getTypeFamily() != this.descriptor.params[i].getTypeFamily()) continue block0;
            }
            matches.add(md);
        }
        if (matches.size() == 1) {
            return EMPTY_BIT_SET;
        }
        StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
        if (mt != null) {
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length == this.parameters.size()) {
                boolean exact = true;
                for (i = 0; i < md.params.length; ++i) {
                    if (md.params[i].equals(this.parameters.get(i).getExprType())) continue;
                    exact = false;
                    break;
                }
                if (exact) {
                    return EMPTY_BIT_SET;
                }
            }
        }
        BitSet ambiguous = new BitSet(this.descriptor.params.length);
        block3: for (int i2 = 0; i2 < this.descriptor.params.length; ++i2) {
            VarType paramType = this.descriptor.params[i2];
            for (MethodDescriptor md : matches) {
                if (paramType.equals(md.params[i2])) continue;
                ambiguous.set(i2);
                continue block3;
            }
        }
        return ambiguous;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (oldExpr != this.parameters.get(i)) continue;
            this.parameters.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return Objects.equals(this.name, it.name) && Objects.equals(this.className, it.className) && this.isStatic == it.isStatic && Objects.equals(this.instance, it.instance) && Objects.equals(this.descriptor, it.descriptor) && this.funcType == it.funcType && Objects.equals(this.parameters, it.parameters);
    }

    public List<Exprent> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Exprent> parameters) {
        this.parameters = parameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public int getFuncType() {
        return this.funcType;
    }

    public void setFuncType(int funcType) {
        this.funcType = funcType;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public int getInvocationType() {
        return this.invocationType;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invokeDynamicClassSuffix;
    }

    public List<PooledConstant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        for (Map.Entry<IMatchable.MatchProperties, MatchNode.RuleValue> rule : matchNode.getRules().entrySet()) {
            MatchNode.RuleValue value = rule.getValue();
            IMatchable.MatchProperties key = rule.getKey();
            if (!(key == IMatchable.MatchProperties.EXPRENT_INVOCATION_PARAMETER ? value.isVariable() && (value.parameter >= this.parameters.size() || !engine.checkAndSetVariableValue(value.value.toString(), this.parameters.get(value.parameter))) : (key == IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS ? !value.value.equals(this.className) : key == IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE && !value.value.equals(this.name + this.stringDescriptor)))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "methodName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/java/decompiler/modules/decompiler/exps/InvocationExprent";
        objectArray[2] = "isInstanceCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

