/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import java.util.Objects;
import org.jetbrains.java.decompiler.struct.gen.Type;

public class VarType
implements Type {
    public static final VarType[] EMPTY_ARRAY = new VarType[0];
    public static final VarType VARTYPE_UNKNOWN = new VarType(17);
    public static final VarType VARTYPE_INT = new VarType(4);
    public static final VarType VARTYPE_FLOAT = new VarType(3);
    public static final VarType VARTYPE_LONG = new VarType(5);
    public static final VarType VARTYPE_DOUBLE = new VarType(2);
    public static final VarType VARTYPE_BYTE = new VarType(0);
    public static final VarType VARTYPE_CHAR = new VarType(1);
    public static final VarType VARTYPE_SHORT = new VarType(6);
    public static final VarType VARTYPE_BOOLEAN = new VarType(7);
    public static final VarType VARTYPE_BYTECHAR = new VarType(15);
    public static final VarType VARTYPE_SHORTCHAR = new VarType(16);
    public static final VarType VARTYPE_NULL = new VarType(13, 0, null);
    public static final VarType VARTYPE_STRING = new VarType(8, 0, "java/lang/String");
    public static final VarType VARTYPE_CLASS = new VarType(8, 0, "java/lang/Class");
    public static final VarType VARTYPE_OBJECT = new VarType(8, 0, "java/lang/Object");
    public static final VarType VARTYPE_INTEGER = new VarType(8, 0, "java/lang/Integer");
    public static final VarType VARTYPE_CHARACTER = new VarType(8, 0, "java/lang/Character");
    public static final VarType VARTYPE_BYTE_OBJ = new VarType(8, 0, "java/lang/Byte");
    public static final VarType VARTYPE_SHORT_OBJ = new VarType(8, 0, "java/lang/Short");
    public static final VarType VARTYPE_VOID = new VarType(10);
    private final int type;
    private final int arrayDim;
    private final String value;
    private final int typeFamily;
    private final int stackSize;
    private final boolean falseBoolean;

    public VarType(int type) {
        this(type, 0);
    }

    public VarType(int type, int arrayDim) {
        this(type, arrayDim, VarType.getChar(type));
    }

    public VarType(int type, int arrayDim, String value) {
        this(type, arrayDim, value, VarType.getFamily(type, arrayDim), VarType.getStackSize(type, arrayDim), false);
    }

    private VarType(int type, int arrayDim, String value, int typeFamily, int stackSize, boolean falseBoolean) {
        this.type = type;
        this.arrayDim = arrayDim;
        this.value = value;
        this.typeFamily = typeFamily;
        this.stackSize = stackSize;
        this.falseBoolean = falseBoolean;
    }

    public VarType(String signature) {
        this(signature, false);
    }

    public VarType(String signature, boolean clType) {
        int type = 0;
        int arrayDim = 0;
        String value = null;
        block4: for (int i = 0; i < signature.length(); ++i) {
            switch (signature.charAt(i)) {
                case '[': {
                    ++arrayDim;
                    continue block4;
                }
                case 'L': {
                    if (signature.charAt(signature.length() - 1) == ';') {
                        type = 8;
                        value = signature.substring(i + 1, signature.length() - 1);
                        break block4;
                    }
                }
                default: {
                    value = signature.substring(i);
                    if (clType && i == 0 || value.length() > 1) {
                        type = 8;
                        break block4;
                    }
                    type = VarType.getType(value.charAt(0));
                    break block4;
                }
            }
        }
        this.type = type;
        this.arrayDim = arrayDim;
        this.value = value;
        this.typeFamily = VarType.getFamily(type, arrayDim);
        this.stackSize = VarType.getStackSize(type, arrayDim);
        this.falseBoolean = false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getArrayDim() {
        return this.arrayDim;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int getTypeFamily() {
        return this.typeFamily;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    private static String getChar(int type) {
        switch (type) {
            case 0: {
                return "B";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "D";
            }
            case 3: {
                return "F";
            }
            case 4: {
                return "I";
            }
            case 5: {
                return "J";
            }
            case 6: {
                return "S";
            }
            case 7: {
                return "Z";
            }
            case 10: {
                return "V";
            }
            case 12: {
                return "G";
            }
            case 14: {
                return "N";
            }
            case 9: {
                return "A";
            }
            case 15: {
                return "X";
            }
            case 16: {
                return "Y";
            }
            case 17: {
                return "U";
            }
            case 8: 
            case 13: {
                return null;
            }
        }
        throw new RuntimeException("Invalid type");
    }

    private static int getStackSize(int type, int arrayDim) {
        if (arrayDim > 0) {
            return 1;
        }
        switch (type) {
            case 2: 
            case 5: {
                return 2;
            }
            case 10: 
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    private static int getFamily(int type, int arrayDim) {
        if (arrayDim > 0) {
            return 6;
        }
        switch (type) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 15: 
            case 16: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 7: {
                return 1;
            }
            case 8: 
            case 13: {
                return 6;
            }
        }
        return 0;
    }

    public VarType decreaseArrayDim() {
        if (this.getArrayDim() > 0) {
            return new VarType(this.getType(), this.getArrayDim() - 1, this.getValue());
        }
        return this;
    }

    public VarType resizeArrayDim(int newArrayDim) {
        return new VarType(this.getType(), newArrayDim, this.getValue(), this.getTypeFamily(), this.getStackSize(), this.isFalseBoolean());
    }

    public VarType copy() {
        return this.copy(false);
    }

    public VarType copy(boolean forceFalseBoolean) {
        return new VarType(this.getType(), this.getArrayDim(), this.getValue(), this.getTypeFamily(), this.getStackSize(), this.isFalseBoolean() || forceFalseBoolean);
    }

    public boolean isFalseBoolean() {
        return this.falseBoolean;
    }

    public boolean isSuperset(VarType val) {
        return this.equals(val) || this.isStrictSuperset(val);
    }

    public boolean isStrictSuperset(VarType val) {
        int valType = val.getType();
        if (valType == 17 && this.getType() != 17) {
            return true;
        }
        if (val.getArrayDim() > 0) {
            return this.equals(VARTYPE_OBJECT);
        }
        if (this.getArrayDim() > 0) {
            return valType == 13;
        }
        boolean res = false;
        switch (this.getType()) {
            case 4: {
                res = valType == 6 || valType == 1;
            }
            case 6: {
                res |= valType == 0;
            }
            case 1: {
                res |= valType == 16;
            }
            case 0: 
            case 16: {
                res |= valType == 15;
            }
            case 15: {
                res |= valType == 7;
                break;
            }
            case 8: {
                if (valType == 13) {
                    return true;
                }
                if (!this.equals(VARTYPE_OBJECT)) break;
                return valType == 8 && !val.equals(VARTYPE_OBJECT);
            }
        }
        return res;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VarType)) {
            return false;
        }
        VarType vt = (VarType)o;
        return this.getType() == vt.getType() && this.getArrayDim() == vt.getArrayDim() && Objects.equals(this.getValue(), vt.getValue());
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.getArrayDim(); ++i) {
            res.append('[');
        }
        if (this.getType() == 8) {
            res.append('L').append(this.getValue()).append(';');
        } else {
            res.append(this.getValue());
        }
        return res.toString();
    }

    public static VarType getCommonMinType(VarType type1, VarType type2) {
        if (type1.getType() == 7 && type2.getType() == 7) {
            return type1.isFalseBoolean() ? type2 : type1;
        }
        if (type1.isSuperset(type2)) {
            return type2;
        }
        if (type2.isSuperset(type1)) {
            return type1;
        }
        if (type1.getTypeFamily() == type2.getTypeFamily()) {
            switch (type1.getTypeFamily()) {
                case 2: {
                    if (type1.getType() == 1 && type2.getType() == 6 || type1.getType() == 6 && type2.getType() == 1) {
                        return VARTYPE_SHORTCHAR;
                    }
                    return VARTYPE_BYTECHAR;
                }
                case 6: {
                    return VARTYPE_NULL;
                }
            }
        }
        return null;
    }

    public static VarType getCommonSupertype(VarType type1, VarType type2) {
        if (type1.getType() == 7 && type2.getType() == 7) {
            return type1.isFalseBoolean() ? type1 : type2;
        }
        if (type1.isSuperset(type2)) {
            return type1;
        }
        if (type2.isSuperset(type1)) {
            return type2;
        }
        if (type1.getTypeFamily() == type2.getTypeFamily()) {
            switch (type1.getTypeFamily()) {
                case 2: {
                    if (type1.getType() == 16 && type2.getType() == 0 || type1.getType() == 0 && type2.getType() == 16) {
                        return VARTYPE_SHORT;
                    }
                    return VARTYPE_INT;
                }
                case 6: {
                    return VARTYPE_OBJECT;
                }
            }
        }
        return null;
    }

    public static VarType getMinTypeInFamily(int family) {
        switch (family) {
            case 1: {
                return VARTYPE_BOOLEAN;
            }
            case 2: {
                return VARTYPE_BYTECHAR;
            }
            case 6: {
                return VARTYPE_NULL;
            }
            case 3: {
                return VARTYPE_FLOAT;
            }
            case 4: {
                return VARTYPE_LONG;
            }
            case 5: {
                return VARTYPE_DOUBLE;
            }
            case 0: {
                return VARTYPE_UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Invalid type family: " + family);
    }

    public static int getType(char c) {
        switch (c) {
            case 'B': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'F': {
                return 3;
            }
            case 'I': {
                return 4;
            }
            case 'J': {
                return 5;
            }
            case 'S': {
                return 6;
            }
            case 'Z': {
                return 7;
            }
            case 'V': {
                return 10;
            }
            case 'G': {
                return 12;
            }
            case 'N': {
                return 14;
            }
            case 'A': {
                return 9;
            }
            case 'X': {
                return 15;
            }
            case 'Y': {
                return 16;
            }
            case 'U': {
                return 17;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + c);
    }
}

