/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.RTPLevelRelayType;
import org.jitsi.xmpp.extensions.colibri.SimulcastMode;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityBareJid;

public class ColibriConferenceIQ
extends IQ {
    public static final String ELEMENT = "conference";
    public static final String ID_ATTR_NAME = "id";
    public static final String GID_ATTR_NAME = "gid";
    public static final String NAME_ATTR_NAME = "name";
    public static final String MEETING_ID_ATTR_NAME = "meeting-id";
    public static final String RTCSTATS_ENABLED_ATTR_NAME = "rtcstats-enabled";
    public static final String CALLSTATS_ENABLED_ATTR_NAME = "callstats-enabled";
    public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";
    private static final Logger logger = new LoggerImpl(ColibriConferenceIQ.class.getName());
    public static final int[] NO_SSRCS = new int[0];
    private final Map<String, ChannelBundle> channelBundles = new ConcurrentHashMap<String, ChannelBundle>();
    private final List<Content> contents = new LinkedList<Content>();
    private final Map<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();
    private String id;
    private String gid;
    private Recording recording;
    private RTCPTerminationStrategy rtcpTerminationStrategy;
    private boolean gracefulShutdown;
    private EntityBareJid name;
    private String meetingId;
    private boolean rtcstatsEnabled = true;
    private boolean callstatsEnabled = true;

    public static IQ createGracefulShutdownErrorResponse(IQ request) {
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.service_unavailable).setType(StanzaError.Type.CANCEL).addExtension(new GracefulShutdown())).build();
        ErrorIQ result2 = IQ.createErrorResponse(request, error);
        result2.setType(IQ.Type.error);
        result2.setStanzaId(request.getStanzaId());
        result2.setFrom(request.getTo());
        result2.setTo(request.getFrom());
        return result2;
    }

    public ColibriConferenceIQ() {
        super(ELEMENT, NAMESPACE);
    }

    public ChannelBundle addChannelBundle(ChannelBundle channelBundle) {
        Objects.requireNonNull(channelBundle, "channelBundle");
        String id = Objects.requireNonNull(channelBundle.getId(), "channelBundle ID");
        return this.channelBundles.put(id, channelBundle);
    }

    public boolean addContent(Content content) {
        Objects.requireNonNull(content, "content");
        return !this.contents.contains(content) && this.contents.add(content);
    }

    public boolean addContent(String contentName) {
        return this.addContent(new Content(contentName));
    }

    public Endpoint addEndpoint(Endpoint endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        String id = Objects.requireNonNull(endpoint.getId(), "endpoint ID");
        return this.endpoints.put(id, endpoint);
    }

    public List<ChannelBundle> getChannelBundles() {
        return new LinkedList<ChannelBundle>(this.channelBundles.values());
    }

    public ChannelBundle getChannelBundle(String channelBundleId) {
        Objects.requireNonNull(channelBundleId, "channelBundleId");
        return this.channelBundles.get(channelBundleId);
    }

    public Endpoint getEndpoint(String endpointId) {
        if (endpointId == null) {
            return null;
        }
        return this.endpoints.get(endpointId);
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        boolean hasChildren;
        xml.optAttribute(ID_ATTR_NAME, this.getID());
        xml.optAttribute(GID_ATTR_NAME, this.getGID());
        xml.optAttribute(NAME_ATTR_NAME, this.name);
        xml.optAttribute(MEETING_ID_ATTR_NAME, this.meetingId);
        xml.attribute(RTCSTATS_ENABLED_ATTR_NAME, this.rtcstatsEnabled);
        xml.attribute(CALLSTATS_ENABLED_ATTR_NAME, this.callstatsEnabled);
        List<Content> contents = this.getContents();
        List<ChannelBundle> channelBundles = this.getChannelBundles();
        List<Endpoint> endpoints = this.getEndpoints();
        boolean bl = hasChildren = this.recording != null || this.rtcpTerminationStrategy != null || this.gracefulShutdown || contents.size() > 0 || channelBundles.size() > 0 || endpoints.size() > 0;
        if (!hasChildren) {
            xml.setEmptyElement();
        } else {
            xml.rightAngleBracket();
            for (Content content : contents) {
                content.toXML(xml);
            }
            for (ChannelBundle channelBundle : channelBundles) {
                channelBundle.toXML(xml);
            }
            for (Endpoint endpoint : endpoints) {
                endpoint.toXML(xml);
            }
            if (this.recording != null) {
                this.recording.toXML(xml);
            }
            if (this.rtcpTerminationStrategy != null) {
                this.rtcpTerminationStrategy.toXML(xml);
            }
            if (this.gracefulShutdown) {
                xml.append(new GracefulShutdown().toXML());
            }
        }
        return xml;
    }

    public Content getContent(String contentName) {
        for (Content content : this.getContents()) {
            if (!contentName.equals(content.getName())) continue;
            return content;
        }
        return null;
    }

    public List<Content> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public List<Endpoint> getEndpoints() {
        return new LinkedList<Endpoint>(this.endpoints.values());
    }

    public String getID() {
        return this.id;
    }

    public String getGID() {
        return this.gid;
    }

    public Content getOrCreateContent(String contentName) {
        Content content = this.getContent(contentName);
        if (content == null) {
            content = new Content(contentName);
            this.addContent(content);
        }
        return content;
    }

    public Recording getRecording() {
        return this.recording;
    }

    public RTCPTerminationStrategy getRTCPTerminationStrategy() {
        return this.rtcpTerminationStrategy;
    }

    public boolean removeContent(Content content) {
        return this.contents.remove(content);
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setGID(String gid) {
        this.gid = gid;
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public void setRTCPTerminationStrategy(RTCPTerminationStrategy rtcpTerminationStrategy) {
        this.rtcpTerminationStrategy = rtcpTerminationStrategy;
    }

    public void setGracefulShutdown(boolean isGracefulShutdown) {
        this.gracefulShutdown = isGracefulShutdown;
    }

    public boolean isGracefulShutdown() {
        return this.gracefulShutdown;
    }

    public EntityBareJid getName() {
        return this.name;
    }

    public void setName(EntityBareJid name) {
        this.name = name;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public void setMeetingId(String meetingId2) {
        this.meetingId = meetingId2;
    }

    public boolean isRtcStatsEnabled() {
        return this.rtcstatsEnabled;
    }

    public void setRtcStatsEnabled(boolean rtcstatsEnabled) {
        this.rtcstatsEnabled = rtcstatsEnabled;
    }

    public boolean isCallStatsEnabled() {
        return this.callstatsEnabled;
    }

    public void setCallStatsEnabled(boolean callstatsEnabled) {
        this.callstatsEnabled = callstatsEnabled;
    }

    public static class SctpConnection
    extends ChannelCommon {
        public static final String ELEMENT = "sctpconnection";
        public static final String PORT_ATTR_NAME = "port";
        private int port = 5000;

        public SctpConnection() {
            super(ELEMENT);
        }

        public int getPort() {
            return this.port;
        }

        @Override
        protected boolean hasContent() {
            return false;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder printAttributes(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute(PORT_ATTR_NAME, this.getPort());
            return xml;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder printContent(IQ.IQChildElementXmlStringBuilder xml) {
            return xml;
        }

        public void setPort(int port2) {
            this.port = port2;
        }
    }

    public static class RTCPTerminationStrategy {
        public static final String ELEMENT = "rtcp-termination-strategy";
        public static final String NAME_ATTR_NAME = "name";
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public IQ.IQChildElementXmlStringBuilder toXML(IQ.IQChildElementXmlStringBuilder xml) {
            xml.halfOpenElement(ELEMENT).attribute("name", this.name).closeEmptyElement();
            return xml;
        }
    }

    public static class GracefulShutdown
    extends AbstractPacketExtension {
        public static final String ELEMENT = "graceful-shutdown";
        public static final String NAMESPACE = "http://jitsi.org/protocol/colibri";

        public GracefulShutdown() {
            super("http://jitsi.org/protocol/colibri", ELEMENT);
        }
    }

    public static class Recording {
        public static final String ELEMENT = "recording";
        public static final String DIRECTORY_ATTR_NAME = "directory";
        public static final String STATE_ATTR_NAME = "state";
        public static final String TOKEN_ATTR_NAME = "token";
        private String directory;
        private final State state;
        private String token;

        public Recording(String state) {
            this.state = State.parseString(state);
        }

        public Recording(State state) {
            this.state = state;
        }

        public Recording(String state, String token) {
            this(State.parseString(state), token);
        }

        public Recording(State state, String token) {
            this(state);
            this.token = token;
        }

        public String getDirectory() {
            return this.directory;
        }

        public State getState() {
            return this.state;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public IQ.IQChildElementXmlStringBuilder toXML(IQ.IQChildElementXmlStringBuilder xml) {
            xml.halfOpenElement(ELEMENT).attribute(STATE_ATTR_NAME, this.state.toString()).optAttribute(TOKEN_ATTR_NAME, this.token).optAttribute(DIRECTORY_ATTR_NAME, this.directory).closeEmptyElement();
            return xml;
        }

        public static enum State {
            ON("on"),
            OFF("off"),
            PENDING("pending");

            private String name;

            private State(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }

            public static State parseString(String s2) {
                if (ON.toString().equalsIgnoreCase(s2)) {
                    return ON;
                }
                if (PENDING.toString().equalsIgnoreCase(s2)) {
                    return PENDING;
                }
                return OFF;
            }
        }
    }

    public static class Endpoint {
        public static final String DISPLAYNAME_ATTR_NAME = "displayname";
        public static final String ELEMENT = "endpoint";
        public static final String ID_ATTR_NAME = "id";
        public static final String STATS_ID_ATTR_NAME = "stats-id";
        private String displayName;
        private String id;
        private String statsId;

        public Endpoint(String id, String statsId, String displayName) {
            this.id = id;
            this.statsId = statsId;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }

        public String getStatsId() {
            return this.statsId;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setStatsId(String statsId) {
            this.statsId = statsId;
        }

        public IQ.IQChildElementXmlStringBuilder toXML(IQ.IQChildElementXmlStringBuilder xml) {
            xml.halfOpenElement(ELEMENT).attribute("id", this.id);
            xml.optAttribute(DISPLAYNAME_ATTR_NAME, this.displayName);
            xml.optAttribute(STATS_ID_ATTR_NAME, this.statsId);
            xml.closeEmptyElement();
            return xml;
        }
    }

    public static class Content {
        public static final String ELEMENT = "content";
        public static final String NAME_ATTR_NAME = "name";
        private final List<Channel> channels = new LinkedList<Channel>();
        private String name;
        private final List<SctpConnection> sctpConnections = new LinkedList<SctpConnection>();

        public Content() {
        }

        public Content(String name) {
            this.setName(name);
        }

        public boolean addChannel(Channel channel) {
            Objects.requireNonNull(channel, "channel");
            return !this.channels.contains(channel) && this.channels.add(channel);
        }

        public boolean addChannelCommon(ChannelCommon channelCommon) {
            if (channelCommon instanceof Channel) {
                return this.addChannel((Channel)channelCommon);
            }
            return this.addSctpConnection((SctpConnection)channelCommon);
        }

        public boolean addSctpConnection(SctpConnection conn) {
            Objects.requireNonNull(conn, "conn");
            return !this.sctpConnections.contains(conn) && this.sctpConnections.add(conn);
        }

        public Channel getChannel(int channelIndex) {
            return this.getChannels().get(channelIndex);
        }

        public Channel getChannel(String channelID) {
            for (Channel channel : this.getChannels()) {
                if (!channelID.equals(channel.getID())) continue;
                return channel;
            }
            return null;
        }

        public SctpConnection getSctpConnection(String connectionID) {
            for (SctpConnection conn : this.getSctpConnections()) {
                if (!connectionID.equals(conn.getID())) continue;
                return conn;
            }
            return null;
        }

        public int getChannelCount() {
            return this.getChannels().size();
        }

        public List<Channel> getChannels() {
            return Collections.unmodifiableList(this.channels);
        }

        public String getName() {
            return this.name;
        }

        public List<SctpConnection> getSctpConnections() {
            return Collections.unmodifiableList(this.sctpConnections);
        }

        public boolean removeChannel(Channel channel) {
            return this.channels.remove(channel);
        }

        public void setName(String name) {
            Objects.requireNonNull(name, "name");
            this.name = name;
        }

        public IQ.IQChildElementXmlStringBuilder toXML(IQ.IQChildElementXmlStringBuilder xml) {
            xml.halfOpenElement(ELEMENT).attribute("name", this.getName());
            List<Channel> channels = this.getChannels();
            List<SctpConnection> connections = this.getSctpConnections();
            if (channels.size() == 0 && connections.size() == 0) {
                xml.closeEmptyElement();
            } else {
                xml.rightAngleBracket();
                for (Channel channel : channels) {
                    channel.toXML(xml);
                }
                for (SctpConnection conn : connections) {
                    conn.toXML(xml);
                }
                xml.closeElement(ELEMENT);
            }
            return xml;
        }

        public boolean removeSctpConnection(SctpConnection connection) {
            return this.sctpConnections.remove(connection);
        }
    }

    public static abstract class ChannelCommon {
        public static final String CHANNEL_BUNDLE_ID_ATTR_NAME = "channel-bundle-id";
        public static final String ENDPOINT_ATTR_NAME = "endpoint";
        public static final String EXPIRE_ATTR_NAME = "expire";
        public static final int EXPIRE_NOT_SPECIFIED = -1;
        public static final String ID_ATTR_NAME = "id";
        public static final String INITIATOR_ATTR_NAME = "initiator";
        public static final String TYPE_ATTR_NAME = "type";
        private String channelBundleId = null;
        private String elementName;
        private String endpoint;
        private String type;
        private int expire = -1;
        private String id;
        private Boolean initiator;
        private IceUdpTransportPacketExtension transport;

        protected ChannelCommon(String elementName) {
            this.elementName = elementName;
        }

        public String getChannelBundleId() {
            return this.channelBundleId;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getType() {
            return this.type;
        }

        public int getExpire() {
            return this.expire;
        }

        public String getID() {
            return this.id;
        }

        public IceUdpTransportPacketExtension getTransport() {
            return this.transport;
        }

        protected abstract boolean hasContent();

        public Boolean isInitiator() {
            return this.initiator;
        }

        protected abstract IQ.IQChildElementXmlStringBuilder printAttributes(IQ.IQChildElementXmlStringBuilder var1);

        protected abstract IQ.IQChildElementXmlStringBuilder printContent(IQ.IQChildElementXmlStringBuilder var1);

        public void setChannelBundleId(String channelBundleId) {
            this.channelBundleId = channelBundleId;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setType(String type2) {
            this.type = type2;
        }

        public void setExpire(int expire2) {
            if (expire2 != -1 && expire2 < 0) {
                throw new IllegalArgumentException(EXPIRE_ATTR_NAME);
            }
            this.expire = expire2;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setInitiator(Boolean initiator) {
            this.initiator = initiator;
        }

        public void setTransport(IceUdpTransportPacketExtension transport) {
            this.transport = transport;
        }

        public IQ.IQChildElementXmlStringBuilder toXML(IQ.IQChildElementXmlStringBuilder xml) {
            boolean hasTransport;
            xml.halfOpenElement(this.elementName).optAttribute(ENDPOINT_ATTR_NAME, this.getEndpoint()).optIntAttribute(EXPIRE_ATTR_NAME, this.getExpire()).optAttribute("id", this.getID()).optAttribute(TYPE_ATTR_NAME, this.getType()).optBooleanAttribute(INITIATOR_ATTR_NAME, this.isInitiator() != null && this.isInitiator() != false).optAttribute(CHANNEL_BUNDLE_ID_ATTR_NAME, this.getChannelBundleId());
            this.printAttributes(xml);
            IceUdpTransportPacketExtension transport = this.getTransport();
            boolean bl = hasTransport = transport != null;
            if (hasTransport || this.hasContent()) {
                xml.rightAngleBracket();
                if (this.hasContent()) {
                    this.printContent(xml);
                }
                if (hasTransport) {
                    xml.append(transport.toXML());
                }
                xml.closeElement(this.elementName);
            } else {
                xml.closeEmptyElement();
            }
            return xml;
        }
    }

    public static class ChannelBundle {
        public static final String ELEMENT = "channel-bundle";
        public static final String ID_ATTR_NAME = "id";
        private String id;
        private IceUdpTransportPacketExtension transport;

        public ChannelBundle(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public IceUdpTransportPacketExtension getTransport() {
            return this.transport;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setTransport(IceUdpTransportPacketExtension transport) {
            this.transport = transport;
        }

        public IQ.IQChildElementXmlStringBuilder toXML(IQ.IQChildElementXmlStringBuilder xml) {
            xml.halfOpenElement(ELEMENT).attribute("id", this.id);
            if (this.transport != null) {
                xml.rightAngleBracket();
                xml.append(this.transport.toXML());
                xml.closeElement(ELEMENT);
            } else {
                xml.closeEmptyElement();
            }
            return xml;
        }
    }

    public static class OctoChannel
    extends Channel {
        public static final String TYPE = "octo";
        public static final String RELAY_ELEMENT = "relay";
        public static final String RELAY_ID_ATTR_NAME = "id";
        private List<String> relays = new LinkedList<String>();

        public OctoChannel() {
            this.setType(TYPE);
        }

        public void setRelays(List<String> relays) {
            this.relays = new LinkedList<String>(relays);
        }

        public List<String> getRelays() {
            return this.relays;
        }

        public void addRelay(String relay) {
            if (!this.relays.contains(relay)) {
                this.relays.add(relay);
            }
        }

        public void removeRelay(String relay) {
            this.relays.remove(relay);
        }

        @Override
        protected boolean hasContent() {
            return !this.relays.isEmpty() || super.hasContent();
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder printContent(IQ.IQChildElementXmlStringBuilder xml) {
            super.printContent(xml);
            for (String relay : this.relays) {
                xml.halfOpenElement(RELAY_ELEMENT).attribute("id", relay).closeEmptyElement();
            }
            return xml;
        }
    }

    public static class Channel
    extends ChannelCommon {
        public static final String DIRECTION_ATTR_NAME = "direction";
        public static final String ELEMENT = "channel";
        @Deprecated
        public static final String HOST_ATTR_NAME = "host";
        public static final String LAST_N_ATTR_NAME = "last-n";
        public static final String SIMULCAST_MODE_ATTR_NAME = "simulcast-mode";
        public static final String RECEIVING_SIMULCAST_LAYER = "receive-simulcast-layer";
        public static final String PACKET_DELAY_ATTR_NAME = "packet-delay";
        @Deprecated
        public static final String RTCP_PORT_ATTR_NAME = "rtcpport";
        public static final String RTP_LEVEL_RELAY_TYPE_ATTR_NAME = "rtp-level-relay-type";
        @Deprecated
        public static final String RTP_PORT_ATTR_NAME = "rtpport";
        public static final String SSRC_ELEMENT = "ssrc";
        private String direction;
        private static final String SENDRECV = "sendrecv";
        @Deprecated
        private String host;
        private Integer lastN;
        private SimulcastMode simulcastMode;
        private Integer packetDelay;
        private final List<PayloadTypePacketExtension> payloadTypes = new ArrayList<PayloadTypePacketExtension>();
        private final Map<Integer, RTPHdrExtPacketExtension> rtpHeaderExtensions = new HashMap<Integer, RTPHdrExtPacketExtension>();
        private Integer receivingSimulcastLayer;
        @Deprecated
        private int rtcpPort;
        private RTPLevelRelayType rtpLevelRelayType;
        @Deprecated
        private int rtpPort;
        private List<SourceGroupPacketExtension> sourceGroups;
        private final List<SourcePacketExtension> sources = new LinkedList<SourcePacketExtension>();
        private int[] ssrcs = NO_SSRCS;

        public Channel() {
            super(ELEMENT);
        }

        public boolean addPayloadType(PayloadTypePacketExtension payloadType) {
            Objects.requireNonNull(payloadType, "payloadType");
            payloadType.setNamespace(null);
            for (ParameterPacketExtension p : payloadType.getParameters()) {
                p.setNamespace(null);
            }
            return !this.payloadTypes.contains(payloadType) && this.payloadTypes.add(payloadType);
        }

        public void addRtpHeaderExtension(RTPHdrExtPacketExtension ext) {
            Objects.requireNonNull(ext, "ext");
            RTPHdrExtPacketExtension newExt = RTPHdrExtPacketExtension.clone(ext);
            newExt.setNamespace(null);
            int id = -1;
            try {
                id = Integer.parseInt(newExt.getID());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id < 0 || id > 14) {
                logger.warn("Failed to add an RTP header extension element with an invalid ID: " + newExt.getID());
                return;
            }
            this.rtpHeaderExtensions.put(id, newExt);
        }

        public synchronized boolean addSource(SourcePacketExtension source) {
            Objects.requireNonNull(source, "source");
            return !this.sources.contains(source) && this.sources.add(source);
        }

        public synchronized boolean addSourceGroup(SourceGroupPacketExtension sourceGroup) {
            Objects.requireNonNull(sourceGroup, "sourceGroup");
            if (this.sourceGroups == null) {
                this.sourceGroups = new LinkedList<SourceGroupPacketExtension>();
            }
            return !this.sourceGroups.contains(sourceGroup) && this.sourceGroups.add(sourceGroup);
        }

        public synchronized boolean addSSRC(int ssrc) {
            for (int j : this.ssrcs) {
                if (j != ssrc) continue;
                return false;
            }
            int[] newSSRCs = new int[this.ssrcs.length + 1];
            System.arraycopy(this.ssrcs, 0, newSSRCs, 0, this.ssrcs.length);
            newSSRCs[this.ssrcs.length] = ssrc;
            this.ssrcs = newSSRCs;
            return true;
        }

        public String getDirection() {
            return this.direction == null ? SENDRECV : this.direction;
        }

        @Deprecated
        public String getHost() {
            return this.host;
        }

        public Integer getLastN() {
            return this.lastN;
        }

        public SimulcastMode getSimulcastMode() {
            return this.simulcastMode;
        }

        public Integer getPacketDelay() {
            return this.packetDelay;
        }

        public List<PayloadTypePacketExtension> getPayloadTypes() {
            return Collections.unmodifiableList(this.payloadTypes);
        }

        public Collection<RTPHdrExtPacketExtension> getRtpHeaderExtensions() {
            return Collections.unmodifiableCollection(this.rtpHeaderExtensions.values());
        }

        public Integer getReceivingSimulcastLayer() {
            return this.receivingSimulcastLayer;
        }

        @Deprecated
        public int getRTCPPort() {
            return this.rtcpPort;
        }

        public RTPLevelRelayType getRTPLevelRelayType() {
            return this.rtpLevelRelayType;
        }

        @Deprecated
        public int getRTPPort() {
            return this.rtpPort;
        }

        public synchronized List<SourceGroupPacketExtension> getSourceGroups() {
            return this.sourceGroups == null ? null : new ArrayList<SourceGroupPacketExtension>(this.sourceGroups);
        }

        public synchronized List<SourcePacketExtension> getSources() {
            return new ArrayList<SourcePacketExtension>(this.sources);
        }

        public synchronized int[] getSSRCs() {
            return this.ssrcs.length == 0 ? NO_SSRCS : (int[])this.ssrcs.clone();
        }

        @Override
        protected boolean hasContent() {
            List<PayloadTypePacketExtension> payloadTypes = this.getPayloadTypes();
            if (!payloadTypes.isEmpty()) {
                return true;
            }
            List<SourceGroupPacketExtension> sourceGroups = this.getSourceGroups();
            if (sourceGroups != null && !this.getSourceGroups().isEmpty()) {
                return true;
            }
            List<SourcePacketExtension> sources = this.getSources();
            if (!sources.isEmpty()) {
                return true;
            }
            int[] ssrcs = this.getSSRCs();
            return ssrcs.length != 0;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder printAttributes(IQ.IQChildElementXmlStringBuilder xml) {
            int rtpPort;
            RTPLevelRelayType rtpLevelRelayType;
            int rtcpPort;
            SimulcastMode simulcastMode;
            Integer packetDelay;
            String direction = this.getDirection();
            if (direction != null && !direction.equals(SENDRECV)) {
                xml.attribute(DIRECTION_ATTR_NAME, direction);
            }
            xml.optAttribute(HOST_ATTR_NAME, this.getHost());
            Integer lastN = this.getLastN();
            if (lastN != null) {
                xml.attribute(LAST_N_ATTR_NAME, this.getLastN());
            }
            if ((packetDelay = this.getPacketDelay()) != null) {
                xml.attribute(PACKET_DELAY_ATTR_NAME, packetDelay);
            }
            if ((simulcastMode = this.getSimulcastMode()) != null) {
                xml.attribute(SIMULCAST_MODE_ATTR_NAME, simulcastMode.toString());
            }
            if ((rtcpPort = this.getRTCPPort()) > 0) {
                xml.attribute(RTCP_PORT_ATTR_NAME, rtcpPort);
            }
            if ((rtpLevelRelayType = this.getRTPLevelRelayType()) != null) {
                xml.attribute(RTP_LEVEL_RELAY_TYPE_ATTR_NAME, rtpLevelRelayType.toString());
            }
            if ((rtpPort = this.getRTPPort()) > 0) {
                xml.attribute(RTP_PORT_ATTR_NAME, rtpPort);
            }
            return xml;
        }

        @Override
        protected IQ.IQChildElementXmlStringBuilder printContent(IQ.IQChildElementXmlStringBuilder xml) {
            List<PayloadTypePacketExtension> payloadTypes = this.getPayloadTypes();
            Collection<RTPHdrExtPacketExtension> rtpHdrExtPacketExtensions = this.getRtpHeaderExtensions();
            List<SourcePacketExtension> sources = this.getSources();
            List<SourceGroupPacketExtension> sourceGroups = this.getSourceGroups();
            int[] ssrcs = this.getSSRCs();
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                xml.append(payloadType.toXML());
            }
            for (RTPHdrExtPacketExtension ext : rtpHdrExtPacketExtensions) {
                xml.append(ext.toXML());
            }
            for (SourcePacketExtension source : sources) {
                xml.append(source.toXML());
            }
            if (sourceGroups != null && sourceGroups.size() != 0) {
                for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
                    xml.append(sourceGroup.toXML());
                }
            }
            for (Iterator<SourceGroupPacketExtension> ssrc : (Iterator<SourceGroupPacketExtension>)ssrcs) {
                xml.element(SSRC_ELEMENT, Long.toString((long)ssrc & 0xFFFFFFFFL));
            }
            return xml;
        }

        public boolean removePayloadType(PayloadTypePacketExtension payloadType) {
            return this.payloadTypes.remove(payloadType);
        }

        public void removeRtpHeaderExtension(RTPHdrExtPacketExtension ext) {
            int id = -1;
            try {
                id = Integer.parseInt(ext.getID());
            }
            catch (NumberFormatException nfe) {
                logger.warn("Invalid ID: " + ext.getID());
                return;
            }
            this.rtpHeaderExtensions.remove(id);
        }

        public synchronized boolean removeSource(SourcePacketExtension source) {
            return this.sources.remove(source);
        }

        public synchronized boolean removeSSRC(int ssrc) {
            if (this.ssrcs.length == 1) {
                if (this.ssrcs[0] == ssrc) {
                    this.ssrcs = NO_SSRCS;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.ssrcs.length; ++i) {
                if (this.ssrcs[i] != ssrc) continue;
                int[] newSSRCs = new int[this.ssrcs.length - 1];
                if (i != 0) {
                    System.arraycopy(this.ssrcs, 0, newSSRCs, 0, i);
                }
                if (i != newSSRCs.length) {
                    System.arraycopy(this.ssrcs, i + 1, newSSRCs, i, newSSRCs.length - i);
                }
                this.ssrcs = newSSRCs;
                return true;
            }
            return false;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        @Deprecated
        public void setHost(String host) {
            this.host = host;
        }

        public void setLastN(Integer lastN) {
            this.lastN = lastN;
        }

        public void setPacketDelay(Integer packetDelay) {
            this.packetDelay = packetDelay;
        }

        public void setSimulcastMode(SimulcastMode simulcastMode) {
            this.simulcastMode = simulcastMode;
        }

        public void setReceivingSimulcastLayer(Integer simulcastLayer) {
            this.receivingSimulcastLayer = simulcastLayer;
        }

        @Deprecated
        public void setRTCPPort(int rtcpPort) {
            this.rtcpPort = rtcpPort;
        }

        public void setRTPLevelRelayType(RTPLevelRelayType rtpLevelRelayType) {
            this.rtpLevelRelayType = rtpLevelRelayType;
        }

        public void setRTPLevelRelayType(String s2) {
            this.setRTPLevelRelayType(RTPLevelRelayType.parseRTPLevelRelayType(s2));
        }

        @Deprecated
        public void setRTPPort(int rtpPort) {
            this.rtpPort = rtpPort;
        }

        public void setSSRCs(int[] ssrcs) {
            this.ssrcs = ssrcs == null || ssrcs.length == 0 ? NO_SSRCS : (int[])ssrcs.clone();
        }
    }
}

