<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2016 Bjoern Schiessle <bjoern@schiessle.org>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\ServerInfo\Controller;

use OCP\AppFramework\Http\JSONResponse;
use OCP\IRequest;
use OCP\AppFramework\Controller;
use OCA\ServerInfo\SystemStatistics;

class PageController extends Controller {

	/** @var SystemStatistics */
	private $systemStatistics;

	/**
	 * ApiController constructor.
	 *
	 * @param string $appName
	 * @param IRequest $request
	 * @param SystemStatistics $systemStatistics
	 */
	public function __construct($appName,
								IRequest $request,
								SystemStatistics $systemStatistics
	) {
		parent::__construct($appName, $request);

		$this->systemStatistics = $systemStatistics;
	}

	/**
	 * request data update
	 *
	 * @return JSONResponse
	 */
	public function update(): JSONResponse {
		$data = [
			'system' => $this->systemStatistics->getSystemStatistics()
		];

		return new JSONResponse($data);
	}
}
