/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.dependency;

import com.projectlibre1.association.AssociationFormat;
import com.projectlibre1.association.AssociationFormatParameters;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.datatype.Duration;
import com.projectlibre1.datatype.DurationFormat;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.options.GeneralOption;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.dependency.DependencyType;
import com.projectlibre1.pm.dependency.HasDependencies;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.strings.Messages;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collection;

public class DependencyFormat
extends AssociationFormat {
    private static NumberFormat integerFormat = NumberFormat.getIntegerInstance();

    public static DependencyFormat getInstance(AssociationFormatParameters associationFormatParameters) {
        return new DependencyFormat(associationFormatParameters);
    }

    private DependencyFormat(AssociationFormatParameters associationFormatParameters) {
        super(associationFormatParameters);
    }

    private String getErrorMessage(String string) {
        String string2 = MessageFormat.format(Messages.getString("Message.invalidDependency.mf"), this.parameters.isLeftAssociation() ? Messages.getString("Text.predecessor") : Messages.getString("Text.successor"));
        return string2;
    }

    private Object doParse(String string, ParsePosition parsePosition) throws ParseException {
        Duration duration;
        Integer n;
        Long l = (Long)integerFormat.parseObject(string, parsePosition);
        if (l == null) {
            throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
        }
        Object object = null;
        Collection collection = this.getContainer(this.parameters.isLeftAssociation());
        if (collection != null) {
            object = this.parameters.getIdField().find(l, collection);
        }
        if (object == null) {
            if (GeneralOption.getInstance().isAutomaticallyAddNewResourcesAndTasks()) {
                object = this.createNewObject(this.parameters.isLeftAssociation());
                try {
                    this.parameters.getIdField().setText(object, l.toString(), null);
                }
                catch (FieldParseException fieldParseException) {
                    throw new ParseException(fieldParseException.getMessage(), 0);
                }
            } else {
                throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
            }
        }
        if ((n = (Integer)DependencyType.Format.getInstance().parseObject(string, parsePosition)) == null) {
            throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
        }
        String string2 = string.substring(parsePosition.getIndex()).trim();
        if (string2.length() == 0) {
            duration = Duration.ZERO;
        } else {
            duration = (Duration)DurationFormat.getInstance().parseObject(string, parsePosition);
            if (duration == null) {
                throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
            }
        }
        return Dependency.getInstance(this.parameters.isLeftAssociation() ? (HasDependencies)object : (HasDependencies)this.parameters.getThisObject(), this.parameters.isLeftAssociation() ? (HasDependencies)this.parameters.getThisObject() : (HasDependencies)object, n, duration.getEncodedMillis());
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            return this.doParse(string, parsePosition);
        }
        catch (ParseException parseException) {
            this.parameters.setError(parseException.getMessage());
            return null;
        }
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Dependency dependency = (Dependency)object;
        Task task = (Task)(this.parameters.isLeftAssociation() ? dependency.getPredecessor() : dependency.getSuccessor());
        stringBuffer.append(this.parameters.getIdField().getValue(task, null));
        boolean bl = !Duration.isZero(dependency.getLag());
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!DependencyType.isDefault(dependency.getDependencyType()) || bl) {
            stringBuffer2.append(DependencyType.mapValueToString(new Integer(dependency.getDependencyType())));
        }
        Duration duration = new Duration(dependency.getLag());
        if (bl) {
            stringBuffer2.append(DurationFormat.getSignedInstance().format(duration));
        }
        if (stringBuffer2.length() != 0) {
            if (this.parameters.isEncloseInBrackets()) {
                stringBuffer.append(Settings.LEFT_BRACKET);
            }
            stringBuffer.append(stringBuffer2);
            if (this.parameters.isEncloseInBrackets()) {
                stringBuffer.append(Settings.RIGHT_BRACKET);
            }
        }
        return stringBuffer;
    }

    @Override
    protected Collection getContainer(boolean bl) {
        return ((Task)this.parameters.getThisObject()).getProject().getTasks();
    }

    @Override
    protected Object createNewObject(boolean bl) {
        return ((Task)this.parameters.getThisObject()).getProject().newNormalTaskInstance();
    }
}

