/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analytics.AnalyticsExpression;

public class ExpressionCalculator {
    private final Iterable<AnalyticsExpression> expressions;

    public ExpressionCalculator(Iterable<AnalyticsExpression> expressions) {
        this.expressions = expressions;
    }

    public Map<String, Object> getResults() {
        HashMap<String, Object> exprVals = new HashMap<String, Object>();
        this.expressions.forEach(expr -> {
            Object obj = expr.toObject();
            if (expr.exists()) {
                exprVals.put(expr.getName(), obj);
            }
        });
        return exprVals;
    }

    public void addResults(Map<String, Object> response) {
        response.put("results", this.getResults());
    }
}

