/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OpenFilesIterator
extends BatchedRemoteIterator<Long, OpenFileEntry> {
    public static final String FILTER_PATH_DEFAULT = "/";
    private final ClientProtocol namenode;
    private final Tracer tracer;
    private final EnumSet<OpenFilesType> types;
    private String path;

    public OpenFilesIterator(ClientProtocol namenode, Tracer tracer, EnumSet<OpenFilesType> types, String path) {
        super((Object)0L);
        this.namenode = namenode;
        this.tracer = tracer;
        this.types = types;
        this.path = path;
    }

    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listOpenFiles");){
            BatchedRemoteIterator.BatchedEntries<OpenFileEntry> batchedEntries = this.namenode.listOpenFiles(prevId, this.types, this.path);
            return batchedEntries;
        }
    }

    public Long elementToPrevKey(OpenFileEntry entry) {
        return entry.getId();
    }

    public static enum OpenFilesType {
        ALL_OPEN_FILES(1),
        BLOCKING_DECOMMISSION(2);

        private final short mode;

        private OpenFilesType(short mode) {
            this.mode = mode;
        }

        public short getMode() {
            return this.mode;
        }

        public static OpenFilesType valueOf(short num) {
            for (OpenFilesType type : OpenFilesType.values()) {
                if (type.getMode() != num) continue;
                return type;
            }
            return null;
        }
    }
}

