/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordSearchTerm;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordSortPredicate;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.AuthenticatedUser;

public abstract class ModeledActivityRecordSet<RecordType extends ActivityRecord>
extends RestrictedObject
implements ActivityRecordSet<RecordType> {
    private final Set<ActivityRecordSearchTerm> requiredContents = new HashSet<ActivityRecordSearchTerm>();
    private int limit = Integer.MAX_VALUE;
    private final List<ActivityRecordSortPredicate> sortPredicates = new ArrayList<ActivityRecordSortPredicate>();

    protected abstract Collection<RecordType> retrieveHistory(AuthenticatedUser var1, Set<ActivityRecordSearchTerm> var2, List<ActivityRecordSortPredicate> var3, int var4) throws GuacamoleException;

    public Collection<RecordType> asCollection() throws GuacamoleException {
        return this.retrieveHistory(this.getCurrentUser(), this.requiredContents, this.sortPredicates, this.limit);
    }

    public ModeledActivityRecordSet<RecordType> contains(String value) throws GuacamoleException {
        this.requiredContents.add(new ActivityRecordSearchTerm(value));
        return this;
    }

    public ModeledActivityRecordSet<RecordType> limit(int limit) throws GuacamoleException {
        this.limit = Math.min(this.limit, limit);
        return this;
    }

    public ModeledActivityRecordSet<RecordType> sort(ActivityRecordSet.SortableProperty property, boolean desc) throws GuacamoleException {
        this.sortPredicates.add(new ActivityRecordSortPredicate(property, desc));
        return this;
    }
}

