/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.sqlserver;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.sqlserver.conf.SQLServerDriver;
import org.apache.guacamole.auth.sqlserver.conf.SQLServerEnvironment;
import org.mybatis.guice.datasource.helper.JdbcHelper;

public class SQLServerAuthenticationProviderModule
implements Module {
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();
    private final SQLServerDriver sqlServerDriver;

    public SQLServerAuthenticationProviderModule(SQLServerEnvironment environment) throws GuacamoleException {
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getSQLServerHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getSQLServerPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getSQLServerDatabase());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
        String instance = environment.getSQLServerInstance();
        if (instance != null) {
            this.driverProperties.setProperty("JDBC.instanceName", instance);
        }
        this.sqlServerDriver = environment.getSQLServerDriver();
    }

    @Override
    public void configure(Binder binder) {
        switch (this.sqlServerDriver) {
            case JTDS: {
                JdbcHelper.SQL_Server_jTDS.configure(binder);
                break;
            }
            case DATA_DIRECT: {
                JdbcHelper.SQL_Server_DataDirect.configure(binder);
                break;
            }
            case MICROSOFT_LEGACY: {
                JdbcHelper.SQL_Server_MS_Driver.configure(binder);
                break;
            }
            case MICROSOFT_2005: {
                JdbcHelper.SQL_Server_2005_MS_Driver.configure(binder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("A driver has been specified that is not supported by this module.");
            }
        }
        Names.bindProperties(binder, this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith(Names.named("JDBC.driverProperties")).toInstance(this.driverProperties);
    }
}

