'use strict';

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MetricsAggregationBase = require('./metrics-aggregation-base');

/**
 * A single-value metrics aggregation that sums up numeric values that are
 * extracted from the aggregated documents. These values can be extracted either
 * from specific numeric fields in the documents, or be generated by a
 * provided script.
 *
 * [Elasticsearch reference](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-stats-aggregation.html)
 *
 * Aggregation that sums up numeric values that are extracted from the
 * aggregated documents.
 *
 * @example
 * const reqBody = esb.requestBodySearch()
 *     .query(esb.constantScoreQuery(esb.matchQuery('type', 'hat')))
 *     .agg(esb.sumAggregation('hat_prices', 'price'));
 *
 * @example
 * // Script to fetch the sales price
 * const reqBody = esb.requestBodySearch()
 *     .query(esb.constantScoreQuery(esb.matchQuery('type', 'hat')))
 *     .agg(
 *         esb.sumAggregation('hat_prices').script(
 *             esb.script('inline', 'doc.price.value')
 *         )
 *     );
 *
 * @example
 * // Access the field value from the script using `_value`
 * const reqBody = esb.requestBodySearch()
 *     .query(esb.constantScoreQuery(esb.matchQuery('type', 'hat')))
 *     .agg(
 *         esb.sumAggregation('square_hats', 'price').script(
 *             esb.script('inline', '_value * _value')
 *         )
 *     );
 *
 * @example
 * // Treat documents missing price as if they had a value
 * const reqBody = esb.requestBodySearch()
 *     .query(esb.constantScoreQuery(esb.matchQuery('type', 'hat')))
 *     .agg(esb.sumAggregation('hat_prices', 'price').missing(100));
 *
 * @param {string} name The name which will be used to refer to this aggregation.
 * @param {string=} field The field to aggregate on
 *
 * @extends MetricsAggregationBase
 */

var SumAggregation = function (_MetricsAggregationBa) {
  (0, _inherits3.default)(SumAggregation, _MetricsAggregationBa);

  /**
   * Creates an instance of `SumAggregation`
   *
   * @param {string} name The name which will be used to refer to this aggregation.
   * @param {string=} field The field to aggregate on
   */
  function SumAggregation(name, field) {
    (0, _classCallCheck3.default)(this, SumAggregation);
    return (0, _possibleConstructorReturn3.default)(this, (SumAggregation.__proto__ || Object.getPrototypeOf(SumAggregation)).call(this, name, 'sum', field));
  }

  return SumAggregation;
}(MetricsAggregationBase);

module.exports = SumAggregation;