/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class JBoss6VFS
extends org.apache.ibatis.io.VFS {
    private static final Log log = LogFactory.getLog(JBoss6VFS.class);
    private static Boolean valid;

    protected static synchronized void initialize() {
        if (valid == null) {
            valid = Boolean.TRUE;
            VFS.VFS = JBoss6VFS.checkNotNull(JBoss6VFS.getClass("org.jboss.vfs.VFS"));
            VirtualFile.VirtualFile = JBoss6VFS.checkNotNull(JBoss6VFS.getClass("org.jboss.vfs.VirtualFile"));
            VFS.getChild = JBoss6VFS.checkNotNull(JBoss6VFS.getMethod(VFS.VFS, "getChild", URL.class));
            VirtualFile.getChildrenRecursively = JBoss6VFS.checkNotNull(JBoss6VFS.getMethod(VirtualFile.VirtualFile, "getChildrenRecursively", new Class[0]));
            VirtualFile.getPathNameRelativeTo = JBoss6VFS.checkNotNull(JBoss6VFS.getMethod(VirtualFile.VirtualFile, "getPathNameRelativeTo", VirtualFile.VirtualFile));
            JBoss6VFS.checkReturnType(VFS.getChild, VirtualFile.VirtualFile);
            JBoss6VFS.checkReturnType(VirtualFile.getChildrenRecursively, List.class);
            JBoss6VFS.checkReturnType(VirtualFile.getPathNameRelativeTo, String.class);
        }
    }

    protected static <T> T checkNotNull(T object) {
        if (object == null) {
            JBoss6VFS.setInvalid();
        }
        return object;
    }

    protected static void checkReturnType(Method method, Class<?> expected) {
        if (method != null && !expected.isAssignableFrom(method.getReturnType())) {
            log.error("Method " + method.getClass().getName() + "." + method.getName() + "(..) should return " + expected.getName() + " but returns " + method.getReturnType().getName() + " instead.");
            JBoss6VFS.setInvalid();
        }
    }

    protected static void setInvalid() {
        if (valid.booleanValue()) {
            log.debug("JBoss 6 VFS API is not available in this environment.");
            valid = Boolean.FALSE;
        }
    }

    @Override
    public boolean isValid() {
        return valid;
    }

    @Override
    public List<String> list(URL url, String path) throws IOException {
        VirtualFile directory = VFS.getChild(url);
        if (directory == null) {
            return Collections.emptyList();
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        List<VirtualFile> children = directory.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (VirtualFile vf : children) {
            names.add(path + vf.getPathNameRelativeTo(directory));
        }
        return names;
    }

    static {
        JBoss6VFS.initialize();
    }

    static class VFS {
        static Class<?> VFS;
        static Method getChild;

        private VFS() {
        }

        static VirtualFile getChild(URL url) throws IOException {
            Object o = org.apache.ibatis.io.VFS.invoke(getChild, VFS, url);
            return o == null ? null : new VirtualFile(o);
        }
    }

    static class VirtualFile {
        static Class<?> VirtualFile;
        static Method getPathNameRelativeTo;
        static Method getChildrenRecursively;
        Object virtualFile;

        VirtualFile(Object virtualFile) {
            this.virtualFile = virtualFile;
        }

        String getPathNameRelativeTo(VirtualFile parent) {
            try {
                return (String)org.apache.ibatis.io.VFS.invoke(getPathNameRelativeTo, this.virtualFile, parent.virtualFile);
            }
            catch (IOException e) {
                log.error("This should not be possible. VirtualFile.getPathNameRelativeTo() threw IOException.");
                return null;
            }
        }

        List<VirtualFile> getChildren() throws IOException {
            List objects = (List)org.apache.ibatis.io.VFS.invoke(getChildrenRecursively, this.virtualFile, new Object[0]);
            ArrayList<VirtualFile> children = new ArrayList<VirtualFile>(objects.size());
            for (Object object : objects) {
                children.add(new VirtualFile(object));
            }
            return children;
        }
    }
}

