/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.time;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    protected static long MINUTE = 60000L;
    protected static long HOUR = 60L * MINUTE;
    protected static long DAY = 24L * HOUR;
    protected static Calendar calendar;
    protected static Calendar localCalendar;
    protected static DateFormat format;

    protected static Calendar getCalendar() {
        if (calendar == null) {
            calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        return calendar;
    }

    protected static Calendar getLocalCalendar() {
        if (localCalendar == null) {
            localCalendar = Calendar.getInstance();
        }
        return localCalendar;
    }

    protected static int getTimeZoneOffset(long l) {
        Calendar calendar = TimeUtil.getLocalCalendar();
        calendar.setTimeInMillis(l);
        return calendar.get(15) + calendar.get(16);
    }

    public static long removeTimeZoneOffset(long l) {
        return l - (long)TimeUtil.getTimeZoneOffset(l);
    }

    public static long addTimeZoneOffset(long l) {
        return l + (long)TimeUtil.getTimeZoneOffset(l);
    }

    public static String toUTCString(long l) {
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return format.format(new Date(l));
    }

    public static long toHoursAndMinutes(long l) {
        Calendar calendar = TimeUtil.getCalendar();
        calendar.setTimeInMillis(l);
        int n = TimeUtil.getTimeZoneOffset(l);
        long l2 = (60L * (long)calendar.get(11) + (long)calendar.get(12)) * MINUTE + (long)n;
        l2 = (l2 + DAY) % DAY;
        return l2;
    }
}

