/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRAbstractExporter
implements JRExporter {
    protected Map parameters = new HashMap();
    protected List jasperPrintList = null;
    protected JasperPrint jasperPrint = null;
    protected boolean isModeBatch = true;
    protected int startPageIndex = 0;
    protected int endPageIndex = 0;
    protected int globalOffsetX = 0;
    protected int globalOffsetY = 0;
    protected JRFont defaultFont = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();

    public void setParameter(JRExporterParameter parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    public Object getParameter(JRExporterParameter parameter) {
        return this.parameters.get(parameter);
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        Integer offsetY;
        Integer offsetX = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        if (offsetX != null) {
            this.globalOffsetX = offsetX;
        }
        if ((offsetY = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y)) != null) {
            this.globalOffsetY = offsetY;
        }
    }

    protected void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (is != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
                } else {
                    URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (url != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (fileName != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(0);
        }
    }

    protected void setPageRange() throws JRException {
        Integer start;
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < 0 || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " of " + lastPageIndex);
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
    }

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            JRFont font = textElement.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(font.getAttributes());
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    protected void setOutput() {
    }
}

