%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/flat-flags-and-beam-nibs.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it is automatically
%% generated from Documentation/snippets/new
%% Make any changes in Documentation/snippets/new/
%% and then run scripts/auxiliar/makelsr.py
%%
%% This file is in the public domain.
%% Note: this file works from version 2.19.0
\version "2.19.0"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
単一の音符に出現する連桁や、端がはみ出す連桁は、@code{stemLeftBeamCount},
@code{stemRightBeamCount} と連桁指示 @code{[]} を組み合わせることで作ることが@c
できます。

単一の音符で、右側にのみはみ出す連桁については、音符に @code{[]} を付加し、@c
@code{stemLeftBeamCount} を 0 にします (Example 1 を参照)。

左側にのみはみ出す場合は、代わりに @code{stemRightBeamCount} を 0 にします
(Example 2)。

複数音符の連桁で、右側にはみ出す場合は、@code{stemRightBeamCount} を@c
正の値にします。左側にはみ出す場合は、@code{stemLeftBeamCount} を正の値に@c
します (Example 3)。

休符に囲まれた単一の音符では、両方向にはみ出した連桁を表示したほうが@c
分かりやすい場合があります。これは連桁指示 @code{[]} のみで実現できます
(Example 4)。

(注意: @code{\\set stemLeftBeamCount} は常に @code{\\once \\set} と同等です。@c
つまり、連桁の本数は@qq{保持されず}、最後の例における @code{16[]} の音符は@c
その前の @code{\\set} に影響されません。)
"
  doctitleja = "水平な符尾とはみ出す連桁"

%% Translation of GIT committish: 6b35abe942bf1b4e709f215d3657a7cec1f4aa52
  texidocit = "
È possibile ottenere delle codette su note isolate e dei tratti di suddivisione all'estremità
della travatura con una combinazione di @code{stemLeftBeamCount},
@code{stemRightBeamCount} e una coppia di indicatori della travatura @code{[]}.

Per ottenere delle codette rivolte a destra, si usa la coppia di indicatori
@code{[]} e si imposta @code{stemLeftBeamCount} a zero (vedi Example 1).

Per ottenere delle codette rivolte a sinistra, si imposta invece
@code{stemRightBeamCount} (Example 2).

Perché i tratti di suddivisione alla fine di un gruppo di note unite da
travatura siano rivolti a destra, si imposta @code{stemRightBeamCount} su un
valore positivo. Perché i tratti di suddivisione all'inizio di un gruppo di note
unite da travatura siano rivolti a sinistra, si imposta invece
@code{stemLeftBeamCount} (Example 3).

Talvolta, ad esempio per una nota isolata circondata da pause, ha senso
avere una coda che punti sia a destra che a sinistra. Lo si può fare con
una coppia di indicatori di travatura @code{[]} da soli (Example 4).

(Nota che @code{\\set stemLeftBeamCount} è sempre equivalente a
@code{\\once \\set}.  In altre parole, le impostazioni che definiscono
il conteggio delle travature non @qq{permangono}, quindi la coppia di code
attaccate al @code{16[]} solitario nell'ultimo esempio non hanno nulla a
che fare con l'impostazione @code{\\set} di due note prima.)

"
  doctitleit = "Code e punte delle travature"

%% Translation of GIT committish: 90f1e587efc2159450530da3eb8fb391d156a1dc
  texidocfr = "
En combinant @code{stemLeftBeamCount}, @code{stemRightBeamCount} et des
paires de @code{[]}, vous pourrez obtenir des crochets rectilignes et
des ligatures qui débordent à leurs extrémités.

Pour des crochets rectilignes à droite sur des notes isolées, il suffit
d'ajouter une paire d'indicateurs de ligature @code{[]} et de déterminer
@code{stemLeftBeamCount} à zéro, comme dans l'exemple 1.

Pour des crochets rectiligne à gauche, c'est @code{stemRightBeamCount}
qu'il faudra déterminer (exemple 2).

Pour que les barres de ligature débordent sur la droite,
@code{stemRightBeamCount} doit avoir une valeur positive ; pour un
débordement à gauche, c'est sur @code{stemLeftBeamCount} qu'il faut
jouer.  Tout ceci est illustré par l'exemple 3.

Il est parfois judicieux, lorsqu'une note est encadrée de silences, de
l'affubler de crochets rectilignes de part et d'autre. L'exemple 4
montre qu'il suffit d'adjoindre à cette note un @code{[]}.

(Notez bien que @code{\\set stemLeftBeamCount} sera toujours
synonyme de @code{\\once \\set}.  Autrement dit, la détermination
des ligatures n'est pas « permanente » ; c'est la raison pour
laquelle les crochets du @code{16[]} isolé du dernier exemple n'ont
rien à voir avec le @code{\\set} indiqué deux notes auparavant.)

"
  doctitlefr = "Crochet rectiligne et débordement de ligature"

%% Translation of GIT committish: 0c00cd98e81b27325bed5891b950fe7f0f0ebe5d
  texidoces = "
Son posibles tanto los corchetes rectos sobre notas sueltas como
extremos de barra sueltos en figuras unidas, con una combinación de
@code{stemLeftBeamCount}, @code{stemRightBeamCount} e indicadores de
barra @code{[]} emparejados.

Para corchetes rectos que apunten a la derecha sobre notas sueltas,
use indicadores de barra emparejados @code{[]} y establezca
@code{stemLeftBeamCount} a cero (véase el ejemplo 1).

Para corchetes rectos que apunten a la izquierda, establezca en su
lugar @code{stemRightBeamCount} (ejemplo 2).

Para extremos sueltos que apunten a la derecha al final de un conjunto
de notas unidas, establezca @code{stemRightBeamCount} a un valor
positivo.  Y para extremos sueltos que apunten a la izquierda al
principio de un conjunto de notas unidas, establezca
@code{stemLeftBeamCount} en su lugar (ejemplo 3).

A veces, para una nota suelta rodeada de silencios tiene sentido que
lleve los dos extremos sueltos del corchete plano, apuntando a derecha
e izquierda.  Hágalo solamente con indicadores de barra emparejados
@code{[ ]} (ejemplo 4).

(Observe que @code{\\set stemLeftBeamCount} siempre equivale a
@code{\\once \\set}.  En otras palabras, los ajustes de la cantidad de
barras no se recuerdan, y por ello el par de corchetes planos
aplicados a la nota Do semicorchea @code{c'16[]} del último ejemplo no
tiene nada que ver con el @code{\\set} de dos notas por detrás.)

"
  doctitlees = "Corchetes rectos y extremos de barra sueltos"

%% Translation of GIT committish: 0a868be38a775ecb1ef935b079000cebbc64de40
  texidocde = "
Gerade Fähnchen an einzelnen Noten und überstehende Balkenenden bei
bebalkten Notengruppen sind möglich mit einer Kombination aus
@code{stemLeftBeamCount}, @code{stemRightBeamCount} und Paaren von
@code{[]}-Balkenbegrenzungen.

Für gerade Fähnchen, die nach rechts zeigen, kann @code{[]} eingesetzt
werden und @code{stemLeftBeamCount} auf Null gesetzt werden (wie
Bsp. 1).

Für gerade Fähnchen, die nach links zeigen, muss @code{stemRightBeamCount}
eingesetzt werden (Bsp. 2).

Für überstehende Balkenenden nach rechts muss @code{stemRightBeamCount}
auf einen positiven Wert gesetzt werden, für Balkenenden, die nach links
zeigen benutzt man @code{stemLeftBeamCount} (Bsp. 3).

Manchmal können einzelne Noten, die von Pausen umgeben sind, auch Balkenenden
in beide Richtungen tragen.  Das geschieht mit @code{[]}-Klammern (Bsp. 4).

(@code{\\set stemLeftBeamCount} entspricht immer dem Befehl
@code{\\once \\set}.  Anders gesagt müssen die Einstellungen immer wieder
wiederholt werden und die Fähnchen des letzten Sechzehntels im letzten
Beispiel haben nichts mit dem @code{\\set}-Befehl zwei Noten vorher zu tun.)

"
  doctitlede = "Gerade Fähnchen und überstehende Balkenenden"



  lsrtags = "contemporary-notation, rhythms"

  texidoc = "
 Flat flags on lone notes and beam nibs at the ends of beamed figures
are both possible with a combination of @code{stemLeftBeamCount},
@code{stemRightBeamCount} and paired @code{[]} beam indicators.




For right-pointing flat flags on lone notes, use paired @code{[]} beam
indicators and set @code{stemLeftBeamCount} to zero (see Example 1).




For left-pointing flat flags, set @code{stemRightBeamCount} instead
(Example 2).




For right-pointing nibs at the end of a run of beamed notes, set
@code{stemRightBeamCount} to a positive value. And for left-pointing
nibs at the start of a run of beamed notes, set
@code{stemLeftBeamCount} instead (Example 3).




Sometimes it may make sense for a lone note surrounded by rests to
carry both a left- and right-pointing flat flag. Do this with paired
@code{[]} beam indicators alone (Example 4).




(Note that @code{\\set stemLeftBeamCount} is always equivalent to
@code{\\once \\set}.  In other words, the beam count settings are not
@qq{sticky}, so the pair of flat flags attached to the lone
@code{16[]} in the last example have nothing to do with the
@code{\\set} two notes prior.)




"
  doctitle = "Flat flags and beam nibs"
} % begin verbatim

\score {
  <<
    % Example 1
    \new RhythmicStaff {
      \set stemLeftBeamCount = #0
      c16[]
      r8.
    }
    % Example 2
    \new RhythmicStaff {
      r8.
      \set stemRightBeamCount = #0
      16[]
    }
    % Example 3
    \new RhythmicStaff {
      16 16
      \set stemRightBeamCount = #2
      16 r r
      \set stemLeftBeamCount = #2
      16 16 16
    }
    % Example 4
    \new RhythmicStaff {
      16 16
      \set stemRightBeamCount = #2
      16 r16
      16[]
      r16
      \set stemLeftBeamCount = #2
      16 16
    }
  >>
}



% ****************************************************************
% end ly snippet
% ****************************************************************
