/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.creditcardvalidator;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorData;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardValidatorMeta;
import org.pentaho.di.trans.steps.creditcardvalidator.CreditCardVerifier;
import org.pentaho.di.trans.steps.creditcardvalidator.Messages;
import org.pentaho.di.trans.steps.creditcardvalidator.ReturnIndicator;

public class CreditCardValidator
extends BaseStep
implements StepInterface {
    private CreditCardValidatorMeta meta;
    private CreditCardValidatorData data;

    public CreditCardValidator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block16: {
            this.meta = (CreditCardValidatorMeta)smi;
            this.data = (CreditCardValidatorData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean isValid = false;
            String cardType = null;
            String unValid = null;
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.data.previousRowMeta;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (Const.isEmpty((String)this.meta.getDynamicField())) {
                    this.logError(Messages.getString("CreditCardValidator.Error.CardFieldMissing"));
                    throw new KettleException(Messages.getString("CreditCardValidator.Error.CardFieldMissing"));
                }
                if (this.data.indexOfField < 0) {
                    this.data.indexOfField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicField());
                    if (this.data.indexOfField < 0) {
                        throw new KettleException(Messages.getString("CreditCardValidator.Exception.CouldnotFindField", this.meta.getDynamicField()));
                    }
                }
                this.data.realResultFieldname = this.environmentSubstitute(this.meta.getResultFieldName());
                if (Const.isEmpty((String)this.data.realResultFieldname)) {
                    throw new KettleException(Messages.getString("CreditCardValidator.Exception.ResultFieldMissing"));
                }
                this.data.realCardTypeFieldname = this.environmentSubstitute(this.meta.getCardType());
                this.data.realNotValidMsgFieldname = this.environmentSubstitute(this.meta.getNotValidMsg());
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            try {
                String fieldvalue = this.getInputRowMeta().getString(r, this.data.indexOfField);
                if (this.meta.isOnlyDigits()) {
                    fieldvalue = Const.getDigitsOnly((String)fieldvalue);
                }
                ReturnIndicator rt = new ReturnIndicator();
                rt = CreditCardVerifier.CheckCC(fieldvalue);
                isValid = rt.CardValid;
                if (!Const.isEmpty((String)this.data.realCardTypeFieldname)) {
                    cardType = rt.CardType;
                }
                if (!Const.isEmpty((String)this.data.realNotValidMsgFieldname)) {
                    unValid = rt.UnValidMsg;
                }
                outputRow[this.data.NrPrevFields] = isValid;
                int rowIndex = this.data.NrPrevFields;
                ++rowIndex;
                if (!Const.isEmpty((String)this.data.realCardTypeFieldname)) {
                    outputRow[rowIndex++] = cardType;
                }
                if (!Const.isEmpty((String)this.data.realNotValidMsgFieldname)) {
                    outputRow[rowIndex++] = unValid;
                }
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), Messages.getString("CreditCardValidator.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("CreditCardValidator.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block16;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "CreditCardValidator001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CreditCardValidatorMeta)smi;
        this.data = (CreditCardValidatorData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.log.logError(this.toString(), Messages.getString("CreditCardValidator.Error.ResultFieldMissing"), new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CreditCardValidatorMeta)smi;
        this.data = (CreditCardValidatorData)sdi;
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.log.isBasic()) {
            this.logBasic(Messages.getString("CreditCardValidator.Log.StartingToRun"));
        }
        try {
            try {
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                Object var3_1 = null;
                this.dispose(this.meta, this.data);
            }
            catch (Exception e) {
                this.logError(Messages.getString("CreditCardValidator.Log.UnexpectedError") + " : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.logSummary();
        this.markStop();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

