/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.UtilKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.stats.RateTracker;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001CB\u0019\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020>2\b\u0010@\u001a\u0004\u0018\u00010AJ\b\u0010B\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0016\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u001e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\n \"*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\"\u0010.\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0012R\"\u00100\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0012R\u0010\u00102\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010%R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jitsi/jicofo/bridge/Bridge;", "", "jid", "Lorg/jxmpp/jid/Jid;", "clock", "Ljava/time/Clock;", "(Lorg/jxmpp/jid/Jid;Ljava/time/Clock;)V", "averageParticipantStress", "", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "failureInstant", "Ljava/time/Instant;", "fullVersion", "", "getFullVersion", "()Ljava/lang/String;", "<set-?>", "", "isDraining", "()Z", "isHealthy", "isInGracefulShutdown", "setInGracefulShutdown", "(Z)V", "isOperational", "setOperational", "isOverloaded", "isShuttingDown", "getJid", "()Lorg/jxmpp/jid/Jid;", "lastPresenceReceived", "kotlin.jvm.PlatformType", "lastReportedStressLevel", "getLastReportedStressLevel", "()D", "logger", "Lorg/jitsi/utils/logging2/Logger;", "newEndpointsRate", "Lorg/jitsi/utils/stats/RateTracker;", "recentlyAddedEndpointCount", "", "getRecentlyAddedEndpointCount", "()J", "region", "getRegion", "relayId", "getRelayId", "releaseId", "stress", "getStress", "timeSinceLastPresence", "Ljava/time/Duration;", "getTimeSinceLastPresence", "()Ljava/time/Duration;", "version", "compareTo", "", "other", "endpointAdded", "", "setStats", "stats", "Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;", "toString", "Companion", "jicofo-selector"})
@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public final class Bridge
implements Comparable<Bridge> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Jid jid;
    @NotNull
    private final Clock clock;
    @NotNull
    private final RateTracker newEndpointsRate;
    private double lastReportedStressLevel;
    @Nullable
    private String version;
    private boolean isHealthy;
    @Nullable
    private String releaseId;
    private volatile boolean isOperational;
    private double averageParticipantStress;
    private boolean isInGracefulShutdown;
    private boolean isShuttingDown;
    private boolean isDraining;
    @Nullable
    private Instant failureInstant;
    @Nullable
    private String region;
    @Nullable
    private String relayId;
    @NotNull
    private final Logger logger;
    private Instant lastPresenceReceived;
    @NotNull
    private static final Duration failureResetThreshold = BridgeConfig.config.failureResetThreshold();

    @JvmOverloads
    public Bridge(@NotNull Jid jid, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(jid, "jid");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.jid = jid;
        this.clock = clock;
        Duration duration = BridgeConfig.config.participantRampupInterval();
        Duration duration2 = Duration.ofMillis(100L);
        Intrinsics.checkNotNullExpressionValue(duration2, "ofMillis(100)");
        this.newEndpointsRate = new RateTracker(duration, duration2, this.clock);
        this.isHealthy = true;
        this.isOperational = true;
        this.averageParticipantStress = BridgeConfig.config.averageParticipantStress();
        this.isDraining = true;
        this.logger = new LoggerImpl(Bridge.class.getName());
        this.logger.addContext("jid", ((Object)this.jid).toString());
        this.lastPresenceReceived = Instant.MIN;
    }

    public /* synthetic */ Bridge(Jid jid, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(jid, clock);
    }

    @NotNull
    public final Jid getJid() {
        return this.jid;
    }

    public final double getLastReportedStressLevel() {
        return this.lastReportedStressLevel;
    }

    public final boolean isHealthy() {
        return this.isHealthy;
    }

    public final boolean isOperational() {
        return this.failureInstant != null && Duration.between(this.failureInstant, this.clock.instant()).compareTo(failureResetThreshold) < 0 ? false : this.isOperational;
    }

    public final void setOperational(boolean isOperational) {
        this.isOperational = isOperational;
        if (!isOperational) {
            this.failureInstant = this.clock.instant();
        }
    }

    public final boolean isInGracefulShutdown() {
        return this.isInGracefulShutdown;
    }

    public final void setInGracefulShutdown(boolean bl) {
        this.isInGracefulShutdown = bl;
    }

    public final boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public final boolean isDraining() {
        return this.isDraining;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getRelayId() {
        return this.relayId;
    }

    @NotNull
    public final Duration getTimeSinceLastPresence() {
        Duration duration = Duration.between(this.lastPresenceReceived, this.clock.instant());
        Intrinsics.checkNotNullExpressionValue(duration, "between(lastPresenceReceived, clock.instant())");
        return duration;
    }

    public final void setStats(@Nullable ColibriStatsExtension stats) {
        String healthy;
        String relayId;
        String region;
        String newReleaseId;
        String newVersion;
        String drainStr;
        Double averageParticipantStress;
        if (stats == null) {
            return;
        }
        this.lastPresenceReceived = this.clock.instant();
        Double stressLevel = UtilKt.getDouble(stats, "stress_level");
        if (stressLevel != null) {
            this.lastReportedStressLevel = stressLevel;
        }
        if ((averageParticipantStress = UtilKt.getDouble(stats, "average_participant_stress")) != null) {
            this.averageParticipantStress = averageParticipantStress;
        }
        if (Boolean.parseBoolean(stats.getValueAsString("graceful_shutdown"))) {
            this.isInGracefulShutdown = true;
        }
        if (Boolean.parseBoolean(stats.getValueAsString("shutting_down"))) {
            this.isShuttingDown = true;
        }
        if ((drainStr = stats.getValueAsString("drain")) != null) {
            this.isDraining = Boolean.parseBoolean(drainStr);
        }
        if ((newVersion = stats.getValueAsString("version")) != null) {
            this.version = newVersion;
        }
        if ((newReleaseId = stats.getValueAsString("release")) != null) {
            this.releaseId = newReleaseId;
        }
        if ((region = stats.getValueAsString("region")) != null) {
            this.region = region;
        }
        if ((relayId = stats.getValueAsString("relay_id")) != null) {
            this.relayId = relayId;
        }
        if ((healthy = stats.getValueAsString("healthy")) != null) {
            this.isHealthy = Boolean.parseBoolean(healthy);
        } else if (BridgeConfig.config.getUsePresenceForHealth()) {
            this.logger.warn("Presence-based health checks are enabled, but presence did not include health status. Health checks for this bridge are effectively disabled.");
        }
    }

    @Override
    public int compareTo(@NotNull Bridge other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Companion.compare(this, other);
    }

    public final void endpointAdded() {
        RateTracker.update$default(this.newEndpointsRate, 1L, 0L, 2, null);
    }

    private final long getRecentlyAddedEndpointCount() {
        return RateTracker.getAccumulatedCount$default(this.newEndpointsRate, 0L, 1, null);
    }

    @Nullable
    public final String getFullVersion() {
        return this.version != null && this.releaseId != null ? this.version + "-" + this.releaseId : this.version;
    }

    @NotNull
    public String toString() {
        String string = "Bridge[jid=%s, version=%s, relayId=%s, region=%s, stress=%.2f]";
        Object[] objectArray = new Object[]{((Object)this.jid).toString(), this.getFullVersion(), this.relayId, this.region, this.getStress()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        return string2;
    }

    public final double getStress() {
        return this.lastReportedStressLevel + (double)RangesKt.coerceAtLeast(this.getRecentlyAddedEndpointCount(), 0L) * this.averageParticipantStress;
    }

    public final boolean isOverloaded() {
        return this.getStress() >= BridgeConfig.config.stressThreshold();
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject o = new OrderedJsonObject();
        ((Map)o).put("version", String.valueOf(this.version));
        ((Map)o).put("release", String.valueOf(this.releaseId));
        ((Map)o).put("stress", this.getStress());
        ((Map)o).put("operational", this.isOperational());
        ((Map)o).put("region", String.valueOf(this.region));
        ((Map)o).put("drain", this.isDraining);
        ((Map)o).put("graceful-shutdown", this.isInGracefulShutdown);
        ((Map)o).put("shutting-down", this.isShuttingDown);
        ((Map)o).put("overloaded", this.isOverloaded());
        ((Map)o).put("relay-id", String.valueOf(this.relayId));
        ((Map)o).put("healthy", this.isHealthy);
        return o;
    }

    @JvmOverloads
    public Bridge(@NotNull Jid jid) {
        Intrinsics.checkNotNullParameter(jid, "jid");
        this(jid, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jitsi/jicofo/bridge/Bridge$Companion;", "", "()V", "failureResetThreshold", "Ljava/time/Duration;", "compare", "", "b1", "Lorg/jitsi/jicofo/bridge/Bridge;", "b2", "getPriority", "b", "jicofo-selector"})
    public static final class Companion {
        private Companion() {
        }

        public final int compare(@NotNull Bridge b1, @NotNull Bridge b2) {
            Intrinsics.checkNotNullParameter(b1, "b1");
            Intrinsics.checkNotNullParameter(b2, "b2");
            int myPriority = this.getPriority(b1);
            int otherPriority = this.getPriority(b2);
            return myPriority != otherPriority ? myPriority - otherPriority : Double.compare(b1.getStress(), b2.getStress());
        }

        private final int getPriority(Bridge b) {
            return b.isOperational() ? (b.isInGracefulShutdown() ? 2 : 1) : 3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

