/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.diff.CompareSQL;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.CompareDMFormatter;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.DDLGeneratorListCellRenderer;
import ca.sqlpower.architect.swingui.DataSourceRenderer;
import ca.sqlpower.architect.swingui.LiquibaseOptionsPanel;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.ConnectionComboBoxModel;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.validation.Status;
import ca.sqlpower.validation.ValidateResult;
import ca.sqlpower.validation.swingui.StatusComponent;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class CompareDMPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(CompareDMPanel.class);
    private static final String OUTPUT_ENGLISH = "OUTPUT_ENGLISH";
    private static final String OUTPUT_SQL = "OUTPUT_SQL";
    private static final String OUTPUT_LIQUIBASE = "OUTPUT_LIQUIBASE";
    public static final String DBCS_DIALOG_TITLE = Messages.getString("CompareDMPanel.dbcsDialogTitle");
    private JProgressBar progressBar;
    private JPanel buttonPanel;
    private LiquibaseOptionsPanel lbOptions;
    private JComboBox sqlTypeDropdown;
    private JRadioButton sqlButton;
    private JRadioButton englishButton;
    private JRadioButton liquibaseButton;
    private JCheckBox showNoChanges;
    private JCheckBox includeIndexes;
    private JLabel statusLabel;
    private StatusComponent statusComponent = new StatusComponent();
    private StartCompareAction startCompareAction;
    private SwapSourceTargetAction swapSourceTargetAction;
    private SourceOrTargetStuff source = new SourceOrTargetStuff();
    private SourceOrTargetStuff target = new SourceOrTargetStuff();
    private ArchitectSwingSession session;
    private JDialog parentDialog;
    private ListCellRenderer dataSourceRenderer = new DataSourceRenderer();
    private AncestorListener playpenNameRefreshHandler = new AncestorListener(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            CompareDMPanel.this.source.updatePlayPenNameLabel();
            CompareDMPanel.this.target.updatePlayPenNameLabel();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    };

    private boolean isStartable() {
        logger.debug((Object)"isStartable is checking...");
        ValidateResult result = null;
        if (this.sqlButton.isSelected() && this.sqlTypeDropdown.getSelectedItem() == null) {
            result = ValidateResult.createValidateResult((Status)Status.FAIL, (String)Messages.getString("CompareDMPanel.chooseSQLDialect"));
        }
        if (result == null) {
            result = this.source.getStartabilityStatus();
        }
        if (result == null) {
            result = this.target.getStartabilityStatus();
        }
        this.statusComponent.setResult(result);
        return result == null;
    }

    public Action getStartCompareAction() {
        return this.startCompareAction;
    }

    public Action getSwapSourceTargetAction() {
        return this.swapSourceTargetAction;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public CompareDMPanel(ArchitectSwingSession session, JDialog ownerDialog) {
        this.session = session;
        this.parentDialog = ownerDialog;
        SourceOrTargetStuff sourceOrTargetStuff = this.target;
        sourceOrTargetStuff.getClass();
        SourceOrTargetStuff.SchemaPopulator schemaPopulator = sourceOrTargetStuff.new SourceOrTargetStuff.SchemaPopulator(session);
        SourceOrTargetStuff sourceOrTargetStuff2 = this.target;
        sourceOrTargetStuff2.getClass();
        SourceOrTargetStuff.CatalogPopulator catalogPopulator = sourceOrTargetStuff2.new SourceOrTargetStuff.CatalogPopulator(session);
        SourceOrTargetStuff sourceOrTargetStuff3 = this.source;
        sourceOrTargetStuff3.getClass();
        SourceOrTargetStuff.SchemaPopulator schemaPopulator2 = sourceOrTargetStuff3.new SourceOrTargetStuff.SchemaPopulator(session);
        SourceOrTargetStuff sourceOrTargetStuff4 = this.source;
        sourceOrTargetStuff4.getClass();
        this.buildUI(schemaPopulator, catalogPopulator, schemaPopulator2, sourceOrTargetStuff4.new SourceOrTargetStuff.CatalogPopulator(session));
        this.startCompareAction.setEnabled(this.isStartable());
        this.addAncestorListener(this.playpenNameRefreshHandler);
    }

    private void buildUI(SourceOrTargetStuff.SchemaPopulator targetSchemaPop, SourceOrTargetStuff.CatalogPopulator targetCatalogPop, SourceOrTargetStuff.SchemaPopulator sourceSchemaPop, SourceOrTargetStuff.CatalogPopulator sourceCatalogPop) {
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.sqlTypeDropdown = new JComboBox<Class<? extends DDLGenerator>>(DDLUtils.getDDLTypes(this.session.getDataSources()));
        this.sqlTypeDropdown.setRenderer(new DDLGeneratorListCellRenderer());
        this.sqlTypeDropdown.setName("sqlTypeDropDown");
        OutputChoiceListener listener = new OutputChoiceListener(this.sqlTypeDropdown);
        this.sqlTypeDropdown.setEnabled(false);
        this.sqlTypeDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
            }
        });
        this.sqlButton = new JRadioButton();
        this.sqlButton.setName(OUTPUT_SQL);
        this.sqlButton.setActionCommand(OUTPUT_SQL);
        this.sqlButton.setSelected(false);
        this.sqlButton.addActionListener(listener);
        this.englishButton = new JRadioButton();
        this.englishButton.setName("englishButton");
        this.englishButton.setActionCommand(OUTPUT_ENGLISH);
        this.englishButton.setSelected(true);
        this.englishButton.addActionListener(listener);
        this.liquibaseButton = new JRadioButton();
        this.liquibaseButton.setName(OUTPUT_LIQUIBASE);
        this.liquibaseButton.setActionCommand(OUTPUT_LIQUIBASE);
        this.liquibaseButton.setSelected(false);
        this.liquibaseButton.addActionListener(listener);
        this.showNoChanges = new JCheckBox();
        this.showNoChanges.setName("showNoChanges");
        this.includeIndexes = new JCheckBox(Messages.getString("CompareDMPanel.includeIndexes"));
        this.includeIndexes.setName("includeIndexes");
        this.includeIndexes.setSelected(false);
        ButtonGroup outputGroup = new ButtonGroup();
        outputGroup.add(this.sqlButton);
        outputGroup.add(this.englishButton);
        outputGroup.add(this.liquibaseButton);
        this.startCompareAction = new StartCompareAction();
        this.startCompareAction.setEnabled(false);
        this.swapSourceTargetAction = new SwapSourceTargetAction();
        this.swapSourceTargetAction.setEnabled(true);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        FormLayout formLayout = new FormLayout("20dlu, 2dlu, pref, 4dlu,0:grow, 4dlu, 0:grow, 4dlu,0:grow, 4dlu, pref", "");
        formLayout.setColumnGroups((int[][])new int[][]{{5, 7, 9}});
        Object panel = logger.isDebugEnabled() ? new FormDebugPanel() : new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout, (JPanel)panel);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.append((Component)this.statusComponent, 11);
        builder.nextLine();
        builder.appendSeparator(Messages.getString("CompareDMPanel.olderSeparator"));
        builder.nextLine();
        builder.append("");
        this.source.buildPartialUI(builder, true, sourceSchemaPop, sourceCatalogPop);
        builder.appendSeparator(Messages.getString("CompareDMPanel.newerSeparator"));
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.append("");
        this.target.buildPartialUI(builder, false, targetSchemaPop, targetCatalogPop);
        ActionListener radioButtonActionEnabler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
            }
        };
        this.source.playPenRadio.addActionListener(radioButtonActionEnabler);
        this.source.physicalRadio.addActionListener(radioButtonActionEnabler);
        this.source.loadRadio.addActionListener(radioButtonActionEnabler);
        this.target.playPenRadio.addActionListener(radioButtonActionEnabler);
        this.target.physicalRadio.addActionListener(radioButtonActionEnabler);
        this.target.loadRadio.addActionListener(radioButtonActionEnabler);
        builder.appendSeparator(Messages.getString("CompareDMPanel.outpurFormatSeparator"));
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.nextColumn(2);
        builder.append((Component)this.sqlButton);
        JPanel ddlTypePanel = new JPanel(new BorderLayout(3, 3));
        JLabel temp = new JLabel(Messages.getString("CompareDMPanel.sqlFor"));
        ddlTypePanel.add((Component)temp, "West");
        this.associate(temp, this.sqlButton);
        ddlTypePanel.add((Component)this.sqlTypeDropdown, "Center");
        temp = new JLabel(Messages.getString("CompareDMPanel.makeOlderLookLikeNewer"));
        ddlTypePanel.add((Component)temp, "East");
        this.associate(temp, this.sqlButton);
        builder.append((Component)ddlTypePanel, 3);
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.nextColumn(2);
        builder.append((Component)this.liquibaseButton);
        temp = builder.append(Messages.getString("CompareDMPanel.liqubaseScript"));
        this.associate(temp, this.liquibaseButton);
        this.lbOptions = new LiquibaseOptionsPanel();
        builder.appendRow("pref");
        builder.nextLine(1);
        builder.nextColumn(2);
        this.lbOptions.getPanel().setVisible(false);
        builder.append((Component)this.lbOptions.getPanel(), 9);
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.nextColumn(2);
        builder.append((Component)this.englishButton);
        temp = builder.append(Messages.getString("CompareDMPanel.englishDescriptions"));
        this.associate(temp, this.englishButton);
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.nextColumn(2);
        builder.append((Component)this.showNoChanges);
        temp = builder.append(Messages.getString("CompareDMPanel.suppressSimilarities"));
        this.associate(temp, this.showNoChanges);
        builder.append((Component)this.includeIndexes);
        builder.nextLine();
        builder.appendSeparator(Messages.getString("CompareDMPanel.status"));
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        this.statusLabel = new JLabel("");
        builder.add((Component)this.statusLabel, cc.xy(5, builder.getRow()));
        builder.add((Component)this.progressBar, cc.xyw(7, builder.getRow(), 5));
        this.setLayout(new BorderLayout());
        this.add(builder.getPanel());
        this.setPreferredSize(new Dimension(800, 600));
        try {
            this.restoreSettingsFromProject();
        }
        catch (SQLObjectException e) {
            logger.warn((Object)"Failed to save user CompareDM preferences!", (Throwable)e);
        }
    }

    public SourceOrTargetStuff getSourceStuff() {
        return this.source;
    }

    public void copySettingsToProject() {
        CompareDMSettings s = this.session.getCompareDMSettings();
        s.setSaveFlag(true);
        if (this.englishButton.isSelected()) {
            s.setOutputFormat(CompareDMSettings.OutputFormat.ENGLISH);
        } else if (this.sqlButton.isSelected()) {
            s.setOutputFormat(CompareDMSettings.OutputFormat.SQL);
        } else if (this.liquibaseButton.isSelected()) {
            s.setOutputFormat(CompareDMSettings.OutputFormat.LIQUIBASE);
            s.setLiquibaseSettings(this.lbOptions.getLiquibaseSettings());
        }
        s.setSuppressSimilarities(this.showNoChanges.isSelected());
        Class selectedGenerator = (Class)this.sqlTypeDropdown.getSelectedItem();
        s.setDdlGenerator(selectedGenerator);
        CompareDMSettings.SourceOrTargetSettings sourceSetting = s.getSourceSettings();
        this.copySourceOrTargetSettingsToProject(sourceSetting, this.source);
        s.setSourceStuff(this.source);
        CompareDMSettings.SourceOrTargetSettings targetSetting = s.getTargetSettings();
        this.copySourceOrTargetSettingsToProject(targetSetting, this.target);
        s.setTargetStuff(this.target);
        s.setLiquibaseSettings(this.lbOptions.getLiquibaseSettings());
    }

    public void copySourceOrTargetSettingsToProject(CompareDMSettings.SourceOrTargetSettings setting, SourceOrTargetStuff stuff) {
        if (stuff.databaseDropdown.getItemCount() > 0 && stuff.databaseDropdown.getSelectedIndex() >= 0 && stuff.databaseDropdown.getSelectedItem() != null) {
            setting.setConnectName(((SPDataSource)stuff.databaseDropdown.getSelectedItem()).getName());
        } else {
            setting.setConnectName(null);
        }
        if (stuff.catalogDropdown.getItemCount() > 0 && stuff.catalogDropdown.getSelectedIndex() >= 0 && stuff.catalogDropdown.getSelectedItem() != null) {
            setting.setCatalogObject(stuff.catalogDropdown.getSelectedItem());
        } else {
            setting.setCatalog(null);
        }
        if (stuff.schemaDropdown.getItemCount() > 0 && stuff.schemaDropdown.getSelectedIndex() >= 0 && stuff.schemaDropdown.getSelectedItem() != null) {
            setting.setSchemaObject(stuff.schemaDropdown.getSelectedItem());
        } else {
            setting.setSchema(null);
        }
        setting.setFilePath(stuff.loadFilePath.getText());
        if (stuff.loadRadio.isSelected()) {
            setting.setDatastoreType(CompareDMSettings.DatastoreType.FILE);
        }
        if (stuff.physicalRadio.isSelected()) {
            setting.setDatastoreType(CompareDMSettings.DatastoreType.DATABASE);
        }
        if (stuff.playPenRadio.isSelected()) {
            setting.setDatastoreType(CompareDMSettings.DatastoreType.PROJECT);
        }
    }

    private void restoreSettingsFromProject() throws SQLObjectException {
        CompareDMSettings s = this.session.getCompareDMSettings();
        this.restoreSourceOrTargetSettingsFromProject(this.source, s.getSourceSettings());
        this.restoreSourceOrTargetSettingsFromProject(this.target, s.getTargetSettings());
        this.lbOptions.restoreSettings(s.getLiquibaseSettings());
        if (s.getOutputFormat() == CompareDMSettings.OutputFormat.ENGLISH) {
            this.englishButton.doClick();
        }
        if (s.getOutputFormat() == CompareDMSettings.OutputFormat.SQL) {
            this.sqlButton.doClick();
        }
        if (s.getOutputFormat() == CompareDMSettings.OutputFormat.LIQUIBASE) {
            this.liquibaseButton.doClick();
        }
        this.showNoChanges.setSelected(s.getSuppressSimilarities());
        this.sqlTypeDropdown.setSelectedItem(s.getDdlGenerator());
    }

    private void restoreSourceOrTargetSettingsFromProject(SourceOrTargetStuff stuff, CompareDMSettings.SourceOrTargetSettings set) throws SQLObjectException {
        CompareDMSettings.DatastoreType rbs = set.getDatastoreType();
        if (rbs == CompareDMSettings.DatastoreType.PROJECT) {
            stuff.playPenRadio.doClick();
        } else if (rbs == CompareDMSettings.DatastoreType.DATABASE) {
            stuff.physicalRadio.doClick();
        } else if (rbs == CompareDMSettings.DatastoreType.FILE) {
            stuff.loadRadio.doClick();
        }
        List<JDBCDataSource> lds = this.session.getContext().getConnections();
        block0: for (SPDataSource sPDataSource : lds) {
            if (!sPDataSource.getDisplayName().equals(set.getConnectName())) continue;
            stuff.databaseDropdown.setSelectedItem(sPDataSource);
            if (set.getCatalog() != null) {
                stuff.catalogDropdown.getModel().addListDataListener(new RestoreSettingsListener(stuff.catalogDropdown, set.getCatalog()));
            }
            if (set.getSchema() != null) {
                stuff.schemaDropdown.getModel().addListDataListener(new RestoreSettingsListener(stuff.schemaDropdown, set.getSchema()));
            }
            if (stuff.catalogDropdown.getItemCount() != 0 || stuff.schemaDropdown.getItemCount() <= 0 || set.getSchema() == null || set.getSchema().length() <= 0) break;
            for (int j = 0; j < stuff.schemaDropdown.getItemCount(); ++j) {
                SQLObject o2 = (SQLObject)stuff.schemaDropdown.getItemAt(j);
                if (!o2.getName().equals(set.getSchema())) continue;
                stuff.schemaDropdown.setSelectedIndex(j);
                break block0;
            }
        }
        if (set.getFilePath() != null) {
            stuff.loadFilePath.setText(set.getFilePath());
        }
    }

    public SourceOrTargetStuff getTargetStuff() {
        return this.target;
    }

    public void compareCurrentWithOrig(SQLSchema schema, SQLCatalog catalog, SQLDatabase db) {
        if (catalog != null) {
            this.source.catalogPop.setDefaultCatalog(catalog.getName());
        }
        if (schema != null) {
            this.source.catalogPop.setDefaultSchema(schema.getName());
            this.source.schemaPop.setDefaultSelect(schema.getName());
        }
        this.source.physicalRadio.doClick();
        for (int x = 1; x < this.source.databaseDropdown.getItemCount(); ++x) {
            SPDataSource curr = (SPDataSource)this.source.databaseDropdown.getItemAt(x);
            if (curr == null || !curr.getName().equals(db.getName())) continue;
            this.source.databaseDropdown.setSelectedIndex(x);
            break;
        }
        this.target.playPenRadio.doClick();
    }

    private void associate(JLabel l, final AbstractButton b) {
        l.addMouseListener(new MouseListener(){

            private void retarget(MouseEvent e) {
                MouseEvent newEvent = new MouseEvent(b, e.getID(), e.getWhen(), e.getModifiers(), 0, 0, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                b.dispatchEvent(newEvent);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.retarget(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.retarget(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.retarget(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.retarget(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.retarget(e);
            }
        });
    }

    public class SwapSourceTargetAction
    extends AbstractAction {
        public SwapSourceTargetAction() {
            super(Messages.getString("CompareDMPanel.swapSourceTargetActionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int x;
            boolean sourcePlayPen = CompareDMPanel.this.source.playPenRadio.isSelected();
            boolean sourcePhysical = CompareDMPanel.this.source.physicalRadio.isSelected();
            String sourceLoadFilePath = CompareDMPanel.this.source.loadFilePath.getText();
            String targetLoadFilePath = CompareDMPanel.this.target.loadFilePath.getText();
            SPDataSource soDBObj = null;
            SQLObject soCatObj = null;
            SQLObject soSchemaObj = null;
            SPDataSource taDBObj = null;
            SQLObject taCatObj = null;
            SQLObject taSchemaObj = null;
            if (CompareDMPanel.this.source.physicalRadio.isSelected()) {
                soDBObj = (SPDataSource)CompareDMPanel.this.source.databaseDropdown.getSelectedItem();
                soCatObj = (SQLObject)CompareDMPanel.this.source.catalogDropdown.getSelectedItem();
                soSchemaObj = (SQLObject)CompareDMPanel.this.source.schemaDropdown.getSelectedItem();
            }
            if (CompareDMPanel.this.target.physicalRadio.isSelected()) {
                taDBObj = (SPDataSource)CompareDMPanel.this.target.databaseDropdown.getSelectedItem();
                taCatObj = (SQLObject)CompareDMPanel.this.target.catalogDropdown.getSelectedItem();
                taSchemaObj = (SQLObject)CompareDMPanel.this.target.schemaDropdown.getSelectedItem();
            }
            CompareDMPanel.this.target.loadFilePath.setText(sourceLoadFilePath);
            CompareDMPanel.this.source.loadFilePath.setText(targetLoadFilePath);
            if (soDBObj != null) {
                for (x = 1; x < CompareDMPanel.this.target.databaseDropdown.getItemCount(); ++x) {
                    if (!CompareDMPanel.this.target.databaseDropdown.getItemAt(x).equals(soDBObj)) continue;
                    CompareDMPanel.this.target.databaseDropdown.setSelectedIndex(x);
                }
            }
            if (soCatObj != null) {
                CompareDMPanel.this.target.catalogPop.setDefaultCatalog(soCatObj.getName());
            }
            if (soSchemaObj != null) {
                CompareDMPanel.this.target.catalogPop.setDefaultSchema(soSchemaObj.getName());
                CompareDMPanel.this.target.schemaPop.setDefaultSelect(soSchemaObj.getName());
            }
            if (taDBObj != null) {
                for (x = 1; x < CompareDMPanel.this.source.databaseDropdown.getItemCount(); ++x) {
                    if (!CompareDMPanel.this.source.databaseDropdown.getItemAt(x).equals(taDBObj)) continue;
                    CompareDMPanel.this.source.databaseDropdown.setSelectedIndex(x);
                }
            }
            if (taCatObj != null) {
                CompareDMPanel.this.source.catalogPop.setDefaultCatalog(taCatObj.getName());
            }
            if (taSchemaObj != null) {
                CompareDMPanel.this.source.catalogPop.setDefaultSchema(taSchemaObj.getName());
                CompareDMPanel.this.source.schemaPop.setDefaultSelect(taSchemaObj.getName());
            }
            if (CompareDMPanel.this.target.playPenRadio.isSelected()) {
                CompareDMPanel.this.source.playPenRadio.doClick();
            } else if (CompareDMPanel.this.target.physicalRadio.isSelected()) {
                CompareDMPanel.this.source.physicalRadio.doClick();
            } else {
                CompareDMPanel.this.source.loadRadio.doClick();
            }
            if (sourcePlayPen) {
                CompareDMPanel.this.target.playPenRadio.doClick();
            } else if (sourcePhysical) {
                CompareDMPanel.this.target.physicalRadio.doClick();
            } else {
                CompareDMPanel.this.target.loadRadio.doClick();
            }
        }
    }

    public class StartCompareAction
    extends AbstractAction {
        private Collection<SQLTable> sourceTables;
        private Collection<SQLTable> targetTables;
        private SPSwingWorker compareWorker;

        public SPSwingWorker getCompareWorker() {
            return this.compareWorker;
        }

        public StartCompareAction() {
            super(Messages.getString("CompareDMPanel.startCompareActionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompareSQL targetComp;
            CompareSQL sourceComp;
            SQLObject right;
            SQLObject left;
            CompareDMPanel.this.startCompareAction.setEnabled(false);
            CompareDMPanel.this.sqlButton.setEnabled(false);
            CompareDMPanel.this.englishButton.setEnabled(false);
            CompareDMPanel.this.liquibaseButton.setEnabled(false);
            if (CompareDMPanel.this.sqlButton.isSelected()) {
                CompareDMPanel.this.sqlTypeDropdown.setEnabled(false);
            } else {
                CompareDMPanel.this.showNoChanges.setEnabled(false);
            }
            CompareDMPanel.this.copySettingsToProject();
            try {
                left = CompareDMPanel.this.source.getObjectToCompare();
                this.sourceTables = left.getAllowedChildTypes().contains(SQLTable.class) ? left.getChildren(SQLTable.class) : new ArrayList<SQLTable>();
                right = CompareDMPanel.this.target.getObjectToCompare();
                this.targetTables = right.getAllowedChildTypes().contains(SQLTable.class) ? right.getChildren(SQLTable.class) : new ArrayList<SQLTable>();
                boolean useUUID = CompareDMPanel.this.source.isModelWithUUID() && CompareDMPanel.this.target.isModelWithUUID();
                sourceComp = new CompareSQL(this.sourceTables, this.targetTables, CompareDMPanel.this.session.getCompareDMSettings().getSuppressSimilarities(), useUUID);
                sourceComp.setCompareIndices(CompareDMPanel.this.includeIndexes.isSelected());
                targetComp = new CompareSQL(this.targetTables, this.sourceTables, CompareDMPanel.this.session.getCompareDMSettings().getSuppressSimilarities(), useUUID);
                targetComp.setCompareIndices(CompareDMPanel.this.includeIndexes.isSelected());
            }
            catch (SQLObjectException ex) {
                this.reenableGUIComponents();
                ASUtils.showExceptionDialog(CompareDMPanel.this.session, Messages.getString("CompareDMPanel.couldNotBeginDiffProcess"), ex);
                return;
            }
            catch (IOException ex) {
                this.reenableGUIComponents();
                ASUtils.showExceptionDialogNoReport(CompareDMPanel.this, Messages.getString("CompareDMPanel.couldNotReadFile"), ex);
                logger.error((Object)"Could not read file", (Throwable)ex);
                return;
            }
            catch (RuntimeException ex) {
                this.reenableGUIComponents();
                throw new RuntimeException(ex);
            }
            this.compareWorker = new SPSwingWorker(CompareDMPanel.this.session){
                private List<DiffChunk<SQLObject>> diff;
                private List<DiffChunk<SQLObject>> diff1;
                private String message;

                protected void checkCancelled() {
                    if (this.isCancelled()) {
                        throw new CancellationException("User-requested abort");
                    }
                }

                public void doStuff() throws SQLObjectException {
                    try {
                        if (CompareDMPanel.this.source.physicalRadio.isSelected()) {
                            this.message = "Refreshing older database";
                            logger.debug((Object)this.message);
                            CompareDMPanel.this.source.getDatabase().refresh();
                            this.checkCancelled();
                        }
                        if (CompareDMPanel.this.target.physicalRadio.isSelected()) {
                            this.message = "Refreshing newer database";
                            logger.debug((Object)this.message);
                            CompareDMPanel.this.target.getDatabase().refresh();
                            this.checkCancelled();
                        }
                        this.setJobSize(sourceComp.getJobSize() + targetComp.getJobSize());
                        logger.debug((Object)"Generating TableDiffs for source");
                        this.diff = sourceComp.generateTableDiffs(CompareDMPanel.this.session);
                        this.checkCancelled();
                        logger.debug((Object)"Generating TableDiffs for target");
                        this.diff1 = targetComp.generateTableDiffs(CompareDMPanel.this.session);
                        this.checkCancelled();
                        this.message = "Finished";
                        logger.debug((Object)"Finished Compare");
                    }
                    catch (CancellationException e) {
                        StartCompareAction.this.reenableGUIComponents();
                        this.setFinished(true);
                    }
                    catch (RuntimeException ex) {
                        StartCompareAction.this.reenableGUIComponents();
                        throw new RuntimeException(ex);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup() {
                    try {
                        if (this.getDoStuffException() != null) {
                            Throwable exc = this.getDoStuffException();
                            logger.error((Object)"Error in doStuff()", exc);
                            ASUtils.showExceptionDialog(CompareDMPanel.this.session, Messages.getString("CompareDMPanel.databaseComparisonFailed"), exc);
                            StartCompareAction.this.reenableGUIComponents();
                            return;
                        }
                        logger.debug((Object)"cleanup starts");
                        CompareDMFormatter dmFormat = new CompareDMFormatter(CompareDMPanel.this.session, CompareDMPanel.this.parentDialog, CompareDMPanel.this.session.getCompareDMSettings());
                        this.checkCancelled();
                        switch (CompareDMPanel.this.session.getCompareDMSettings().getOutputFormat()) {
                            case SQL: 
                            case LIQUIBASE: {
                                dmFormat.formatForSQLOutput(this.diff, this.diff1, left, right);
                                break;
                            }
                            case ENGLISH: {
                                dmFormat.formatForEnglishOutput(this.diff, this.diff1, left, right);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Don't know what type of output to make");
                            }
                        }
                        logger.debug((Object)"cleanup finished");
                    }
                    catch (CancellationException e) {
                        this.setFinished(true);
                    }
                    finally {
                        StartCompareAction.this.reenableGUIComponents();
                    }
                }

                protected String getMessageImpl() {
                    if (sourceComp.hasStarted() && !sourceComp.isFinished()) {
                        return sourceComp.getMessage();
                    }
                    if (targetComp.hasStarted() && !targetComp.isFinished()) {
                        return targetComp.getMessage();
                    }
                    return this.message;
                }

                protected int getProgressImpl() {
                    return sourceComp.getProgress() + targetComp.getProgress();
                }
            };
            ProgressWatcher pw = new ProgressWatcher(CompareDMPanel.this.progressBar, (Monitorable)this.compareWorker, CompareDMPanel.this.statusLabel);
            pw.setHideLabelWhenFinished(true);
            pw.start();
            new Thread((Runnable)this.compareWorker).start();
        }

        private void reenableGUIComponents() {
            CompareDMPanel.this.sqlButton.setEnabled(true);
            CompareDMPanel.this.englishButton.setEnabled(true);
            CompareDMPanel.this.liquibaseButton.setEnabled(true);
            if (CompareDMPanel.this.sqlButton.isSelected()) {
                CompareDMPanel.this.sqlTypeDropdown.setEnabled(true);
            } else {
                CompareDMPanel.this.showNoChanges.setEnabled(true);
            }
            CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
        }
    }

    public class OutputChoiceListener
    implements ActionListener {
        JComboBox cb;

        public OutputChoiceListener(JComboBox cb) {
            this.cb = cb;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasVisible = CompareDMPanel.this.lbOptions.getPanel().isVisible();
            if (e.getActionCommand().equals(CompareDMPanel.OUTPUT_SQL)) {
                this.cb.setEnabled(true);
                CompareDMPanel.this.showNoChanges.setEnabled(false);
                CompareDMPanel.this.lbOptions.getPanel().setVisible(false);
            } else if (e.getActionCommand().equals(CompareDMPanel.OUTPUT_LIQUIBASE)) {
                this.cb.setEnabled(false);
                CompareDMPanel.this.showNoChanges.setEnabled(false);
                CompareDMPanel.this.lbOptions.getPanel().setVisible(true);
            } else {
                this.cb.setEnabled(false);
                CompareDMPanel.this.lbOptions.getPanel().setVisible(false);
                CompareDMPanel.this.showNoChanges.setEnabled(true);
            }
            CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
            if (wasVisible != CompareDMPanel.this.lbOptions.getPanel().isVisible() && CompareDMPanel.this.isVisible()) {
                CompareDMPanel.this.doLayout();
            }
        }
    }

    public class SourceOrTargetStuff {
        private JComboBox databaseDropdown;
        private JComboBox catalogDropdown;
        private JComboBox schemaDropdown;
        private JButton newConnButton;
        private JButton loadFileButton;
        private JTextField loadFilePath;
        private ButtonGroup buttonGroup = new ButtonGroup();
        private final JLabel playPenName = new JLabel();
        private JRadioButton playPenRadio;
        private JRadioButton physicalRadio;
        private JRadioButton loadRadio;
        private JDialog newConnectionDialog;
        private JLabel catalogLabel;
        private JLabel schemaLabel;
        private SchemaPopulator schemaPop;
        private CatalogPopulator catalogPop;
        private boolean isSource;
        private SQLDatabase cachedDatabase;
        private Action newConnectionAction = new AbstractAction(Messages.getString("CompareDMPanel.newConnectionActionName")){

            @Override
            public void actionPerformed(ActionEvent e) {
                final DataSourceCollection<JDBCDataSource> plDotIni = CompareDMPanel.this.session.getDataSources();
                final JDBCDataSource dataSource = new JDBCDataSource(plDotIni);
                Runnable onAccept = new Runnable(){

                    @Override
                    public void run() {
                        plDotIni.addDataSource((SPDataSource)dataSource);
                        SourceOrTargetStuff.this.databaseDropdown.setSelectedItem(dataSource);
                    }
                };
                ASUtils.showDbcsDialog(SPSUtils.getWindowInHierarchy((Component)CompareDMPanel.this), dataSource, onAccept);
            }
        };
        private Action chooseFileAction = new AbstractAction(Messages.getString("CompareDMPanel.chooseFileActionName")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(CompareDMPanel.this.session.getRecentMenu().getMostRecentFile());
                chooser.addChoosableFileFilter(SPSUtils.ARCHITECT_FILE_FILTER);
                int returnVal = chooser.showOpenDialog(CompareDMPanel.this);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    SourceOrTargetStuff.this.loadFilePath.setText(file.getPath());
                }
            }
        };

        public synchronized JDialog getNewConnectionDialog() {
            return this.newConnectionDialog;
        }

        void updatePlayPenNameLabel() {
            String newPlaypenName = Messages.getString("CompareDMPanel.currentProject", CompareDMPanel.this.session.getName());
            this.playPenName.setText(newPlaypenName);
            logger.debug((Object)("Updated playpen name to " + newPlaypenName));
        }

        private void buildPartialUI(DefaultFormBuilder builder, boolean defaultPlayPen, SchemaPopulator schemaPop, CatalogPopulator catalogPop) {
            String prefix = defaultPlayPen ? "source" : "target";
            this.isSource = defaultPlayPen;
            this.schemaPop = schemaPop;
            this.catalogPop = catalogPop;
            CellConstraints cc = new CellConstraints();
            this.playPenRadio = new JRadioButton();
            this.playPenRadio.setName(prefix + "PlayPenRadio");
            this.physicalRadio = new JRadioButton();
            this.physicalRadio.setName(prefix + "PhysicalRadio");
            this.loadRadio = new JRadioButton();
            this.loadRadio.setName(prefix + "LoadRadio");
            this.buttonGroup.add(this.playPenRadio);
            this.buttonGroup.add(this.physicalRadio);
            this.buttonGroup.add(this.loadRadio);
            this.schemaDropdown = new JComboBox();
            this.schemaDropdown.setEnabled(false);
            this.schemaDropdown.setName(prefix + "SchemaDropdown");
            this.catalogDropdown = new JComboBox();
            this.catalogDropdown.setEnabled(false);
            this.catalogDropdown.setName(prefix + "CatalogDropdown");
            this.databaseDropdown = new JComboBox();
            this.databaseDropdown.setName(prefix + "DatabaseDropdown");
            this.databaseDropdown.setModel(new ConnectionComboBoxModel(CompareDMPanel.this.session.getDataSources()));
            this.databaseDropdown.setEnabled(false);
            this.databaseDropdown.setRenderer(CompareDMPanel.this.dataSourceRenderer);
            this.newConnButton = new JButton();
            this.newConnButton.setName(prefix + "NewConnButton");
            this.newConnButton.setAction(this.newConnectionAction);
            this.newConnectionAction.setEnabled(false);
            this.loadFilePath = new JTextField();
            this.loadFilePath.setName(prefix + "LoadFilePath");
            this.loadFilePath.setEnabled(false);
            this.loadFilePath.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                }
            });
            this.loadFileButton = new JButton();
            this.loadFileButton.setName(prefix + "LoadFileButton");
            this.loadFileButton.setAction(this.chooseFileAction);
            this.chooseFileAction.setEnabled(false);
            this.catalogDropdown.addActionListener(schemaPop);
            this.databaseDropdown.addActionListener(catalogPop);
            this.databaseDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String generatorClass;
                    if (!SourceOrTargetStuff.this.isSource) {
                        return;
                    }
                    JDBCDataSource dataSource = (JDBCDataSource)SourceOrTargetStuff.this.databaseDropdown.getSelectedItem();
                    if (dataSource != null && (generatorClass = dataSource.getParentType().getDDLGeneratorClass()) != null) {
                        try {
                            CompareDMPanel.this.sqlTypeDropdown.setSelectedItem(Class.forName(generatorClass, true, CompareDMPanel.class.getClassLoader()));
                        }
                        catch (ClassNotFoundException ex) {
                            logger.error((Object)"Error when finding the DDLGenerator class for the selected database!", (Throwable)ex);
                        }
                    }
                }
            });
            OptionGroupListener listener = new OptionGroupListener();
            this.playPenRadio.addActionListener(listener);
            this.physicalRadio.addActionListener(listener);
            this.loadRadio.addActionListener(listener);
            if (defaultPlayPen) {
                this.playPenRadio.doClick();
            } else {
                this.physicalRadio.doClick();
            }
            this.updatePlayPenNameLabel();
            builder.append((Component)this.playPenRadio);
            builder.append((Component)this.playPenName, 7);
            CompareDMPanel.this.associate(this.playPenName, this.playPenRadio);
            builder.nextLine();
            builder.append("");
            builder.append((Component)this.physicalRadio);
            JLabel temp = builder.append(Messages.getString("CompareDMPanel.physicalDatabaseLabel"));
            CompareDMPanel.this.associate(temp, this.physicalRadio);
            this.catalogLabel = new JLabel(Messages.getString("CompareDMPanel.catalogLabel"));
            builder.append((Component)this.catalogLabel);
            this.schemaLabel = new JLabel(Messages.getString("CompareDMPanel.schemaLabel"));
            builder.append((Component)this.schemaLabel);
            builder.appendRow(builder.getLineGapSpec());
            builder.appendRow("pref");
            builder.nextLine(2);
            builder.nextColumn(4);
            builder.append((Component)this.databaseDropdown);
            builder.append((Component)this.catalogDropdown, (Component)this.schemaDropdown, (Component)this.newConnButton);
            builder.nextLine();
            builder.append("");
            builder.append((Component)this.loadRadio);
            temp = builder.append(Messages.getString("CompareDMPanel.fromFileLabel"));
            CompareDMPanel.this.associate(temp, this.loadRadio);
            builder.nextLine();
            builder.append("");
            builder.add((Component)this.loadFilePath, cc.xyw(5, builder.getRow(), 5));
            builder.nextColumn(8);
            builder.append((Component)this.loadFileButton);
            builder.nextLine();
        }

        public boolean isModelWithUUID() {
            return this.playPenRadio.isSelected() || this.loadRadio.isSelected();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SQLObject getObjectToCompare() throws SQLObjectException, IOException {
            if (this.playPenRadio.isSelected()) {
                return CompareDMPanel.this.session.getTargetDatabase();
            }
            if (this.physicalRadio.isSelected()) {
                if (this.schemaDropdown.getSelectedItem() != null) {
                    return (SQLObject)this.schemaDropdown.getSelectedItem();
                }
                if (this.catalogDropdown.getSelectedItem() != null) {
                    return (SQLObject)this.catalogDropdown.getSelectedItem();
                }
                if (this.databaseDropdown.getSelectedItem() == null) throw new IllegalStateException(Messages.getString("CompareDMPanel.noSchemaCatalogOrDatabaseSelected"));
                return this.getDatabase();
            }
            if (!this.loadRadio.isSelected()) throw new IllegalStateException(Messages.getString("CompareDMPanel.doNotKnowWhichSourceToCompare"));
            File f = new File(this.loadFilePath.getText());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            ArchitectSwingSession newSession = CompareDMPanel.this.session.getContext().createSession(in);
            return newSession.getTargetDatabase();
        }

        private ValidateResult getStartabilityStatus() {
            ValidateResult result;
            String sourceOrTarget;
            String string = sourceOrTarget = this.isSource() ? Messages.getString("CompareDMPanel.older") : Messages.getString("CompareDMPanel.newer");
            if (this.playPenRadio.isSelected()) {
                result = null;
            } else if (this.physicalRadio.isSelected()) {
                result = this.databaseDropdown.getSelectedItem() == null ? ValidateResult.createValidateResult((Status)Status.FAIL, (String)Messages.getString("CompareDMPanel.incompleteSelection", sourceOrTarget)) : null;
            } else if (this.loadRadio.isSelected()) {
                result = new File(this.loadFilePath.getText()).canRead() ? null : ValidateResult.createValidateResult((Status)Status.FAIL, (String)Messages.getString("CompareDMPanel.projectFileNotReadable", sourceOrTarget));
            } else {
                throw new IllegalStateException(Messages.getString("CompareDMPanel.noRadioButtonsSelected"));
            }
            return result;
        }

        public synchronized SQLDatabase getDatabase() {
            JDBCDataSource ds = (JDBCDataSource)this.databaseDropdown.getSelectedItem();
            if (ds == null) {
                this.cachedDatabase = null;
            } else if (this.cachedDatabase == null || !this.cachedDatabase.getDataSource().equals((Object)ds)) {
                this.cachedDatabase = new SQLDatabase(ds);
            }
            return this.cachedDatabase;
        }

        void enableDisablePhysicalComps() {
            boolean enable = this.physicalRadio.isSelected();
            this.databaseDropdown.setEnabled(enable);
            if (enable && this.catalogDropdown.getItemCount() > 0) {
                this.catalogDropdown.setEnabled(true);
            } else {
                this.catalogDropdown.setEnabled(false);
            }
            if (enable && this.schemaDropdown.getItemCount() > 0) {
                this.schemaDropdown.setEnabled(true);
            } else {
                this.schemaDropdown.setEnabled(false);
            }
            this.newConnectionAction.setEnabled(enable);
        }

        boolean isSource() {
            return this.isSource;
        }

        public class OptionGroupListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                SourceOrTargetStuff.this.enableDisablePhysicalComps();
                boolean enableLoadComps = e.getSource() == SourceOrTargetStuff.this.loadRadio;
                SourceOrTargetStuff.this.loadFilePath.setEnabled(enableLoadComps);
                SourceOrTargetStuff.this.loadFileButton.setEnabled(enableLoadComps);
            }
        }

        private abstract class PopulateProgressMonitorableWorker
        extends SPSwingWorker {
            public PopulateProgressMonitorableWorker(ArchitectSwingSession session) {
                super((SwingWorkerRegistry)session);
                this.setJobSize(null);
                this.setProgress(0);
                this.setMessage(Messages.getString("CompareDMPanel.connectingToDatabase"));
            }
        }

        public class SchemaPopulator
        extends PopulateProgressMonitorableWorker
        implements ActionListener {
            String select;
            boolean populating;

            public SchemaPopulator(ArchitectSwingSession session) {
                super(session);
                this.populating = false;
                this.select = null;
            }

            public void setDefaultSelect(String select) {
                this.select = select;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)"SCHEMA POPULATOR IS ABOUT TO START...");
                SourceOrTargetStuff.this.schemaDropdown.removeAllItems();
                SourceOrTargetStuff.this.schemaDropdown.setEnabled(false);
                SQLCatalog catToPopulate = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                if (catToPopulate != null && !this.populating) {
                    this.populating = true;
                    CompareDMPanel.this.startCompareAction.setEnabled(false);
                    Thread t = new Thread((Runnable)((Object)this));
                    t.start();
                }
            }

            public void doStuff() throws SQLObjectException {
                logger.debug((Object)"SCHEMA POPULATOR IS STARTED...");
                ProgressWatcher.watchProgress((JProgressBar)CompareDMPanel.this.progressBar, (Monitorable)this);
                SQLCatalog catToPopulate = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                catToPopulate.populate();
            }

            public void cleanup() throws SQLObjectException {
                logger.debug((Object)"SCHEMA POPULATOR IS ABOUT TO CLEAN UP...");
                SourceOrTargetStuff.this.schemaLabel.setText("");
                SQLCatalog populatedCat = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                if (populatedCat.isSchemaContainer()) {
                    for (SQLObject item : populatedCat.getChildren()) {
                        SourceOrTargetStuff.this.schemaDropdown.addItem(item);
                    }
                    if (SourceOrTargetStuff.this.schemaDropdown.getItemCount() > 0) {
                        SourceOrTargetStuff.this.schemaDropdown.setEnabled(true);
                        if (((SQLSchema)populatedCat.getChild(0)).getNativeTerm() != null) {
                            SourceOrTargetStuff.this.schemaLabel.setText(((SQLSchema)populatedCat.getChild(0)).getNativeTerm());
                        }
                    }
                }
                CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                logger.debug((Object)("Default Schema: " + this.select));
                if (this.select != null) {
                    for (int x = 0; x < SourceOrTargetStuff.this.schemaDropdown.getItemCount(); ++x) {
                        SQLObject curr = (SQLObject)SourceOrTargetStuff.this.schemaDropdown.getItemAt(x);
                        if (curr == null || !curr.getName().equals(this.select)) continue;
                        SourceOrTargetStuff.this.schemaDropdown.setSelectedIndex(x);
                        break;
                    }
                }
                this.select = null;
                this.populating = false;
            }
        }

        public class CatalogPopulator
        extends PopulateProgressMonitorableWorker
        implements ActionListener {
            String catalogSelect;
            String schemaSelect;
            private SQLDatabase db;

            public CatalogPopulator(ArchitectSwingSession session) {
                super(session);
                this.catalogSelect = null;
                this.schemaSelect = null;
            }

            public void setDefaultCatalog(String def) {
                this.catalogSelect = def;
            }

            public void setDefaultSchema(String def) {
                this.schemaSelect = def;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDMPanel.this.startCompareAction.setEnabled(false);
                this.db = SourceOrTargetStuff.this.getDatabase();
                if (this.db != null) {
                    if (((JComboBox)e.getSource()).getSelectedIndex() == 0) {
                        CompareDMPanel.this.startCompareAction.setEnabled(false);
                    }
                    new Thread((Runnable)((Object)this)).start();
                } else {
                    SourceOrTargetStuff.this.catalogDropdown.removeAllItems();
                    SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                    SourceOrTargetStuff.this.schemaDropdown.removeAllItems();
                    SourceOrTargetStuff.this.schemaDropdown.setEnabled(false);
                }
            }

            public void doStuff() throws Exception {
                try {
                    ProgressWatcher.watchProgress((JProgressBar)CompareDMPanel.this.progressBar, (Monitorable)this);
                    this.db.populate();
                }
                catch (SQLObjectException e) {
                    logger.debug((Object)"Unexpected architect exception in ConnectionListener", (Throwable)e);
                    ASUtils.showExceptionDialogNoReport(CompareDMPanel.this, Messages.getString("CompareDMPanel.unexpectedExceptionInConnectionListener"), e);
                }
            }

            public void cleanup() throws SQLObjectException {
                SQLDatabase schemaParent;
                this.setCleanupExceptionMessage(Messages.getString("CompareDMPanel.couldNotPopulateCatalogDropdown"));
                SourceOrTargetStuff.this.catalogDropdown.removeAllItems();
                SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                SourceOrTargetStuff.this.catalogLabel.setText("");
                SourceOrTargetStuff.this.schemaLabel.setText("");
                if (this.db.isCatalogContainer()) {
                    for (SQLCatalog item : this.db.getChildren(SQLCatalog.class)) {
                        SourceOrTargetStuff.this.catalogDropdown.addItem(item);
                    }
                    SQLCatalog cat = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                    if (cat != null && cat.getNativeTerm() != null) {
                        SourceOrTargetStuff.this.catalogLabel.setText(cat.getNativeTerm());
                    }
                    schemaParent = null;
                    if (cat == null) {
                        SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                    } else {
                        SourceOrTargetStuff.this.catalogDropdown.setEnabled(true);
                    }
                } else if (this.db.isSchemaContainer()) {
                    schemaParent = this.db;
                    SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                } else {
                    schemaParent = null;
                    SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                }
                SourceOrTargetStuff.this.schemaDropdown.removeAllItems();
                SourceOrTargetStuff.this.schemaDropdown.setEnabled(false);
                if (schemaParent == null) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                } else {
                    SQLDatabase finalSchemaParent = schemaParent;
                    new Thread((Runnable)((Object)new PopulateProgressMonitorableWorker(CompareDMPanel.this.session, (SQLObject)finalSchemaParent){
                        final /* synthetic */ SQLObject val$finalSchemaParent;
                        {
                            this.val$finalSchemaParent = sQLObject;
                            super(x0);
                        }

                        public void doStuff() throws Exception {
                            ProgressWatcher.watchProgress((JProgressBar)CompareDMPanel.this.progressBar, (Monitorable)this);
                            this.val$finalSchemaParent.getChildren();
                        }

                        public void cleanup() throws SQLObjectException {
                            this.setCleanupExceptionMessage(Messages.getString("CompareDMPanel.couldNotPopulateSchemaDropdown"));
                            for (SQLObject item : this.val$finalSchemaParent.getChildren()) {
                                SourceOrTargetStuff.this.schemaDropdown.addItem(item);
                            }
                            if (SourceOrTargetStuff.this.schemaDropdown.getItemCount() > 0) {
                                SourceOrTargetStuff.this.schemaDropdown.setEnabled(true);
                                if (((SQLSchema)this.val$finalSchemaParent.getChild(0)).getNativeTerm() != null) {
                                    SourceOrTargetStuff.this.schemaLabel.setText(((SQLSchema)this.val$finalSchemaParent.getChild(0)).getNativeTerm());
                                }
                            }
                            CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                            logger.debug((Object)("default schema is: " + CatalogPopulator.this.schemaSelect));
                            if (CatalogPopulator.this.schemaSelect != null) {
                                for (int x = 0; x < SourceOrTargetStuff.this.schemaDropdown.getItemCount(); ++x) {
                                    SQLObject curr = (SQLObject)SourceOrTargetStuff.this.schemaDropdown.getItemAt(x);
                                    if (curr == null || !curr.getName().equals(CatalogPopulator.this.schemaSelect)) continue;
                                    SourceOrTargetStuff.this.schemaDropdown.setSelectedIndex(x);
                                    break;
                                }
                            }
                            CatalogPopulator.this.schemaSelect = null;
                        }
                    })).start();
                }
                logger.debug((Object)("default catalog selected " + this.catalogSelect));
                if (this.catalogSelect != null) {
                    for (int x = 0; x < SourceOrTargetStuff.this.catalogDropdown.getItemCount(); ++x) {
                        SQLObject curr = (SQLObject)SourceOrTargetStuff.this.catalogDropdown.getItemAt(x);
                        if (curr == null || !curr.getName().equals(this.catalogSelect)) continue;
                        SourceOrTargetStuff.this.catalogDropdown.setSelectedIndex(x);
                        break;
                    }
                }
                this.catalogSelect = null;
            }

            protected boolean isFinishedImpl() {
                if (this.db != null) {
                    return this.db.isPopulated();
                }
                return true;
            }
        }
    }

    private static class RestoreSettingsListener
    implements ListDataListener {
        private JComboBox box;
        private String selectItemName;

        public RestoreSettingsListener(JComboBox box, String selectItemName) {
            this.box = box;
            this.selectItemName = selectItemName;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.tryToSelectTheItem(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.tryToSelectTheItem(e.getIndex0(), e.getIndex1());
        }

        private void tryToSelectTheItem(int low, int high) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for '" + this.selectItemName + "' from index " + low + " to " + high));
            }
            for (int i = low; i <= high; ++i) {
                SQLObject o = (SQLObject)this.box.getItemAt(i);
                if (o == null || !o.getName().equals(this.selectItemName)) continue;
                this.box.setSelectedIndex(i);
                this.box.getModel().removeListDataListener(this);
                return;
            }
        }
    }
}

