/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.ProxyFilter;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.SslChannelProvider;
import io.vertx.core.net.impl.SslContextUpdate;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class NetClientImpl
implements MetricsProvider,
NetClient,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(NetClientImpl.class);
    protected final int idleTimeout;
    protected final int readIdleTimeout;
    protected final int writeIdleTimeout;
    private final TimeUnit idleTimeoutUnit;
    protected final boolean logEnabled;
    private final VertxInternal vertx;
    private final NetClientOptions options;
    private final SSLHelper sslHelper;
    private Future<SslContextUpdate> sslChannelProvider;
    private final ChannelGroup channelGroup;
    private final TCPMetrics metrics;
    private final CloseFuture closeFuture;
    private final Predicate<SocketAddress> proxyFilter;

    public NetClientImpl(VertxInternal vertx, TCPMetrics metrics, NetClientOptions options, CloseFuture closeFuture) {
        this.vertx = vertx;
        this.channelGroup = new DefaultChannelGroup((EventExecutor)vertx.getAcceptorEventLoopGroup().next());
        this.options = new NetClientOptions(options);
        this.sslHelper = new SSLHelper(options, options.getApplicationLayerProtocols());
        this.metrics = metrics;
        this.logEnabled = options.getLogActivity();
        this.idleTimeout = options.getIdleTimeout();
        this.readIdleTimeout = options.getReadIdleTimeout();
        this.writeIdleTimeout = options.getWriteIdleTimeout();
        this.idleTimeoutUnit = options.getIdleTimeoutUnit();
        this.closeFuture = closeFuture;
        this.proxyFilter = options.getNonProxyHosts() != null ? ProxyFilter.nonProxyHosts(options.getNonProxyHosts()) : ProxyFilter.DEFAULT_PROXY_FILTER;
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        if (this.options.isSsl() || !this.vertx.transport().supportFileRegion()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.idleTimeout > 0 || this.readIdleTimeout > 0 || this.writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler((long)this.readIdleTimeout, (long)this.writeIdleTimeout, (long)this.idleTimeout, this.idleTimeoutUnit));
        }
    }

    @Override
    public Future<NetSocket> connect(int port, String host) {
        return this.connect(port, host, (String)null);
    }

    @Override
    public Future<NetSocket> connect(int port, String host, String serverName) {
        return this.connect(SocketAddress.inetSocketAddress(port, host), serverName);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (String)null);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        return this.connect(this.vertx.getOrCreateContext(), remoteAddress, serverName);
    }

    public Future<NetSocket> connect(ContextInternal context, SocketAddress remoteAddress, String serverName) {
        PromiseInternal<NetSocket> promise = context.promise();
        this.connect(remoteAddress, serverName, promise, context);
        return promise.future();
    }

    @Override
    public NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        return this.connect(port, host, null, connectHandler);
    }

    @Override
    public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        return this.connect(SocketAddress.inetSocketAddress(port, host), serverName, connectHandler);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = closingCtx.promise();
        this.closeFuture.close(promise);
        return promise.future();
    }

    @Override
    public void close(Promise<Void> completion) {
        ChannelGroupFuture fut = this.channelGroup.close();
        if (this.metrics != null) {
            PromiseInternal p = (PromiseInternal)Promise.promise();
            fut.addListener((GenericFutureListener)p);
            p.future().compose(v -> {
                this.metrics.close();
                return Future.succeededFuture();
            }).onComplete(completion);
        } else {
            fut.addListener((GenericFutureListener)((PromiseInternal)completion));
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> updateSSLOptions(SSLOptions options) {
        Future<SslContextUpdate> fut;
        ContextInternal ctx = this.vertx.getOrCreateContext();
        NetClientImpl netClientImpl = this;
        synchronized (netClientImpl) {
            fut = this.sslHelper.updateSslContext(new SSLOptions(options), ctx);
            this.sslChannelProvider = fut;
        }
        return fut.transform(ar -> {
            if (ar.failed()) {
                return ctx.failedFuture(ar.cause());
            }
            if (ar.succeeded() && ((SslContextUpdate)ar.result()).error() != null) {
                return ctx.failedFuture(((SslContextUpdate)ar.result()).error());
            }
            return ctx.succeededFuture();
        });
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<NetSocket> promise = ctx.promise();
        promise.future().onComplete(connectHandler);
        this.connect(remoteAddress, serverName, promise, ctx);
        return this;
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) {
        return this.connect(remoteAddress, null, connectHandler);
    }

    private void connect(SocketAddress remoteAddress, String serverName, Promise<NetSocket> connectHandler, ContextInternal ctx) {
        if (this.closeFuture.isClosed()) {
            throw new IllegalStateException("Client is closed");
        }
        SocketAddress peerAddress = remoteAddress;
        String peerHost = peerAddress.host();
        if (peerHost != null && peerHost.endsWith(".")) {
            peerAddress = SocketAddress.inetSocketAddress(peerAddress.port(), peerHost.substring(0, peerHost.length() - 1));
        }
        ProxyOptions proxyOptions = this.options.getProxyOptions();
        if (this.proxyFilter != null && !this.proxyFilter.test(remoteAddress)) {
            proxyOptions = null;
        }
        this.connectInternal(proxyOptions, remoteAddress, peerAddress, serverName, this.options.isSsl(), this.options.isUseAlpn(), this.options.isRegisterWriteHandler(), connectHandler, ctx, this.options.getReconnectAttempts());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectInternal(ProxyOptions proxyOptions, SocketAddress remoteAddress, SocketAddress peerAddress, String serverName, boolean ssl, boolean useAlpn, boolean registerWriteHandlers, Promise<NetSocket> connectHandler, ContextInternal context, int remainingAttempts) {
        if (this.closeFuture.isClosed()) {
            connectHandler.fail(new IllegalStateException("Client is closed"));
        } else {
            Future<SslContextUpdate> fut;
            NetClientImpl netClientImpl = this;
            synchronized (netClientImpl) {
                fut = this.sslChannelProvider;
                if (fut == null) {
                    this.sslChannelProvider = fut = this.sslHelper.updateSslContext(this.options.getSslOptions(), context);
                }
            }
            fut.onComplete(ar -> {
                if (ar.succeeded()) {
                    this.connectInternal2(proxyOptions, remoteAddress, peerAddress, ((SslContextUpdate)ar.result()).sslChannelProvider(), serverName, ssl, useAlpn, registerWriteHandlers, connectHandler, context, remainingAttempts);
                } else {
                    connectHandler.fail(ar.cause());
                }
            });
        }
    }

    private void connectInternal2(ProxyOptions proxyOptions, SocketAddress remoteAddress, SocketAddress peerAddress, SslChannelProvider sslChannelProvider, String serverName, boolean ssl, boolean useAlpn, boolean registerWriteHandlers, Promise<NetSocket> connectHandler, ContextInternal context, int remainingAttempts) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)eventLoop);
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
            this.vertx.transport().configure(this.options, remoteAddress.isDomainSocket(), bootstrap);
            ChannelProvider channelProvider = new ChannelProvider(bootstrap, sslChannelProvider, context).proxyOptions(proxyOptions);
            channelProvider.handler(ch -> this.connected(context, (Channel)ch, connectHandler, remoteAddress, sslChannelProvider, channelProvider.applicationProtocol(), registerWriteHandlers));
            io.netty.util.concurrent.Future<Channel> fut = channelProvider.connect(remoteAddress, peerAddress, serverName, ssl, useAlpn);
            fut.addListener(future -> {
                if (!future.isSuccess()) {
                    boolean connectError;
                    Throwable cause = future.cause();
                    boolean bl = connectError = cause instanceof ConnectException || cause instanceof FileNotFoundException;
                    if (connectError && (remainingAttempts > 0 || remainingAttempts == -1)) {
                        context.emit(v -> {
                            log.debug("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds");
                            this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.connectInternal(proxyOptions, remoteAddress, peerAddress, serverName, ssl, useAlpn, registerWriteHandlers, connectHandler, context, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                        });
                    } else {
                        this.failed(context, null, cause, connectHandler);
                    }
                }
            });
        } else {
            eventLoop.execute(() -> this.connectInternal2(proxyOptions, remoteAddress, peerAddress, sslChannelProvider, serverName, ssl, useAlpn, registerWriteHandlers, connectHandler, context, remainingAttempts));
        }
    }

    private void connected(ContextInternal context, Channel ch, Promise<NetSocket> connectHandler, SocketAddress remoteAddress, SslChannelProvider sslChannelProvider, String applicationLayerProtocol, boolean registerWriteHandlers) {
        this.channelGroup.add((Object)ch);
        this.initChannel(ch.pipeline());
        VertxHandler<NetSocketImpl> handler = VertxHandler.create(ctx -> new NetSocketImpl(context, (ChannelHandlerContext)ctx, remoteAddress, sslChannelProvider, this.metrics, applicationLayerProtocol, registerWriteHandlers));
        handler.removeHandler(NetSocketImpl::unregisterEventBusHandler);
        handler.addHandler(sock -> {
            if (this.metrics != null) {
                sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
            }
            sock.registerEventBusHandler();
            connectHandler.complete((NetSocket)sock);
        });
        ch.pipeline().addLast("handler", handler);
    }

    private void failed(ContextInternal context, Channel ch, Throwable th, Promise<NetSocket> connectHandler) {
        if (ch != null) {
            ch.close();
        }
        context.emit(th, connectHandler::tryFail);
    }
}

