/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.stat;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.stat.MetricInfo;

abstract class BaseMetricInfo
implements MetricInfo {
    private final String name;
    private final String description;
    private final Map<String, String> map;

    BaseMetricInfo(String name, String description, Map<String, String> map) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
        this.map = map == null || map.isEmpty() ? Collections.emptyMap() : Map.copyOf(map);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final Map<String, String> getTags() {
        return this.map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.getName() + "', description='" + this.getDescription() + "', tags=" + String.valueOf(this.getTags()) + "}";
    }
}

