/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageProviderFactory;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.keys.infinispan.InfinispanPublicKeyStorageProvider;
import org.keycloak.keys.infinispan.PublicKeysEntry;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class InfinispanPublicKeyStorageProviderFactory
implements PublicKeyStorageProviderFactory,
EnvironmentDependentProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanPublicKeyStorageProviderFactory.class);
    public static final String PROVIDER_ID = "infinispan";
    private volatile Cache<String, PublicKeysEntry> keysCache;
    private final Map<String, FutureTask<PublicKeysEntry>> tasksInProgress = new ConcurrentHashMap<String, FutureTask<PublicKeysEntry>>();
    private int minTimeBetweenRequests;

    public PublicKeyStorageProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanPublicKeyStorageProvider(session, this.keysCache, this.tasksInProgress, this.minTimeBetweenRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.keysCache == null) {
            InfinispanPublicKeyStorageProviderFactory infinispanPublicKeyStorageProviderFactory = this;
            synchronized (infinispanPublicKeyStorageProviderFactory) {
                if (this.keysCache == null) {
                    this.keysCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("keys");
                }
            }
        }
    }

    public void init(Config.Scope config) {
        this.minTimeBetweenRequests = config.getInt("minTimeBetweenRequests", Integer.valueOf(10));
        log.debugf("minTimeBetweenRequests is %d", this.minTimeBetweenRequests);
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (InfinispanPublicKeyStorageProviderFactory.this.keysCache == null) {
                    return;
                }
                SessionAndKeyHolder cacheKey = InfinispanPublicKeyStorageProviderFactory.this.getCacheKeyToInvalidate(event);
                if (cacheKey != null) {
                    log.debugf("Invalidating %s from keysCache", (Object)cacheKey);
                    InfinispanPublicKeyStorageProvider provider = (InfinispanPublicKeyStorageProvider)cacheKey.session.getProvider(PublicKeyStorageProvider.class, InfinispanPublicKeyStorageProviderFactory.this.getId());
                    for (String ck : cacheKey.cacheKeys) {
                        provider.addInvalidation(ck);
                    }
                }
            }
        });
    }

    private SessionAndKeyHolder getCacheKeyToInvalidate(ProviderEvent event) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        String cacheKey = null;
        if (event instanceof ClientModel.ClientUpdatedEvent) {
            ClientModel.ClientUpdatedEvent eventt = (ClientModel.ClientUpdatedEvent)event;
            cacheKey = PublicKeyStorageUtils.getClientModelCacheKey((String)eventt.getUpdatedClient().getRealm().getId(), (String)eventt.getUpdatedClient().getId(), (JWK.Use)JWK.Use.SIG);
            cacheKeys.add(cacheKey);
            cacheKey = PublicKeyStorageUtils.getClientModelCacheKey((String)eventt.getUpdatedClient().getRealm().getId(), (String)eventt.getUpdatedClient().getId(), (JWK.Use)JWK.Use.ENCRYPTION);
            cacheKeys.add(cacheKey);
            return new SessionAndKeyHolder(eventt.getKeycloakSession(), cacheKeys);
        }
        if (event instanceof ClientModel.ClientRemovedEvent) {
            ClientModel.ClientRemovedEvent eventt = (ClientModel.ClientRemovedEvent)event;
            cacheKey = PublicKeyStorageUtils.getClientModelCacheKey((String)eventt.getClient().getRealm().getId(), (String)eventt.getClient().getId(), (JWK.Use)JWK.Use.SIG);
            cacheKeys.add(cacheKey);
            cacheKey = PublicKeyStorageUtils.getClientModelCacheKey((String)eventt.getClient().getRealm().getId(), (String)eventt.getClient().getId(), (JWK.Use)JWK.Use.ENCRYPTION);
            cacheKeys.add(cacheKey);
            return new SessionAndKeyHolder(eventt.getKeycloakSession(), cacheKeys);
        }
        if (event instanceof RealmModel.IdentityProviderUpdatedEvent) {
            RealmModel.IdentityProviderUpdatedEvent eventt = (RealmModel.IdentityProviderUpdatedEvent)event;
            cacheKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)eventt.getRealm().getId(), (String)eventt.getUpdatedIdentityProvider().getInternalId());
            cacheKeys.add(cacheKey);
            return new SessionAndKeyHolder(eventt.getKeycloakSession(), cacheKeys);
        }
        if (event instanceof RealmModel.IdentityProviderRemovedEvent) {
            RealmModel.IdentityProviderRemovedEvent eventt = (RealmModel.IdentityProviderRemovedEvent)event;
            cacheKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)eventt.getRealm().getId(), (String)eventt.getRemovedIdentityProvider().getInternalId());
            cacheKeys.add(cacheKey);
            return new SessionAndKeyHolder(eventt.getKeycloakSession(), cacheKeys);
        }
        return null;
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    private static class SessionAndKeyHolder {
        private final KeycloakSession session;
        private final ArrayList<String> cacheKeys;

        public SessionAndKeyHolder(KeycloakSession session, ArrayList<String> cacheKeys) {
            this.session = session;
            this.cacheKeys = cacheKeys;
        }
    }
}

