/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.UnsupportedEncodingException;
import org.jfree.layouting.LibLayoutBoot;

public class UTFEncodingUtil {
    private static final String[] hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};

    private UTFEncodingUtil() {
    }

    public static String encodeUTF8(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : string.toCharArray()) {
            if ('A' <= c && c <= 'Z') {
                stringBuffer.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                stringBuffer.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                stringBuffer.append(c);
                continue;
            }
            if (c <= '\u007f') {
                stringBuffer.append(hex[c]);
                continue;
            }
            if (c <= '\u07ff') {
                stringBuffer.append(hex[0xC0 | c >> 6]);
                stringBuffer.append(hex[0x80 | c & 0x3F]);
                continue;
            }
            stringBuffer.append(hex[0xE0 | c >> 12]);
            stringBuffer.append(hex[0x80 | c >> 6 & 0x3F]);
            stringBuffer.append(hex[0x80 | c & 0x3F]);
        }
        return stringBuffer.toString();
    }

    private static String encodeBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (65 <= n2 && n2 <= 90) {
                stringBuffer.append((char)n2);
                continue;
            }
            if (97 <= n2 && n2 <= 122) {
                stringBuffer.append((char)n2);
                continue;
            }
            if (48 <= n2 && n2 <= 57) {
                stringBuffer.append((char)n2);
                continue;
            }
            if (n2 == 45 || n2 == 95 || n2 == 46 || n2 == 33 || n2 == 126 || n2 == 42 || n2 == 39 || n2 == 40 || n2 == 41) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append(hex[n2]);
        }
        return stringBuffer.toString();
    }

    public static String encode(String string, String string2) throws UnsupportedEncodingException {
        if ("utf-8".equalsIgnoreCase(string2)) {
            return UTFEncodingUtil.encodeUTF8(string);
        }
        return UTFEncodingUtil.encodeBytes(string.getBytes(string2));
    }

    public static String encode(String string) throws UnsupportedEncodingException {
        String string2 = LibLayoutBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.layouting.URLEncoding");
        return UTFEncodingUtil.encode(string, string2);
    }

    public static String decode(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = new byte[string.length()];
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n2;
            int n3 = cArray[i];
            switch (n3) {
                case 37: {
                    char c = string.charAt(++i);
                    int n4 = (Character.isDigit(c) ? c - 48 : 10 + Character.toLowerCase(c) - 97) & 0xF;
                    char c2 = string.charAt(++i);
                    int n5 = (Character.isDigit(c2) ? c2 - 48 : 10 + Character.toLowerCase(c2) - 97) & 0xF;
                    n2 = n4 << 4 | n5;
                    break;
                }
                case 43: {
                    n2 = 32;
                    break;
                }
                default: {
                    n2 = n3;
                }
            }
            byArray[n] = (byte)n2;
            ++n;
        }
        return new String(byArray, 0, n, string2);
    }

    public static String decodeUTF(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = cArray[i];
            switch (n5) {
                case 37: {
                    char c = string.charAt(++i);
                    int n6 = (Character.isDigit(c) ? c - 48 : 10 + Character.toLowerCase(c) - 97) & 0xF;
                    char c2 = string.charAt(++i);
                    int n7 = (Character.isDigit(c2) ? c2 - 48 : 10 + Character.toLowerCase(c2) - 97) & 0xF;
                    n4 = n6 << 4 | n7;
                    break;
                }
                case 43: {
                    n4 = 32;
                    break;
                }
                default: {
                    n4 = n5;
                }
            }
            if ((n4 & 0xC0) == 128) {
                n2 = n2 << 6 | n4 & 0x3F;
                if (--n3 != 0) continue;
                stringBuffer.append((char)n2);
                continue;
            }
            if ((n4 & 0x80) == 0) {
                stringBuffer.append((char)n4);
                continue;
            }
            if ((n4 & 0xE0) == 192) {
                n2 = n4 & 0x1F;
                n3 = 1;
                continue;
            }
            if ((n4 & 0xF0) == 224) {
                n2 = n4 & 0xF;
                n3 = 2;
                continue;
            }
            if ((n4 & 0xF8) == 240) {
                n2 = n4 & 7;
                n3 = 3;
                continue;
            }
            if ((n4 & 0xFC) == 248) {
                n2 = n4 & 3;
                n3 = 4;
                continue;
            }
            n2 = n4 & 1;
            n3 = 5;
        }
        return stringBuffer.toString();
    }
}

