/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.IOObject;
import com.microsoft.azure.eventhubs.impl.Operation;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FaultTolerantObject<T extends IOObject> {
    private final Operation<T> openTask;
    private final Operation<Void> closeTask;
    private final Queue<OperationResult<T, Exception>> openCallbacks;
    private final Queue<OperationResult<Void, Exception>> closeCallbacks;
    private T innerObject;
    private boolean creatingNewInnerObject;
    private boolean closingInnerObject;

    public FaultTolerantObject(Operation<T> openAsync, Operation<Void> closeAsync) {
        this.openTask = openAsync;
        this.closeTask = closeAsync;
        this.openCallbacks = new ConcurrentLinkedQueue<OperationResult<T, Exception>>();
        this.closeCallbacks = new ConcurrentLinkedQueue<OperationResult<Void, Exception>>();
    }

    T unsafeGetIfOpened() {
        if (this.innerObject != null && this.innerObject.getState() == IOObject.IOObjectState.OPENED) {
            return this.innerObject;
        }
        return null;
    }

    public void runOnOpenedObject(ReactorDispatcher dispatcher, final OperationResult<T, Exception> openCallback) {
        try {
            dispatcher.invoke(new DispatchHandler(){

                @Override
                public void onEvent() {
                    if (!(FaultTolerantObject.this.creatingNewInnerObject || FaultTolerantObject.this.innerObject != null && FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.CLOSED && FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.CLOSING)) {
                        FaultTolerantObject.this.creatingNewInnerObject = true;
                        try {
                            FaultTolerantObject.this.openCallbacks.offer(openCallback);
                            FaultTolerantObject.this.openTask.run(new OperationResult<T, Exception>(){

                                @Override
                                public void onComplete(T result) {
                                    FaultTolerantObject.this.innerObject = result;
                                    for (OperationResult callback : FaultTolerantObject.this.openCallbacks) {
                                        callback.onComplete(result);
                                    }
                                    FaultTolerantObject.this.openCallbacks.clear();
                                }

                                @Override
                                public void onError(Exception error) {
                                    for (OperationResult callback : FaultTolerantObject.this.openCallbacks) {
                                        callback.onError(error);
                                    }
                                    FaultTolerantObject.this.openCallbacks.clear();
                                }
                            });
                        }
                        finally {
                            FaultTolerantObject.this.creatingNewInnerObject = false;
                        }
                    } else if (FaultTolerantObject.this.innerObject != null && FaultTolerantObject.this.innerObject.getState() == IOObject.IOObjectState.OPENED) {
                        openCallback.onComplete(FaultTolerantObject.this.innerObject);
                    } else {
                        FaultTolerantObject.this.openCallbacks.offer(openCallback);
                    }
                }
            });
        }
        catch (IOException ioException) {
            openCallback.onError(ioException);
        }
    }

    public void close(ReactorDispatcher dispatcher, final OperationResult<Void, Exception> closeCallback) {
        try {
            dispatcher.invoke(new DispatchHandler(){

                @Override
                public void onEvent() {
                    if (FaultTolerantObject.this.innerObject == null || FaultTolerantObject.this.innerObject.getState() == IOObject.IOObjectState.CLOSED) {
                        closeCallback.onComplete(null);
                    } else if (!(FaultTolerantObject.this.closingInnerObject || FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.OPENED && FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.OPENING)) {
                        FaultTolerantObject.this.closingInnerObject = true;
                        FaultTolerantObject.this.closeCallbacks.offer(closeCallback);
                        FaultTolerantObject.this.closeTask.run(new OperationResult<Void, Exception>(){

                            @Override
                            public void onComplete(Void result) {
                                FaultTolerantObject.this.closingInnerObject = false;
                                for (OperationResult callback : FaultTolerantObject.this.closeCallbacks) {
                                    callback.onComplete(result);
                                }
                                FaultTolerantObject.this.closeCallbacks.clear();
                            }

                            @Override
                            public void onError(Exception error) {
                                FaultTolerantObject.this.closingInnerObject = false;
                                for (OperationResult callback : FaultTolerantObject.this.closeCallbacks) {
                                    callback.onError(error);
                                }
                                FaultTolerantObject.this.closeCallbacks.clear();
                            }
                        });
                    } else {
                        FaultTolerantObject.this.closeCallbacks.offer(closeCallback);
                    }
                }
            });
        }
        catch (IOException ioException) {
            closeCallback.onError(ioException);
        }
    }
}

