/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.cache;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastService;
import org.traccar.config.Config;
import org.traccar.model.Attribute;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Device;
import org.traccar.model.Driver;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.GroupedModel;
import org.traccar.model.Maintenance;
import org.traccar.model.Notification;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Permission;
import org.traccar.model.Position;
import org.traccar.model.Schedulable;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.session.cache.CacheGraph;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class CacheManager
implements BroadcastInterface {
    private static final Set<Class<? extends BaseModel>> GROUPED_CLASSES = Set.of(Attribute.class, Driver.class, Geofence.class, Maintenance.class, Notification.class);
    private final Config config;
    private final Storage storage;
    private final BroadcastService broadcastService;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CacheGraph graph = new CacheGraph();
    private Server server;
    private final Map<Long, Position> devicePositions = new HashMap<Long, Position>();
    private final Map<Long, AtomicInteger> deviceReferences = new HashMap<Long, AtomicInteger>();

    @Inject
    public CacheManager(Config config, Storage storage, BroadcastService broadcastService) throws StorageException {
        this.config = config;
        this.storage = storage;
        this.broadcastService = broadcastService;
        this.server = storage.getObject(Server.class, new Request(new Columns.All()));
        broadcastService.registerListener(this);
    }

    public String toString() {
        return this.graph.toString();
    }

    public Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> T getObject(Class<T> clazz, long id) {
        try {
            this.lock.readLock().lock();
            T t = this.graph.getObject(clazz, id);
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> Set<T> getDeviceObjects(long deviceId, Class<T> clazz) {
        try {
            this.lock.readLock().lock();
            Set set = this.graph.getObjects(Device.class, deviceId, clazz, Set.of(Group.class), true).collect(Collectors.toUnmodifiableSet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position getPosition(long deviceId) {
        try {
            this.lock.readLock().lock();
            Position position = this.devicePositions.get(deviceId);
            return position;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Server getServer() {
        try {
            this.lock.readLock().lock();
            Server server = this.server;
            return server;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<User> getNotificationUsers(long notificationId, long deviceId) {
        try {
            this.lock.readLock().lock();
            Set<User> deviceUsers = this.getDeviceObjects(deviceId, User.class);
            Set<User> set = this.graph.getObjects(Notification.class, notificationId, User.class, Set.of(), false).filter(deviceUsers::contains).collect(Collectors.toUnmodifiableSet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Notification> getDeviceNotifications(long deviceId) {
        try {
            this.lock.readLock().lock();
            Set direct = this.graph.getObjects(Device.class, deviceId, Notification.class, Set.of(Group.class), true).map(BaseModel::getId).collect(Collectors.toUnmodifiableSet());
            Set<Notification> set = this.graph.getObjects(Device.class, deviceId, Notification.class, Set.of(Group.class, User.class), true).filter(notification -> notification.getAlways() || direct.contains(notification.getId())).collect(Collectors.toUnmodifiableSet());
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(long deviceId) throws Exception {
        try {
            this.lock.writeLock().lock();
            if (this.deviceReferences.computeIfAbsent(deviceId, k -> new AtomicInteger()).getAndIncrement() <= 0) {
                Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", deviceId)));
                this.graph.addObject(device);
                this.initializeCache(device);
                if (device.getPositionId() > 0L) {
                    this.devicePositions.put(deviceId, this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getPositionId()))));
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeDevice(long deviceId) {
        try {
            this.lock.writeLock().lock();
            if (this.deviceReferences.computeIfAbsent(deviceId, k -> new AtomicInteger()).incrementAndGet() <= 0) {
                this.graph.removeObject(Device.class, deviceId);
                this.devicePositions.remove(deviceId);
                this.deviceReferences.remove(deviceId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updatePosition(Position position) {
        try {
            this.lock.writeLock().lock();
            if (this.deviceReferences.containsKey(position.getDeviceId())) {
                this.devicePositions.put(position.getDeviceId(), position);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public <T extends BaseModel> void invalidateObject(boolean local, Class<T> clazz, long id, ObjectOperation operation) throws Exception {
        long afterCalendarId;
        long beforeCalendarId;
        if (local) {
            this.broadcastService.invalidateObject(true, clazz, id, operation);
        }
        if (operation == ObjectOperation.DELETE) {
            this.graph.removeObject(clazz, id);
        }
        if (operation != ObjectOperation.UPDATE) {
            return;
        }
        if (clazz.equals(Server.class)) {
            this.server = this.storage.getObject(Server.class, new Request(new Columns.All()));
            return;
        }
        BaseModel after = (BaseModel)this.storage.getObject(clazz, new Request((Columns)new Columns.All(), new Condition.Equals("id", id)));
        if (after == null) {
            return;
        }
        Object before = this.getObject(after.getClass(), after.getId());
        if (before == null) {
            return;
        }
        if (after instanceof GroupedModel) {
            long afterGroupId;
            long beforeGroupId = ((GroupedModel)before).getGroupId();
            if (beforeGroupId != (afterGroupId = ((GroupedModel)after).getGroupId())) {
                if (beforeGroupId > 0L) {
                    this.invalidatePermission(clazz, id, Group.class, beforeGroupId, false);
                }
                if (afterGroupId > 0L) {
                    this.invalidatePermission(clazz, id, Group.class, afterGroupId, true);
                }
            }
        } else if (after instanceof Schedulable && (beforeCalendarId = ((Schedulable)before).getCalendarId()) != (afterCalendarId = ((Schedulable)((Object)after)).getCalendarId())) {
            if (beforeCalendarId > 0L) {
                this.invalidatePermission(clazz, id, Calendar.class, beforeCalendarId, false);
            }
            if (afterCalendarId > 0L) {
                this.invalidatePermission(clazz, id, Calendar.class, afterCalendarId, true);
            }
        }
        this.graph.updateObject(after);
    }

    @Override
    public <T1 extends BaseModel, T2 extends BaseModel> void invalidatePermission(boolean local, Class<T1> clazz1, long id1, Class<T2> clazz2, long id2, boolean link) throws Exception {
        if (local) {
            this.broadcastService.invalidatePermission(true, clazz1, id1, clazz2, id2, link);
        }
        if (clazz1.equals(User.class) && GroupedModel.class.isAssignableFrom(clazz2)) {
            this.invalidatePermission(clazz2, id2, clazz1, id1, link);
        } else {
            this.invalidatePermission(clazz1, id1, clazz2, id2, link);
        }
    }

    private <T1 extends BaseModel, T2 extends BaseModel> void invalidatePermission(Class<T1> fromClass, long fromId, Class<T2> toClass, long toId, boolean link) throws Exception {
        boolean groupedLinks;
        boolean groupLink = GroupedModel.class.isAssignableFrom(fromClass) && toClass.equals(Group.class);
        boolean calendarLink = Schedulable.class.isAssignableFrom(fromClass) && toClass.equals(Calendar.class);
        boolean userLink = fromClass.equals(User.class) && toClass.equals(Notification.class);
        boolean bl = groupedLinks = GroupedModel.class.isAssignableFrom(fromClass) && (GROUPED_CLASSES.contains(toClass) || toClass.equals(User.class));
        if (!(groupLink || calendarLink || userLink || groupedLinks)) {
            return;
        }
        if (link) {
            BaseModel object = (BaseModel)this.storage.getObject(toClass, new Request((Columns)new Columns.All(), new Condition.Equals("id", toId)));
            if (!this.graph.addLink(fromClass, fromId, object)) {
                this.initializeCache(object);
            }
        } else {
            this.graph.removeLink(fromClass, fromId, toClass, toId);
        }
    }

    private void initializeCache(BaseModel object) throws Exception {
        if (object instanceof User) {
            for (Permission permission : this.storage.getPermissions(User.class, Notification.class)) {
                if (permission.getOwnerId() != object.getId()) continue;
                this.invalidatePermission(permission.getOwnerClass(), permission.getOwnerId(), permission.getPropertyClass(), permission.getPropertyId(), true);
            }
        } else {
            long calendarId;
            if (object instanceof GroupedModel) {
                long groupId = ((GroupedModel)object).getGroupId();
                if (groupId > 0L) {
                    this.invalidatePermission(object.getClass(), object.getId(), Group.class, groupId, true);
                }
                for (Permission permission : this.storage.getPermissions(User.class, object.getClass())) {
                    if (permission.getPropertyId() != object.getId()) continue;
                    this.invalidatePermission(object.getClass(), object.getId(), User.class, permission.getOwnerId(), true);
                }
                for (Class clazz : GROUPED_CLASSES) {
                    for (Permission permission : this.storage.getPermissions(object.getClass(), clazz)) {
                        if (permission.getOwnerId() != object.getId()) continue;
                        this.invalidatePermission(object.getClass(), object.getId(), clazz, permission.getPropertyId(), true);
                    }
                }
            }
            if (object instanceof Schedulable && (calendarId = ((Schedulable)((Object)object)).getCalendarId()) > 0L) {
                this.invalidatePermission(object.getClass(), object.getId(), Calendar.class, calendarId, true);
            }
        }
    }
}

