/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import nu.validator.htmlparser.common.ByteReadable;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.extra.ChardetSniffer;
import nu.validator.htmlparser.extra.IcuDetectorSniffer;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.io.BomSniffer;
import nu.validator.htmlparser.io.Confidence;
import nu.validator.htmlparser.io.Driver;
import nu.validator.htmlparser.io.Encoding;
import nu.validator.htmlparser.io.MetaSniffer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public final class HtmlInputStreamReader
extends Reader
implements ByteReadable,
Locator,
Locator2 {
    private static final int SNIFFING_LIMIT = 1024;
    private final InputStream inputStream;
    private final ErrorHandler errorHandler;
    private final Tokenizer tokenizer;
    private final Driver driver;
    private CharsetDecoder decoder = null;
    private boolean sniffing = true;
    private int limit = 0;
    private int position = 0;
    private int bytesRead = 0;
    private boolean eofSeen = false;
    private boolean shouldReadBytes = false;
    private boolean charsetBoundaryPassed = false;
    private final byte[] byteArray = new byte[4096];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);
    private boolean needToNotifyTokenizer = false;
    private boolean flushing = false;
    private int line = -1;
    private int col = -1;
    private int lineColPos;
    private boolean hasPendingReplacementCharacter = false;
    private boolean nextCharOnNewLine;
    private boolean prevWasCR;

    public HtmlInputStreamReader(InputStream inputStream, ErrorHandler errorHandler, Tokenizer tokenizer, Driver driver, Heuristics heuristics) throws SAXException, IOException {
        this.inputStream = inputStream;
        this.errorHandler = errorHandler;
        this.tokenizer = tokenizer;
        this.driver = driver;
        this.sniffing = true;
        Encoding encoding = new BomSniffer(this).sniff();
        if (encoding == null) {
            this.position = 0;
            encoding = new MetaSniffer(errorHandler, this).sniff(this);
            boolean declared = true;
            if (encoding == null) {
                declared = false;
            } else if (encoding != Encoding.UTF8) {
                this.err("Legacy encoding \u201c" + encoding.getCanonName() + "\u201d used. Documents must use UTF-8.");
            }
            if (encoding == null && (heuristics == Heuristics.CHARDET || heuristics == Heuristics.ALL)) {
                encoding = new ChardetSniffer(this.byteArray, this.limit).sniff();
            }
            if (encoding == null && (heuristics == Heuristics.ICU || heuristics == Heuristics.ALL)) {
                this.position = 0;
                encoding = new IcuDetectorSniffer(this).sniff();
            }
            this.sniffing = false;
            if (encoding == null) {
                encoding = Encoding.WINDOWS1252;
            }
            if (!declared) {
                this.err("The character encoding was not declared. Proceeding using \u201c" + encoding.getCanonName() + "\u201d.");
            }
            if (driver != null) {
                driver.setEncoding(encoding, Confidence.TENTATIVE);
            }
        } else if (encoding == Encoding.UTF8) {
            if (driver != null) {
                driver.setEncoding(Encoding.UTF8, Confidence.CERTAIN);
            }
        } else {
            this.err("Legacy encoding \u201c" + encoding.getCanonName() + "\u201d used. Documents must use UTF-8.");
            if (driver != null) {
                driver.setEncoding(Encoding.UTF16, Confidence.CERTAIN);
            }
        }
        this.decoder = encoding.newDecoder();
        this.sniffing = false;
        this.position = 0;
        this.bytesRead = 0;
        this.byteBuffer.position(this.position);
        this.byteBuffer.limit(this.limit);
        this.initDecoder();
    }

    private void initDecoder() {
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public HtmlInputStreamReader(InputStream inputStream, ErrorHandler errorHandler, Tokenizer tokenizer, Driver driver, Encoding encoding) throws SAXException, IOException {
        this.inputStream = inputStream;
        this.errorHandler = errorHandler;
        this.tokenizer = tokenizer;
        this.driver = driver;
        this.decoder = encoding.newDecoder();
        this.sniffing = false;
        this.position = 0;
        this.bytesRead = 0;
        this.byteBuffer.position(0);
        this.byteBuffer.limit(0);
        this.shouldReadBytes = true;
        this.initDecoder();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int read(char[] charArray) throws IOException {
        int cPos;
        this.lineColPos = 0;
        assert (!this.sniffing);
        assert (charArray.length >= 2);
        if (this.needToNotifyTokenizer) {
            if (this.driver != null) {
                this.driver.notifyAboutMetaBoundary();
            }
            this.needToNotifyTokenizer = false;
        }
        CharBuffer charBuffer = CharBuffer.wrap(charArray);
        charBuffer.limit(charArray.length);
        charBuffer.position(0);
        if (this.flushing) {
            this.decoder.flush(charBuffer);
            int cPos2 = charBuffer.position();
            return cPos2 == 0 ? -1 : cPos2;
        }
        if (this.hasPendingReplacementCharacter) {
            charBuffer.put('\ufffd');
            this.hasPendingReplacementCharacter = false;
        }
        block0: while (true) {
            if (this.shouldReadBytes) {
                int readLen;
                int oldLimit = this.byteBuffer.limit();
                int num = this.inputStream.read(this.byteArray, oldLimit, readLen = this.charsetBoundaryPassed ? this.byteArray.length - oldLimit : 1024 - oldLimit);
                if (num == -1) {
                    this.eofSeen = true;
                    this.inputStream.close();
                } else {
                    this.byteBuffer.position(0);
                    this.byteBuffer.limit(oldLimit + num);
                }
                this.shouldReadBytes = false;
            }
            boolean finalDecode = false;
            while (true) {
                int oldBytePos = this.byteBuffer.position();
                CoderResult cr = this.decoder.decode(this.byteBuffer, charBuffer, finalDecode);
                this.bytesRead += this.byteBuffer.position() - oldBytePos;
                if (cr == CoderResult.OVERFLOW) {
                    return charBuffer.position();
                }
                if (cr == CoderResult.UNDERFLOW) {
                    int remaining = this.byteBuffer.remaining();
                    if (!this.charsetBoundaryPassed && this.bytesRead + remaining >= 1024) {
                        this.needToNotifyTokenizer = true;
                        this.charsetBoundaryPassed = true;
                    }
                    if (remaining > 0) {
                        System.arraycopy(this.byteArray, this.byteBuffer.position(), this.byteArray, 0, remaining);
                    }
                    this.byteBuffer.position(0);
                    this.byteBuffer.limit(remaining);
                    if (this.flushing) {
                        cPos = charBuffer.position();
                        return cPos == 0 ? -1 : cPos;
                    }
                    if (this.eofSeen) {
                        this.shouldReadBytes = false;
                        finalDecode = true;
                        this.flushing = true;
                        continue;
                    }
                    this.shouldReadBytes = true;
                    cPos = charBuffer.position();
                    if (cPos == 0) continue block0;
                    return cPos;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < cr.length(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append('\u201c');
                    sb.append(Integer.toHexString(this.byteBuffer.get() & 0xFF));
                    ++this.bytesRead;
                    sb.append('\u201d');
                }
                if (charBuffer.hasRemaining()) {
                    charBuffer.put('\ufffd');
                } else {
                    this.hasPendingReplacementCharacter = true;
                }
                this.calculateLineAndCol(charBuffer);
                if (cr.isMalformed()) {
                    this.err("Malformed byte sequence: " + sb + ".");
                } else if (cr.isUnmappable()) {
                    this.err("Unmappable byte sequence: " + sb + ".");
                } else {
                    throw new RuntimeException("CoderResult was none of overflow, underflow, malformed or unmappable.");
                }
                if (finalDecode) break block0;
            }
            break;
        }
        cPos = charBuffer.position();
        return cPos == 0 ? -1 : cPos;
    }

    private void calculateLineAndCol(CharBuffer charBuffer) {
        if (this.tokenizer != null) {
            int i;
            if (this.lineColPos == 0) {
                this.line = this.tokenizer.getLine();
                this.col = this.tokenizer.getCol();
                this.nextCharOnNewLine = this.tokenizer.isNextCharOnNewLine();
                this.prevWasCR = this.tokenizer.isPrevCR();
            }
            char[] charArray = charBuffer.array();
            block4: for (i = this.lineColPos; i < charBuffer.position(); ++i) {
                if (this.nextCharOnNewLine) {
                    ++this.line;
                    this.col = 1;
                    this.nextCharOnNewLine = false;
                } else {
                    ++this.col;
                }
                char c = charArray[i];
                switch (c) {
                    case '\r': {
                        this.nextCharOnNewLine = true;
                        this.prevWasCR = true;
                        continue block4;
                    }
                    case '\n': {
                        if (this.prevWasCR) {
                            --this.col;
                            continue block4;
                        }
                        this.nextCharOnNewLine = true;
                    }
                }
            }
            this.lineColPos = i;
        }
    }

    @Override
    public int readByte() throws IOException {
        if (!this.sniffing) {
            throw new IllegalStateException("readByte() called when not in the sniffing state.");
        }
        if (this.position == 1024) {
            return -1;
        }
        if (this.position < this.limit) {
            return this.byteArray[this.position++] & 0xFF;
        }
        int num = this.inputStream.read(this.byteArray, this.limit, 1024 - this.limit);
        if (num == -1) {
            return -1;
        }
        this.limit += num;
        return this.byteArray[this.position++] & 0xFF;
    }

    public static void main(String[] args) {
        CharsetDecoder dec = Charset.forName("UTF-8").newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPORT);
        dec.onUnmappableCharacter(CodingErrorAction.REPORT);
        byte[] bytes = new byte[]{-16, -99, -128, -128};
        byte[] bytes2 = new byte[]{-72, -128, 99, 100, 101};
        ByteBuffer byteBuf = ByteBuffer.wrap(bytes);
        ByteBuffer byteBuf2 = ByteBuffer.wrap(bytes2);
        char[] chars = new char[1];
        CharBuffer charBuf = CharBuffer.wrap(chars);
        CoderResult cr = dec.decode(byteBuf, charBuf, false);
        System.out.println(cr);
        System.out.println(byteBuf);
        cr = dec.decode(byteBuf2, charBuf, false);
        System.out.println(cr);
        System.out.println(byteBuf2);
    }

    @Override
    public int getColumnNumber() {
        if (this.tokenizer != null) {
            return this.col;
        }
        return -1;
    }

    @Override
    public int getLineNumber() {
        if (this.tokenizer != null) {
            return this.line;
        }
        return -1;
    }

    @Override
    public String getPublicId() {
        if (this.tokenizer != null) {
            return this.tokenizer.getPublicId();
        }
        return null;
    }

    @Override
    public String getSystemId() {
        if (this.tokenizer != null) {
            return this.tokenizer.getSystemId();
        }
        return null;
    }

    @Override
    public String getXMLVersion() {
        if (this.tokenizer != null) {
            return this.tokenizer.getXMLVersion();
        }
        return null;
    }

    @Override
    public String getEncoding() {
        if (this.tokenizer != null) {
            return this.tokenizer.getEncoding();
        }
        return null;
    }

    private void err(String message) throws IOException {
        try {
            if (this.errorHandler != null) {
                SAXParseException spe = new SAXParseException(message, this);
                this.errorHandler.error(spe);
            }
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private void warn(String message) throws IOException {
        try {
            if (this.errorHandler != null) {
                SAXParseException spe = new SAXParseException(message, this);
                this.errorHandler.warning(spe);
            }
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public Charset getCharset() {
        return this.decoder.charset();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void switchEncoding(Encoding newEnc) {
        this.decoder = newEnc.newDecoder();
        this.initDecoder();
    }
}

