/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.HistoryReferenceEventPublisher;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchResult;
import org.zaproxy.zap.utils.StringUIUtils;
import org.zaproxy.zap.view.table.AbstractCustomColumnHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class SearchResultsTableModel
extends AbstractCustomColumnHistoryReferencesTableModel<SearchResultTableEntry>
implements EventConsumer {
    private static final long serialVersionUID = 5732679524771190690L;
    private static final String MATCH_COLUMN_NAME = Constant.messages.getString("search.results.table.header.match");
    private static final HistoryReferencesTableModel.Column[] COLUMNS = new HistoryReferencesTableModel.Column[]{HistoryReferencesTableModel.Column.HREF_ID, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP, HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP, HistoryReferencesTableModel.Column.METHOD, HistoryReferencesTableModel.Column.URL, HistoryReferencesTableModel.Column.STATUS_CODE, HistoryReferencesTableModel.Column.STATUS_REASON, HistoryReferencesTableModel.Column.RTT, HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER, HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY, HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY, HistoryReferencesTableModel.Column.HIGHEST_ALERT, HistoryReferencesTableModel.Column.NOTE, HistoryReferencesTableModel.Column.TAGS, HistoryReferencesTableModel.Column.CUSTOM};
    private List<SearchResultTableEntry> results = new ArrayList<SearchResultTableEntry>();

    public SearchResultsTableModel() {
        super(COLUMNS);
        ZAP.getEventBus().registerConsumer(this, HistoryReferenceEventPublisher.getPublisher().getPublisherName(), "href.removed", "href.tag.added", "href.tag.removed", "href.tags.set");
    }

    public void addSearchResult(SearchResult sr) {
        SearchResultTableEntry previousResult = null;
        if (this.results.size() > 1) {
            previousResult = this.results.get(this.results.size() - 1);
        }
        this.results.add(SearchResultsTableModel.createSearchResultTableEntry(sr, previousResult));
        this.fireTableRowsInserted(this.results.size() - 1, this.results.size() - 1);
    }

    private static SearchResultTableEntry createSearchResultTableEntry(SearchResult sr, SearchResultTableEntry previousResult) {
        HistoryReference hRef = sr.getMessage().getHistoryRef();
        String stringFound = null;
        if (previousResult != null && previousResult.getStringFound().equals(sr.getStringFound())) {
            stringFound = previousResult.getStringFound();
        }
        if (stringFound == null) {
            stringFound = sr.getStringFound();
        }
        return new SearchResultTableEntry(hRef, stringFound, sr);
    }

    @Override
    public void addEntry(SearchResultTableEntry entry) {
    }

    @Override
    public void refreshEntryRow(int historyReferenceId) {
    }

    @Override
    public void removeEntry(int historyReferenceId) {
        if (this.results.removeIf(r -> r.getHistoryId() == historyReferenceId)) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public SearchResultTableEntry getEntry(int rowIndex) {
        return this.results.get(rowIndex);
    }

    @Override
    public SearchResultTableEntry getEntryWithHistoryId(int historyReferenceId) {
        return null;
    }

    @Override
    public int getEntryRowIndex(int historyReferenceId) {
        return -1;
    }

    @Override
    public void clear() {
        this.results = new ArrayList<SearchResultTableEntry>();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    protected Class<?> getColumnClass(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getColumnClass(column);
    }

    @Override
    protected Object getPrototypeValue(HistoryReferencesTableModel.Column column) {
        return AbstractHistoryReferencesTableEntry.getPrototypeValue(column);
    }

    @Override
    protected Object getCustomValueAt(SearchResultTableEntry entry, int columnIndex) {
        return entry.getStringFound();
    }

    @Override
    protected String getCustomColumnName(int columnIndex) {
        return MATCH_COLUMN_NAME;
    }

    @Override
    protected Class<String> getCustomColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    protected Object getCustomPrototypeValue(int columnIndex) {
        return "A match with some long text";
    }

    @Override
    public void eventReceived(Event event) {
        String idStr = event.getParameters().get("historyReferenceId");
        int historyId = Integer.parseInt(idStr);
        switch (event.getEventType()) {
            case "href.removed": {
                this.removeEntry(historyId);
                break;
            }
            case "href.tag.added": 
            case "href.tag.removed": 
            case "href.tags.set": {
                boolean rowsUpdated = false;
                for (int i = 0; i < this.results.size(); ++i) {
                    SearchResultTableEntry entry = this.results.get(i);
                    if (entry.getHistoryId() != historyId) continue;
                    entry.refreshCachedValues();
                    rowsUpdated = true;
                }
                if (!rowsUpdated) break;
                this.fireTableRowsUpdated(0, this.results.size() - 1);
            }
        }
    }

    public static class SearchResultTableEntry
    extends DefaultHistoryReferencesTableEntry {
        private static final int MAX_CHARS_FOUND_STRING = 150;
        private final String stringFound;
        private final SearchResult sr;

        public SearchResultTableEntry(HistoryReference historyReference, String stringFound, SearchResult sr) {
            super(historyReference, COLUMNS);
            String temp = stringFound.length() > 150 ? stringFound.substring(0, 150) + "..." : stringFound;
            this.stringFound = StringUIUtils.replaceWithVisibleWhiteSpaceChars(temp);
            this.sr = new HistoryReferenceSearchResult(sr, stringFound);
        }

        public String getStringFound() {
            return this.stringFound;
        }

        public SearchResult getSearchResult() {
            return this.sr;
        }

        private class CachedSearchMatch
        extends SearchMatch {
            public CachedSearchMatch(SearchMatch searchMatch) {
                super(null, searchMatch.getLocation(), searchMatch.getStart(), searchMatch.getEnd());
            }

            @Override
            public HttpMessage getMessage() {
                try {
                    return SearchResultTableEntry.this.getHistoryReference().getHttpMessage();
                }
                catch (DatabaseException | HttpMalformedHeaderException e) {
                    return null;
                }
            }
        }

        private class HistoryReferenceSearchResult
        extends SearchResult {
            private List<CachedSearchMatch> matches;
            private CachedSearchMatch lastMatch;

            public HistoryReferenceSearchResult(SearchResult sr, String stringFound) {
                super(null, sr.getType(), sr.getRegEx(), stringFound);
                this.lastMatch = null;
                this.matches = new ArrayList<CachedSearchMatch>(1);
                this.matches.add(new CachedSearchMatch(sr.getFirstMatch(null, null)));
            }

            @Override
            public HttpMessage getMessage() {
                try {
                    return SearchResultTableEntry.this.getHistoryReference().getHttpMessage();
                }
                catch (DatabaseException | HttpMalformedHeaderException e) {
                    return null;
                }
            }

            @Override
            public SearchMatch getFirstMatch(HttpPanel reqPanel, HttpPanel resPanel) {
                if (this.matches.size() > 0) {
                    this.lastMatch = this.matches.get(0);
                    return this.lastMatch;
                }
                return null;
            }

            @Override
            public SearchMatch getLastMatch(HttpPanel reqPanel, HttpPanel resPanel) {
                if (this.matches.size() > 0) {
                    this.lastMatch = this.matches.get(this.matches.size() - 1);
                    return this.lastMatch;
                }
                return null;
            }

            @Override
            public SearchMatch getNextMatch() {
                int i;
                if (this.lastMatch != null && (i = this.matches.indexOf(this.lastMatch)) >= 0 && i < this.matches.size() - 1) {
                    this.lastMatch = this.matches.get(i + 1);
                    return this.lastMatch;
                }
                return null;
            }

            @Override
            public SearchMatch getPrevMatch() {
                int i;
                if (this.lastMatch != null && (i = this.matches.indexOf(this.lastMatch)) >= 1) {
                    this.lastMatch = this.matches.get(i - 1);
                    return this.lastMatch;
                }
                return null;
            }
        }
    }
}

