#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for eos_ospfv3
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

DOCUMENTATION = """
module: eos_ospfv3
short_description: OSPFv3 resource module
description: This module configures and manages the attributes of ospfv3 on Arista
  EOS platforms.
version_added: 1.1.0
author: Gomathi Selvi Srinivasan (@GomathiselviS)
notes:
- Tested against Arista EOS 4.24.6F
- This module works with connection C(network_cli). See the L(EOS Platform Options,../network/user_guide/platform_eos.html).
options:
  config:
    description: A list of configurations for ospfv3.
    type: dict
    suboptions:
      processes:
        description: A list of dictionary specifying the ospfv3 processes.
        type: list
        elements: dict
        suboptions:
          vrf:
            description: VRF name .
            type: str
          adjacency:
            description: Configure adjacency options for OSPF instance.
            type: dict
            suboptions:
              exchange_start:
                description: Configure exchange-start options for OSPF instance.
                type: dict
                suboptions:
                  threshold:
                    description: Number of peers to bring up simultaneously.
                    type: int
          auto_cost:
            description: Set auto-cost.
            type: dict
            suboptions:
              reference_bandwidth:
                description: reference bandwidth in megabits per sec.
                type: int
          areas:
              description: Specifies the configuration for OSPF areas
              type: list
              elements: dict
              suboptions:
                area_id:
                  description: Specifies a 32 bit number expressed in decimal or dotted-decimal
                               notation.
                  type: str
                default_cost:
                  description: Specify the cost for default summary route in stub/NSSA
                    area.
                  type: int
                authentication:
                  description: Configure authentication for the area incase of ospfv3.
                  type: dict
                  suboptions:
                    spi:
                      description: Specify the SPI value
                      type: int
                    algorithm:
                      description: Name of algorithm to be used.
                      type: str
                      choices: ['md5', 'sha1']
                    encrypt_key:
                      description: If false, key string is not encrypted
                      type: bool
                    hidden_key:
                      description: If true, Specifies that a HIDDEN key will follow.
                      type: bool
                    key:
                      description: 128 bit MD5 key or 140 bit SHA1 key.
                      type: str
                    passphrase:
                      description: Passphrase String for deriving keys for authentication and encryption.
                      type: str
                encryption:
                  description: Configure encryption for the area
                  type: dict
                  suboptions:
                    spi:
                      description: Specify the SPI value
                      type: int
                    encryption:
                      description: name of encryption to be used.
                      type: str
                      choices: ['3des-cbc', 'aes-128-cbc', 'aes-192-cbc', 'aes-256-cbc', 'null']
                    algorithm:
                      description: name of the algorithm to be used.
                      type: str
                      choices: ['sha1', 'md5']
                    encrypt_key:
                      description: If false, key string is not encrypted
                      type: bool
                    hidden_key:
                      description: If true, Specifies that a HIDDEN key will follow.
                      type: bool
                    key:
                      description: 128 bit MD5 key or 140 bit SHA1 key.
                      type: str
                    passphrase:
                      description: Passphrase String for deriving keys for authentication and encryption.
                      type: str
                nssa:
                    description: Configures NSSA parameters.
                    type: dict
                    suboptions:
                      default_information_originate:
                        description: Originate default Type 7 LSA.
                        type: dict
                        suboptions:
                          metric:
                            description: Metric for default route.
                            type: int
                          metric_type:
                            description: Metric type for default route.
                            type: int
                          nssa_only:
                            description: Limit default advertisement to this NSSA area.
                            type: bool
                          set:
                            description: true if only default information orignate is set
                            type: bool
                      no_summary:
                        description: Filter all type-3 LSAs in the nssa area.
                        type: bool
                      nssa_only:
                        description: Disable Type-7 LSA p-bit setting
                        type: bool
                      translate:
                        description: Enable LSA translation.
                        type: bool
                      set:
                        description: true if only nssa is set
                        type: bool
                stub:
                  description: Stub area.
                  type: dict
                  suboptions:
                    set:
                      description: true if only stub is set.
                      type: bool
                    summary_lsa:
                      description: If false , Filter all type-3 LSAs in the stub area.
                      type: bool

          bfd:
            description: Enable BFD.
            type: dict
            suboptions:
              all_interfaces:
                description: Enable BFD on all interfaces.
                type: bool
          fips_restrictions:
              description: Use FIPS compliant algorithms
              type: bool
          graceful_restart:
            description: Enable graceful restart mode.
            type: dict
            suboptions:
              grace_period:
                description: Specify maximum time to wait for graceful-restart to
                  complete.
                type: int
              set:
                  description: When true sets the grace_fulrestart config alone.
                  type: bool
          graceful_restart_helper:
            description: If true, Enable graceful restart helper.
            type: bool
          log_adjacency_changes:
            description: To configure link-state changes and transitions of OSPFv3
              neighbors.
            type: dict
            suboptions:
                detail:
                  description: If true , configures the switch to log all link-state
                    changes.
                  type: bool
                set:
                  description: When true sets the log_adjacency_changes config alone.
                  type: bool
          max_metric:
            description: Set maximum metric.
            type: dict
            suboptions:
              router_lsa:
                description: Maximum metric in self-originated router-LSAs.
                type: dict
                suboptions:
                  set:
                    description:
                    - Set router-lsa attribute.
                    type: bool
                  external_lsa:
                    description: Override external-lsa metric with max-metric value.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set external-lsa attribute.
                        type: bool
                      max_metric_value:
                        description:
                        - Set max metric value for external LSAs.
                        type: int
                  include_stub:
                    description: Set maximum metric for stub links in router-LSAs.
                    type: bool
                  on_startup:
                    description: Set maximum metric temporarily after reboot.
                    type: dict
                    suboptions:
                      wait_period:
                        description:
                        - Wait period in seconds after startup.
                        type: int
                      wait_for_bgp:
                        description:
                        - Let BGP decide when to originate router-LSA with normal metric
                        type: bool
                  summary_lsa:
                    description: Override summary-lsa metric with max-metric value.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set external-lsa attribute.
                        type: bool
                      max_metric_value:
                        description:
                        - Set max metric value for external LSAs.
                        type: int
          passive_interface:
            description: Include interface but without actively running OSPF.
            type: bool
          router_id:
            description: 32-bit number assigned to a router running OSPFv3.
            type: str
          shutdown:
            description: Disable the OSPF instance.
            type: bool
          timers:
            description: Configure OSPF timers.
            type: dict
            suboptions:
              out_delay:
                description: Configure out-delay timer.
                type: int
              pacing:
                description: Configure OSPF packet pacing.
                type: int
              throttle:
                description: This command is deprecated by 'timers lsa' or 'timers spf'.
                type: dict
                suboptions:
                  initial:
                    description: Initial SPF schedule delay in msecs.
                    type: int
                  min:
                    description: Min Hold time between two SPFs in msecs
                    type: int
                  max:
                    description: Max wait time between two SPFs in msecs.
                    type: int
                  lsa:
                    description: Configure threshold for retransmission of lsa
                    type: bool
                  spf:
                    description: Configure time between SPF calculations
                    type: bool
              spf:
                description: Configure OSPFv3 spf timers.
                type: dict
                suboptions:
                  initial:
                    description: Initial SPF schedule delay in msecs.
                    type: int
                  min:
                    description: Min Hold time between two SPFs in msecs
                    type: int
                  max:
                    description: Max wait time between two SPFs in msecs.
                    type: int
              lsa:
                description: Configure OSPFv3 LSA timers.
                type: raw
                suboptions:
                  direction:
                    description: Configure OSPFv3 LSA receiving/transmission timers.
                    type: str
                    choices: ["rx", "tx"]
                  initial:
                    description: Initial SPF schedule delay in msecs.
                    type: int
                  min:
                    description: Min Hold time between two SPFs in msecs
                    type: int
                  max:
                    description: Max wait time between two SPFs in msecs.
                    type: int
          address_family:
            description: Enable address family and enter its config mode
            type: list
            elements: dict
            suboptions:
              afi:
                description: address family .
                type: str
                choices:
                - ipv4
                - ipv6
              adjacency:
                description: Configure adjacency options for OSPF instance.
                type: dict
                suboptions:
                  exchange_start:
                    description: Configure exchange-start options for OSPF instance.
                    type: dict
                    suboptions:
                      threshold:
                        description: Number of peers to bring up simultaneously.
                        type: int
              auto_cost:
                description: Set auto-cost.
                type: dict
                suboptions:
                  reference_bandwidth:
                    description: reference bandwidth in megabits per sec.
                    type: int
              areas:
                description: Specifies the configuration for OSPF areas
                type: list
                elements: dict
                suboptions:
                  area_id:
                    description: Specifies a 32 bit number expressed in decimal or dotted-decimal
                                 notation.
                    type: str
                  default_cost:
                    description: Specify the cost for default summary route in stub/NSSA
                      area.
                    type: int
                  authentication:
                    description: Configure authentication for the area incase of ospfv3.
                    type: dict
                    suboptions:
                      spi:
                        description: Specify the SPI value
                        type: int
                      algorithm:
                        description: Name of algorithm to be used.
                        type: str
                        choices: ['md5', 'sha1']
                      encrypt_key:
                        description: If false, key string is not encrypted
                        type: bool
                      hidden_key:
                        description: If true, Specifies that a HIDDEN key will follow.
                        type: bool
                      key:
                        description: 128 bit MD5 key or 140 bit SHA1 key.
                        type: str
                      passphrase:
                        description: Passphrase String for deriving keys for authentication and encryption.
                        type: str
                  encryption:
                    description: Configure encryption for the area
                    type: dict
                    suboptions:
                      spi:
                        description: Specify the SPI value
                        type: int
                      encryption:
                        description: name of encryption to be used.
                        type: str
                        choices: ['3des-cbc', 'aes-128-cbc', 'aes-192-cbc', 'aes-256-cbc', 'null']
                      algorithm:
                        description: name of the algorithm to be used.
                        type: str
                        choices: ['sha1', 'md5']
                      encrypt_key:
                        description: If false, key string is not encrypted
                        type: bool
                      hidden_key:
                        description: If true, Specifies that a HIDDEN key will follow.
                        type: bool
                      key:
                        description: 128 bit MD5 key or 140 bit SHA1 key.
                        type: str
                      passphrase:
                        description: Passphrase String for deriving keys for authentication and encryption.
                        type: str
                  nssa:
                      description: Configures NSSA parameters.
                      type: dict
                      suboptions:
                        default_information_originate:
                          description: Originate default Type 7 LSA.
                          type: dict
                          suboptions:
                            metric:
                              description: Metric for default route.
                              type: int
                            metric_type:
                              description: Metric type for default route.
                              type: int
                            nssa_only:
                              description: Limit default advertisement to this NSSA area.
                              type: bool
                            set:
                              description: true if only default information orignate is set
                              type: bool
                        no_summary:
                          description: Filter all type-3 LSAs in the nssa area.
                          type: bool
                        nssa_only:
                          description: Disable Type-7 LSA p-bit setting
                          type: bool
                        translate:
                          description: Enable LSA translation.
                          type: bool
                        set:
                          description: true if only nssa is set
                          type: bool
                  ranges:
                    description: Configure route summarization.
                    type: list
                    elements: dict
                    suboptions:
                      address:
                        description: IP address.
                        type: str
                      subnet_address:
                        description: IP address with mask length
                        type: str
                      subnet_mask:
                        description: IP subnet mask
                        type: str
                      advertise:
                        description: Enable Advertisement of the range.
                        type: bool
                      cost:
                        description: Configures the metric.
                        type: int
                  stub:
                    description: Stub area.
                    type: dict
                    suboptions:
                      set:
                        description: true if only stub is set
                        type: bool
                      summary_lsa:
                        description: If false , Filter all type-3 LSAs in the stub area.
                        type: bool

              bfd:
                description: Enable BFD.
                type: dict
                suboptions:
                  all_interfaces:
                    description: Enable BFD on all interfaces.
                    type: bool
              default_information:
                description: Control distribution of default information.
                type: dict
                suboptions:
                  originate:
                    description: Distribute a default route.
                    type: bool
                  always:
                    description: Always advertise default route.
                    type: bool
                  metric:
                    description: Metric for default route.
                    type: int
                  metric_type:
                    description: Metric type for default route.
                    type: int
                  route_map:
                    description: Specify which route-map to use.
                    type: str
              default_metric:
                description: Configure the default metric for redistributed routes.
                type: int
              distance:
                description: Specifies the administrative distance for routes.
                type: int
              fips_restrictions:
                description: Use FIPS compliant algorithms
                type: bool
              graceful_restart:
                description: Enable graceful restart mode.
                type: dict
                suboptions:
                  grace_period:
                    description: Specify maximum time to wait for graceful-restart to complete.
                    type: int
                  set:
                    description: When true sets the grace_fulrestart config alone.
                    type: bool
              graceful_restart_helper:
                description: If true, Enable graceful restart helper.
                type: bool
              log_adjacency_changes:
                description: To configure link-state changes and transitions of OSPFv3
                  neighbors.
                type: dict
                suboptions:
                  detail:
                    description: If true , configures the switch to log all link-state
                      changes.
                    type: bool
                  set:
                    description: When true sets the log_adjacency_changes config alone.
                    type: bool
              max_metric:
                description: Set maximum metric.
                type: dict
                suboptions:
                  router_lsa:
                    description: Maximum metric in self-originated router-LSAs.
                    type: dict
                    suboptions:
                      set:
                        description:
                        - Set router-lsa attribute.
                        type: bool
                      external_lsa:
                        description: Override external-lsa metric with max-metric value.
                        type: dict
                        suboptions:
                          set:
                            description:
                            - Set external-lsa attribute.
                            type: bool
                          max_metric_value:
                            description:
                            - Set max metric value for external LSAs.
                            type: int
                      include_stub:
                        description: Set maximum metric for stub links in router-LSAs.
                        type: bool
                      on_startup:
                        description: Set maximum metric temporarily after reboot.
                        type: dict
                        suboptions:
                          wait_period:
                            description:
                            - Wait period in seconds after startup.
                            type: int
                          wait_for_bgp:
                            description:
                            - Let BGP decide when to originate router-LSA with normal metric
                            type: bool
                      summary_lsa:
                        description: Override summary-lsa metric with max-metric value.
                        type: dict
                        suboptions:
                          set:
                            description:
                            - Set external-lsa attribute.
                            type: bool
                          max_metric_value:
                            description:
                            - Set max metric value for external LSAs.
                            type: int
              maximum_paths:
                description: Maximum number of next-hops in an ECMP route.
                type: int
              passive_interface:
               description: Include interface but without actively running OSPF.
               type: bool
              redistribute:
                description: Specifies the routes to be redistributed.
                type: list
                elements: dict
                suboptions:
                  routes:
                    description: Route types (BGP,static,connected)
                    type: str
                    choices: ['bgp', 'connected', 'static']
                  route_map:
                    description: Specify which route map to use.
                    type: str
              router_id:
                description: 32-bit number assigned to a router running OSPFv3.
                type: str
              shutdown:
                description: Disable the OSPF instance.
                type: bool
              timers:
                description: Configure OSPF timers.
                type: dict
                suboptions:
                  throttle:
                    description: This command is deprecated by 'timers lsa' or 'timers spf'.
                    type: dict
                    suboptions:
                      initial:
                        description: Initial SPF schedule delay in msecs.
                        type: int
                      min:
                        description: Min Hold time between two SPFs in msecs
                        type: int
                      max:
                        description: Max wait time between two SPFs in msecs.
                        type: int
                      lsa:
                        description: Configure threshold for retransmission of lsa
                        type: bool
                      spf:
                        description: Configure time between SPF calculations
                        type: bool
                  out_delay:
                    description: Configure out-delay timer.
                    type: int
                  pacing:
                    description: Configure OSPF packet pacing.
                    type: int
                  spf:
                    description: Configure OSPFv3 spf timers.
                    type: dict
                    suboptions:
                      initial:
                        description: Initial SPF schedule delay in msecs.
                        type: int
                      min:
                        description: Min Hold time between two SPFs in msecs
                        type: int
                      max:
                        description: Max wait time between two SPFs in msecs.
                        type: int
                  lsa:
                    description: Configure OSPFv3 LSA timers.
                    type: raw
                    suboptions:
                      direction:
                        description: Configure OSPFv3 LSA receiving/transmission timers.
                        type: str
                        choices: ["rx", "tx"]
                      initial:
                        description: Initial SPF schedule delay in msecs.
                        type: int
                      min:
                        description: Min Hold time between two SPFs in msecs
                        type: int
                      max:
                        description: Max wait time between two SPFs in msecs.
                        type: int
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the EOS device by
      executing the command B(show running-config | section ospfv3).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state the configuration should be left in.
    type: str
    choices: [deleted, merged, overridden, replaced, gathered, rendered, parsed]
    default: merged
"""

EXAMPLES = """

# Using merged

# Before state:
# -------------
# veos#show running-config | section ospfv3
# veos#

- name: Merge the provided configuration with the existing running configuration
  arista.eos.eos_ospfv3:
    config:
      processes:
        - address_family:
            - timers:
                lsa: 22
              graceful_restart:
                grace_period: 35
              afi: "ipv6"
          timers:
            pacing: 55
          fips_restrictions: true
          router_id: "2.2.2.2"
          vrf: "vrfmerge"
    state: merged


# Task output:
# ------------
# before: {}
#
# commands:
# - router ospfv3 vrf vrfmerge
# - address-family ipv6
# - graceful-restart grace-period 35
# - timers lsa arrival 22
# - exit
# - timers pacing flood 55
# - fips restrictions
# - router-id 2.2.2.2
# - exit
#
# after:
#     processes:
#     - address_family:
#       - afi: ipv6
#         fips_restrictions: true
#         graceful_restart:
#           grace_period: 35
#       fips_restrictions: true
#       router_id: 2.2.2.2
#       timers:
#         pacing: 55
#       vrf: vrfmerge

# After state:
# ------------
# veos#show running-config | section ospfv3
# router ospfv3 vrf vrfmerge
#    router-id 2.2.2.2
# test
#    fips restrictions
#    timers pacing flood 55
#    !
#    address-family ipv6
#       fips restrictions
#       timers lsa arrival 22
#       graceful-restart grace-period 35

# using replaced

# Before state:
# -------------
# veos#show running-config | section ospfv3
# router ospfv3
#    fips restrictions
#    area 0.0.0.0 encryption ipsec spi 43 esp null md5 passphrase 7 h8pZp9eprTYjjoY/NKFFe0Ei7x03Y7dyLotRhI0a5t4=
# !
# router ospfv3 vrf vrfmerge
#    router-id 2.2.2.2
#    fips restrictions
#    timers pacing flood 55
#    !
#    address-family ipv6
#       fips restrictions
#       timers lsa arrival 22
#       graceful-restart grace-period 35

- name: Replace a section of running config with provided config
  arista.eos.eos_ospfv3:
    config:
      processes:
        - areas:
            - area_id: "0.0.0.0"
              encryption:
                spi: 43
                encryption: "null"
                algorithm: "md5"
                encrypt_key: false
                passphrase: "7hl8FV3lZ6H1mAKpjL47hQ=="
          vrf: "default"
          address_family:
            - afi: "ipv4"
              router_id: "7.1.1.1"
    state: replaced

# Task output:
# ------------
# before:
#     processes:
#     - areas:
#       - area_id: 0.0.0.0
#         encryption:
#           algorithm: md5
#           encryption: 'null'
#           hidden_key: true
#           passphrase: VALUE_SPECIFIED_IN_NO_LOG_PARAMETER
#           spi: 43
#       fips_restrictions: true
#       vrf: default
#     - address_family:
#       - afi: ipv6
#         fips_restrictions: true
#         graceful_restart:
#           grace_period: 35
#       fips_restrictions: true
#       router_id: 2.2.2.2
#       timers:
#         pacing: 55
#       vrf: vrfmerge
#
# commands:
# - router ospfv3 vrf vrfmerge
# - address-family ipv6
# - no fips restrictions
# - no graceful-restart
# - no timers lsa arrival 22
# - area 0.0.0.3 range 10.1.2.2/24 advertise
# - area 0.0.0.3 range 60.1.1.1 255.255.0.0 cost 30
# - exit
# - passive-interface default
# - no router-id
# - no fips restrictions
# - no timers pacing flood 55
# - exit
#
# after:
#     processes:
#     - areas:
#       - area_id: 0.0.0.0
#         encryption:
#           algorithm: md5
#           encryption: 'null'
#           hidden_key: true
#           passphrase: VALUE_SPECIFIED_IN_NO_LOG_PARAMETER
#           spi: 43
#       vrf: default
#     - address_family:
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#       passive_interface: true
#       vrf: vrfmerge

# After state:
# ------------
# veos#show running-config | section ospfv3
# router ospfv3
#    area 0.0.0.0 encryption ipsec spi 43 esp null md5 passphrase 7 h8pZp9eprTYjjoY/NKFFe0Ei7x03Y7dyLotRhI0a5t4=
# !
# router ospfv3 vrf vrfmerge
#    passive-interface default
#    !
#    address-family ipv6
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30

# using overridden

# Before state:
# -------------
# veos#show running-config | section ospfv3
# router ospfv3
#    area 0.0.0.0 encryption ipsec spi 43 esp null md5 passphrase 7 h8pZp9eprTYjjoY/NKFFe0Ei7x03Y7dyLotRhI0a5t4=
# !
# router ospfv3 vrf vrfmerge
#    passive-interface default
#    !
#    address-family ipv6
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30

- name: Override running config with provided config
  arista.eos.eos_ospfv3:
    config:
      processes:
        - address_family:
            - areas:
                - area_id: "0.0.0.3"
                  ranges:
                    - address: 10.1.2.2/24
                      advertise: true
                    - address: 60.1.1.1
                      subnet_mask: 255.255.0.0
                      cost: 30
              afi: "ipv6"
          passive_interface: true
          vrf: "vrfmerge"
    state: overridden

# Task output:
# ------------
# before:
#     processes:
#     - areas:
#       - area_id: 0.0.0.0
#         encryption:
#           algorithm: md5
#           encryption: 'null'
#           hidden_key: true
#           passphrase: VALUE_SPECIFIED_IN_NO_LOG_PARAMETER
#           spi: 43
#       vrf: default
#     - address_family:
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#       passive_interface: true
#       vrf: vrfmerge
#
# commands:
# - no router ospfv3
# - router ospfv3 vrf vrfmerge
# - address-family ipv6
# - no area 0.0.0.3 range 10.1.2.0/24
# - no area 0.0.0.3 range 60.1.0.0/16 cost 30
# - area 0.0.0.3 range 10.1.2.2/24 advertise
# - area 0.0.0.3 range 60.1.1.1 255.255.0.0 cost 30
# - exit
# - exit
#
# after:
#     processes:
#     - address_family:
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#       passive_interface: true
#       vrf: vrfmerge

# After state:
# ------------
# veos#show running-config | section ospfv3
# router ospfv3 vrf vrfmerge
#    passive-interface default
#    !
#    address-family ipv6
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30

# using deleted

# Before state:
# -------------
# veos#show running-config | section ospfv3
# router ospfv3
#    area 0.0.0.0 encryption ipsec spi 43 esp null md5 passphrase 7 h8pZp9eprTYjjoY/NKFFe0Ei7x03Y7dyLotRhI0a5t4=
# !
# router ospfv3 vrf vrfmerge
#    passive-interface default
#    !
#    address-family ipv4
#       redistribute connected
#       redistribute static route-map MAP01
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30
#    !
#    address-family ipv6
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30

- name: Delete OSPFv3 config
  arista.eos.eos_ospfv3:
    config:
    state: deleted

# Task output:
# ------------

# before:
#     processes:
#     - areas:
#       - area_id: 0.0.0.0
#         encryption:
#           algorithm: md5
#           encryption: 'null'
#           hidden_key: true
#           passphrase: VALUE_SPECIFIED_IN_NO_LOG_PARAMETER
#           spi: 43
#       vrf: default
#     - address_family:
#       - afi: ipv4
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#         redistribute:
#         - routes: connected
#         - route_map: MAP01
#           routes: static
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#       passive_interface: true
#       vrf: vrfmerge
#
# commands:
#
# - no router ospfv3
#
# after: {}

# After state:
# ------------
# veos#show running-config | section ospfv3
# router ospfv3 vrf vrfmerge
#    passive-interface default
#    !
#    address-family ipv4
#       redistribute connected
#       redistribute static route-map MAP01
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30
#    !
#    address-family ipv6
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30

# using parsed

# parsed_ospfv3.cfg
# router ospfv3
#    fips restrictions
#    area 0.0.0.20 stub
#    area 0.0.0.20 authentication ipsec spi 33 sha1 passphrase 7 4O8T3zo4xBdRWXBnsnK934o9SEb+jEhHUN6+xzZgCo2j9EnQBUvtwNxxLEmYmm6w
#    area 0.0.0.40 default-cost 45
#    area 0.0.0.40 stub
#    timers pacing flood 7
#    adjacency exchange-start threshold 11
#    !
#    address-family ipv4
#       fips restrictions
#       redistribute connected
#    !
#    address-family ipv6
#       router-id 10.1.1.1
#       fips restrictions
# !
# router ospfv3 vrf vrf01
#    bfd all-interfaces
#    fips restrictions
#    area 0.0.0.0 encryption ipsec spi 256 esp null sha1 passphrase 7 7hl8FV3lZ6H1mAKpjL47hQ==
#    log-adjacency-changes detail
#    !
#    address-family ipv4
#       passive-interface default
#       fips restrictions
#       redistribute connected route-map MAP01
#       maximum-paths 100
#    !
#    address-family ipv6
#       fips restrictions
#       area 0.0.0.10 nssa no-summary
#       default-information originate route-map DefaultRouteFilter
#       max-metric router-lsa external-lsa 25 summary-lsa
# !
# router ospfv3 vrf vrf02
#    fips restrictions
#    !
#    address-family ipv6
#       router-id 10.17.0.3
#       distance ospf intra-area 200
#       fips restrictions
#       area 0.0.0.1 stub
#       timers spf delay initial 56 56 56
#       timers out-delay 10

- name: Parse the provided config
  arista.eos.eos_ospfv3:
    running_config: "{{ lookup('file', './parsed_ospfv3.cfg') }}"
    state: parsed

# Task output:
# ------------
# parsed:
#     processes:
#     - address_family:
#       - afi: ipv4
#         fips_restrictions: true
#         redistribute:
#         - routes: connected
#       - afi: ipv6
#         fips_restrictions: true
#         router_id: 10.1.1.1
#       adjacency:
#         exchange_start:
#           threshold: 11
#       areas:
#       - area_id: 0.0.0.20
#         authentication:
#           algorithm: sha1
#           hidden_key: true
#           passphrase: VALUE_SPECIFIED_IN_NO_LOG_PARAMETER
#           spi: 33
#         stub:
#           set: true
#       - area_id: 0.0.0.40
#         default_cost: 45
#         stub:
#           set: true
#       fips_restrictions: true
#       timers:
#         pacing: 7
#       vrf: default
#     - address_family:
#       - afi: ipv4
#         fips_restrictions: true
#         maximum_paths: 100
#         passive_interface: true
#         redistribute:
#         - route_map: MAP01
#           routes: connected
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.10
#           nssa:
#             no_summary: true
#         default_information:
#           originate: true
#           route_map: DefaultRouteFilter
#         fips_restrictions: true
#         max_metric:
#           router_lsa:
#             external_lsa:
#               max_metric_value: 25
#             summary_lsa:
#               set: true
#       areas:
#       - area_id: 0.0.0.0
#         encryption:
#           algorithm: sha1
#           encryption: 'null'
#           hidden_key: true
#           passphrase: VALUE_SPECIFIED_IN_NO_LOG_PARAMETER
#           spi: 256
#       bfd:
#         all_interfaces: true
#       fips_restrictions: true
#       log_adjacency_changes:
#         detail: true
#       vrf: vrf01
#     - address_family:
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.1
#           stub:
#             set: true
#         distance: 200
#         fips_restrictions: true
#         router_id: 10.17.0.3
#         timers:
#           out_delay: 10
#           spf:
#             initial: 56
#             max: 56
#             min: 56
#       fips_restrictions: true
#       vrf: vrf02

# using gathered

# native config:
# veos#show running-config | section ospfv3
# router ospfv3 vrf vrfmerge
#    passive-interface default
#    !
#    address-family ipv4
#       redistribute connected
#       redistribute static route-map MAP01
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30
#    !
#    address-family ipv6
#       area 0.0.0.3 range 10.1.2.0/24
#       area 0.0.0.3 range 60.1.0.0/16 cost 30

- name: Gather running configuration
  arista.eos.eos_ospfv3:
    state: gathered

# Task output:
# ------------
# gathered:
#     processes:
#     - address_family:
#       - afi: ipv4
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#         redistribute:
#         - routes: connected
#         - route_map: MAP01
#           routes: static
#       - afi: ipv6
#         areas:
#         - area_id: 0.0.0.3
#           ranges:
#           - address: 10.1.2.0/24
#           - address: 60.1.0.0/16
#             cost: 30
#       passive_interface: true
#       vrf: vrfmerge


# using rendered

- name: render CLI commands for provided config
  arista.eos.eos_ospfv3:
    config:
      processes:
        - address_family:
            - timers:
                lsa: 22
              graceful_restart:
                grace_period: 35
              afi: "ipv6"
          timers:
            pacing: 55
          fips_restrictions: true
          router_id: "2.2.2.2"
          vrf: "vrfmerge"
    state: rendered

# Task output:
# ------------
# rendered:
# - router ospfv3 vrf vrfmerge
# - address-family ipv6
# - graceful-restart grace-period 35
# - timers lsa arrival 22
# - exit
# - timers pacing flood 55
# - fips restrictions
# - router-id 2.2.2.2
# - exit
"""
RETURN = """
before:
  description: The configuration prior to the module execution.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
after:
  description: The resulting configuration after module execution.
  returned: when changed
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
commands:
  description: The set of commands pushed to the remote device.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: list
  sample:
    - router ospfv3 vrf vrfmerge
    - address-family ipv6
    - graceful-restart grace-period 35
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
    - router ospfv3 vrf vrfmerge
    - address-family ipv6
    - graceful-restart grace-period 35
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
"""

from ansible.module_utils.basic import AnsibleModule

from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.ospfv3.ospfv3 import (
    Ospfv3Args,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.ospfv3.ospfv3 import (
    Ospfv3,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(
        argument_spec=Ospfv3Args.argument_spec,
        mutually_exclusive=[["config", "running_config"]],
        required_if=[
            ["state", "merged", ["config"]],
            ["state", "replaced", ["config"]],
            ["state", "overridden", ["config"]],
            ["state", "rendered", ["config"]],
            ["state", "parsed", ["running_config"]],
        ],
        supports_check_mode=False,
    )

    result = Ospfv3(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
