/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.userprofile.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPGroup;

public class UPConfig
implements Cloneable {
    private List<UPAttribute> attributes;
    private List<UPGroup> groups;
    private UnmanagedAttributePolicy unmanagedAttributePolicy;

    public List<UPAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<UPAttribute> attributes) {
        this.attributes = attributes;
    }

    public UPConfig addOrReplaceAttribute(UPAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<UPAttribute>();
        }
        this.removeAttribute(attribute.getName());
        this.attributes.add(attribute);
        return this;
    }

    public boolean removeAttribute(String name) {
        return this.attributes != null && this.attributes.removeIf(attribute -> attribute.getName().equals(name));
    }

    public List<UPGroup> getGroups() {
        if (this.groups == null) {
            return Collections.emptyList();
        }
        return this.groups;
    }

    public void setGroups(List<UPGroup> groups) {
        this.groups = groups;
    }

    public UPConfig addGroup(UPGroup group) {
        if (this.groups == null) {
            this.groups = new ArrayList<UPGroup>();
        }
        this.groups.add(group);
        return this;
    }

    @JsonIgnore
    public UPAttribute getAttribute(String name) {
        for (UPAttribute attribute : this.getAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public UnmanagedAttributePolicy getUnmanagedAttributePolicy() {
        return this.unmanagedAttributePolicy;
    }

    public void setUnmanagedAttributePolicy(UnmanagedAttributePolicy unmanagedAttributePolicy) {
        this.unmanagedAttributePolicy = unmanagedAttributePolicy;
    }

    public String toString() {
        return "UPConfig [attributes=" + this.attributes + ", groups=" + this.groups + "]";
    }

    public UPConfig clone() {
        UPConfig cfg = new UPConfig();
        cfg.setUnmanagedAttributePolicy(this.unmanagedAttributePolicy);
        if (this.attributes != null) {
            cfg.setAttributes(this.attributes.stream().map(UPAttribute::clone).collect(Collectors.toList()));
        }
        if (this.groups != null) {
            cfg.setGroups(this.groups.stream().map(UPGroup::clone).collect(Collectors.toList()));
        }
        return cfg;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.groups, this.unmanagedAttributePolicy});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UPConfig other = (UPConfig)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.groups, other.groups) && this.unmanagedAttributePolicy == other.unmanagedAttributePolicy;
    }

    public static enum UnmanagedAttributePolicy {
        ENABLED,
        ADMIN_VIEW,
        ADMIN_EDIT;

    }
}

