/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.Literal;
import com.sun.mail.imap.LengthCounter;
import com.sun.mail.util.CRLFOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.Message;
import javax.mail.MessagingException;

class MessageLiteral
implements Literal {
    private Message msg;
    private int msgSize = -1;
    private byte[] buf;

    public MessageLiteral(Message message, int n) throws MessagingException, IOException {
        this.msg = message;
        LengthCounter lengthCounter = new LengthCounter(n);
        CRLFOutputStream cRLFOutputStream = new CRLFOutputStream((OutputStream)lengthCounter);
        message.writeTo((OutputStream)cRLFOutputStream);
        cRLFOutputStream.flush();
        this.msgSize = lengthCounter.getSize();
        this.buf = lengthCounter.getBytes();
    }

    public int size() {
        return this.msgSize;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            if (this.buf != null) {
                outputStream.write(this.buf, 0, this.msgSize);
            } else {
                outputStream = new CRLFOutputStream(outputStream);
                this.msg.writeTo(outputStream);
            }
        }
        catch (MessagingException messagingException) {
            throw new IOException("MessagingException while appending message: " + (Object)((Object)messagingException));
        }
    }
}

