/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ProjectSettings;
import ca.sqlpower.architect.profile.TableProfileCreator;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ProjectSettingsPanel
extends JPanel
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(ProjectSettingsPanel.class);
    private ArchitectSwingSession session;
    private JPanel panel;
    private JCheckBox saveEntireSource;
    private JTextField numberOfFreqValues;
    private JComboBox profileMode;
    private JRadioButton rectilinearRelationships;
    private JRadioButton directRelationships;
    private JRadioButton displayRelationshipLabel;
    private JRadioButton hideRelationshipLabel;
    private JCheckBox showPkTag;
    private JCheckBox showFkTag;
    private JCheckBox showAkTag;
    private JRadioButton showAll;
    private JRadioButton showPkFkUniqueIndexed;
    private JRadioButton showPkFkUnique;
    private JRadioButton showPkFk;
    private JRadioButton showPk;
    private JRadioButton physicalNames;
    private JRadioButton logicalNames;

    public ProjectSettingsPanel(ArchitectSwingSession session) {
        this.session = session;
        this.setup();
        this.revertToProjectSettings();
    }

    public void setup() {
        FormLayout layout = new FormLayout("pref,4dlu,pref");
        DefaultFormBuilder fb = new DefaultFormBuilder(layout, new JPanel());
        this.setLayout((LayoutManager)layout);
        this.saveEntireSource = new JCheckBox();
        fb.append(Messages.getString("ProjectSettingsPanel.snapshotSourceDbOption"), (Component)this.saveEntireSource);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        this.numberOfFreqValues = new JTextField("", 6);
        fb.append(Messages.getString("ProjectSettingsPanel.numCommonProfileValues"), (Component)this.numberOfFreqValues);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        this.profileMode = new JComboBox<Object>(this.session.getProfileManager().getProfileCreators().toArray());
        fb.append(Messages.getString("ProjectSettingsPanel.profileMode"), this.profileMode);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        fb.append((Component)new JLabel(Messages.getString("ProjectSettingsPanel.relationshipLineStyle")));
        this.rectilinearRelationships = new JRadioButton(Messages.getString("ProjectSettingsPanel.rectilinearLineOption"));
        fb.append((Component)this.rectilinearRelationships);
        fb.nextLine();
        this.directRelationships = new JRadioButton(Messages.getString("ProjectSettingsPanel.directLineOption"));
        fb.append("", (Component)this.directRelationships);
        ButtonGroup lineStyleGroup = new ButtonGroup();
        lineStyleGroup.add(this.rectilinearRelationships);
        lineStyleGroup.add(this.directRelationships);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        fb.append((Component)new JLabel(Messages.getString("ProjectSettingsPanel.displayPhysicalOrLogical")));
        this.logicalNames = new JRadioButton(Messages.getString("ProjectSettingsPanel.displayLogicalNames"));
        fb.append((Component)this.logicalNames);
        fb.nextLine();
        this.physicalNames = new JRadioButton(Messages.getString("ProjectSettingsPanel.displayPhysicalNames"));
        fb.append("", (Component)this.physicalNames);
        ButtonGroup nameDisplay = new ButtonGroup();
        nameDisplay.add(this.logicalNames);
        nameDisplay.add(this.physicalNames);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        fb.append((Component)new JLabel(Messages.getString("ProjectSettingsPanel.visibilityOfRelationshipLabel")));
        this.displayRelationshipLabel = new JRadioButton(Messages.getString("ProjectSettingsPanel.displayRelationshipLabel"));
        fb.append((Component)this.displayRelationshipLabel);
        fb.nextLine();
        this.hideRelationshipLabel = new JRadioButton(Messages.getString("ProjectSettingsPanel.hideRelationshipLabel"));
        fb.append("", (Component)this.hideRelationshipLabel);
        ButtonGroup DisplayRelationshipLabel = new ButtonGroup();
        DisplayRelationshipLabel.add(this.displayRelationshipLabel);
        DisplayRelationshipLabel.add(this.hideRelationshipLabel);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        this.showAll = new JRadioButton(Messages.getString("ProjectSettingsPanel.showAll"));
        fb.append((Component)this.showAll);
        this.showPkTag = new JCheckBox(Messages.getString("ProjectSettingsPanel.showPKTags"));
        fb.append((Component)this.showPkTag);
        fb.nextLine();
        this.showPkFkUniqueIndexed = new JRadioButton(Messages.getString("ProjectSettingsPanel.showPKFKUniqueIndexed"));
        fb.append((Component)this.showPkFkUniqueIndexed);
        this.showFkTag = new JCheckBox(Messages.getString("ProjectSettingsPanel.showFKTags"));
        fb.append((Component)this.showFkTag);
        fb.nextLine();
        this.showPkFkUnique = new JRadioButton(Messages.getString("ProjectSettingsPanel.showPKFKUnique"));
        fb.append((Component)this.showPkFkUnique);
        this.showAkTag = new JCheckBox(Messages.getString("ProjectSettingsPanel.showAKTags"));
        fb.append((Component)this.showAkTag);
        fb.nextLine();
        this.showPkFk = new JRadioButton(Messages.getString("ProjectSettingsPanel.showPKFK"));
        fb.append((Component)this.showPkFk);
        fb.nextLine();
        this.showPk = new JRadioButton(Messages.getString("ProjectSettingsPanel.showPK"));
        fb.append((Component)this.showPk);
        fb.nextLine();
        ButtonGroup column_show_settings = new ButtonGroup();
        column_show_settings.add(this.showAll);
        column_show_settings.add(this.showPkFkUniqueIndexed);
        column_show_settings.add(this.showPkFkUnique);
        column_show_settings.add(this.showPkFk);
        column_show_settings.add(this.showPk);
        fb.setDefaultDialogBorder();
        this.panel = fb.getPanel();
    }

    private void revertToProjectSettings() {
        logger.debug((Object)"Reverting project options");
        this.numberOfFreqValues.setText(String.valueOf(this.session.getProfileManager().getDefaultProfileSettings().getTopNCount()));
        this.profileMode.setSelectedItem(this.session.getProfileManager().getCreator());
        this.saveEntireSource.setSelected(this.session.isSavingEntireSource());
        if (this.session.getRelationshipLinesDirect()) {
            this.directRelationships.setSelected(true);
        } else {
            this.rectilinearRelationships.setSelected(true);
        }
        if (this.session.isUsingLogicalNames()) {
            this.logicalNames.setSelected(true);
        } else {
            this.physicalNames.setSelected(true);
        }
        if (this.session.isDisplayRelationshipLabel()) {
            this.displayRelationshipLabel.setSelected(true);
        } else {
            this.hideRelationshipLabel.setSelected(true);
        }
        this.showPkTag.setSelected(this.session.isShowPkTag());
        this.showFkTag.setSelected(this.session.isShowFkTag());
        this.showAkTag.setSelected(this.session.isShowAkTag());
        ProjectSettings.ColumnVisibility choice = this.session.getProjectSettings().getColumnVisibility();
        switch (choice) {
            case ALL: {
                this.showAll.setSelected(true);
                break;
            }
            case PK: {
                this.showPk.setSelected(true);
                break;
            }
            case PK_FK: {
                this.showPkFk.setSelected(true);
                break;
            }
            case PK_FK_UNIQUE: {
                this.showPkFkUnique.setSelected(true);
                break;
            }
            case PK_FK_UNIQUE_INDEXED: {
                this.showPkFkUniqueIndexed.setSelected(true);
            }
        }
    }

    public boolean applyChanges() {
        ProjectSettings settings = this.session.getProjectSettings();
        try {
            settings.begin("Applying changes to project settings...");
            settings.setSavingEntireSource(this.saveEntireSource.isSelected());
            if (this.numberOfFreqValues.getText().length() > 0) {
                try {
                    this.session.getProfileManager().getDefaultProfileSettings().setTopNCount(Integer.valueOf(this.numberOfFreqValues.getText()));
                }
                catch (NumberFormatException e) {
                    ASUtils.showExceptionDialogNoReport(this, "Number Format Error", e);
                }
            }
            this.session.getProfileManager().setCreator((TableProfileCreator)this.profileMode.getSelectedItem());
            if (this.directRelationships.isSelected()) {
                settings.setRelationshipLinesDirect(true);
            } else {
                settings.setRelationshipLinesDirect(false);
            }
            if (this.logicalNames.isSelected()) {
                settings.setUsingLogicalNames(true);
            } else {
                settings.setUsingLogicalNames(false);
            }
            if (this.displayRelationshipLabel.isSelected()) {
                settings.setDisplayRelationshipLabel(true);
            } else {
                settings.setDisplayRelationshipLabel(false);
            }
            settings.setShowPkTag(this.showPkTag.isSelected());
            settings.setShowFkTag(this.showFkTag.isSelected());
            settings.setShowAkTag(this.showAkTag.isSelected());
            if (this.showAll.isSelected()) {
                settings.setColumnVisibility(ProjectSettings.ColumnVisibility.ALL);
            }
            if (this.showPk.isSelected()) {
                settings.setColumnVisibility(ProjectSettings.ColumnVisibility.PK);
            }
            if (this.showPkFk.isSelected()) {
                settings.setColumnVisibility(ProjectSettings.ColumnVisibility.PK_FK);
            }
            if (this.showPkFkUnique.isSelected()) {
                settings.setColumnVisibility(ProjectSettings.ColumnVisibility.PK_FK_UNIQUE);
            }
            if (this.showPkFkUniqueIndexed.isSelected()) {
                settings.setColumnVisibility(ProjectSettings.ColumnVisibility.PK_FK_UNIQUE_INDEXED);
            }
            settings.commit();
        }
        catch (Throwable e) {
            settings.rollback("Exception thrown when applying project settings changes");
            throw new RuntimeException(e);
        }
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

