/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.SimplePerfCountersWithTotal;
import org.jetbrains.kotlin.daemon.common.TotalProfiler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0096\bJ!\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0096\bJ\u0016\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R1\u0010\u0003\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/daemon/common/WallAndThreadByClassProfiler;", "Lorg/jetbrains/kotlin/daemon/common/TotalProfiler;", "()V", "counters", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/daemon/common/SimplePerfCountersWithTotal;", "Lkotlin/collections/HashMap;", "getCounters", "()Ljava/util/HashMap;", "beginMeasure", "", "", "obj", "endMeasure", "", "startState", "", "Lorg/jetbrains/kotlin/daemon/common/PerfCounters;", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nPerfUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/WallAndThreadByClassProfiler\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,196:1\n107#2,2:197\n83#2:199\n109#2:200\n86#2:201\n110#2:202\n114#2,5:210\n83#2:215\n119#2:216\n86#2:217\n120#2:218\n372#3,7:203\n*S KotlinDebug\n*F\n+ 1 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/WallAndThreadByClassProfiler\n*L\n191#1:197,2\n191#1:199\n191#1:200\n191#1:201\n191#1:202\n194#1:210,5\n194#1:215\n194#1:216\n194#1:217\n194#1:218\n194#1:203,7\n*E\n"})
public final class WallAndThreadByClassProfiler
extends TotalProfiler {
    @NotNull
    private final HashMap<Object, SimplePerfCountersWithTotal> counters = new HashMap();

    @NotNull
    public final HashMap<Object, SimplePerfCountersWithTotal> getCounters() {
        return this.counters;
    }

    @Override
    @NotNull
    public Map<Object, PerfCounters> getCounters() {
        return this.counters;
    }

    @Override
    @NotNull
    public List<Long> beginMeasure(@Nullable Object obj) {
        boolean $i$f$beginMeasure = false;
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"threadMXBean");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$beginMeasureWallAndThreadTimes = false;
        long startTime$iv = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime$iv = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime$iv = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        Object[] objectArray = new Long[]{startTime$iv, startThreadTime$iv, startThreadUserTime$iv};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endMeasure(@Nullable Object obj, @NotNull List<Long> startState) {
        void perfCounters$iv;
        Object object;
        PerfCounters $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(startState, (String)"startState");
        boolean $i$f$endMeasure = false;
        Map map = this.getCounters();
        Class<?> clazz = obj;
        String key$iv = clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SimplePerfCountersWithTotal answer$iv = new SimplePerfCountersWithTotal(this.getTotal());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        $this$getOrPut$iv = (PerfCounters)object;
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean, (String)"threadMXBean");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$endMeasureWallAndThreadTimes = false;
        long startTime$iv = ((Number)startState.get(0)).longValue();
        long startThreadTime$iv = ((Number)startState.get(1)).longValue();
        long startThreadUserTime$iv = ((Number)startState.get(2)).longValue();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        PerfCounters.addMeasurement$default((PerfCounters)perfCounters$iv, System.nanoTime() - startTime$iv, ($this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L) - startThreadTime$iv, ($this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L) - startThreadUserTime$iv, 0L, 8, null);
    }
}

