/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualClassesAndMembersCollector;", "", "actualClasses", "", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualMembers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "expectActualTypeAliasMap", "Lorg/jetbrains/kotlin/name/FqName;", "(Ljava/util/Map;Ljava/util/List;Ljava/util/Map;)V", "visitedActualClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "addActualClass", "", "classOrTypeAlias", "Lorg/jetbrains/kotlin/ir/IrElement;", "classSymbol", "collect", "element", "ir.backend.common"})
final class ActualClassesAndMembersCollector {
    @NotNull
    private final Map<String, IrClassSymbol> actualClasses;
    @NotNull
    private final List<IrDeclarationBase> actualMembers;
    @NotNull
    private final Map<FqName, FqName> expectActualTypeAliasMap;
    @NotNull
    private final Set<IrClass> visitedActualClasses;

    public ActualClassesAndMembersCollector(@NotNull Map<String, IrClassSymbol> actualClasses, @NotNull List<IrDeclarationBase> actualMembers2, @NotNull Map<FqName, FqName> expectActualTypeAliasMap) {
        Intrinsics.checkNotNullParameter(actualClasses, (String)"actualClasses");
        Intrinsics.checkNotNullParameter(actualMembers2, (String)"actualMembers");
        Intrinsics.checkNotNullParameter(expectActualTypeAliasMap, (String)"expectActualTypeAliasMap");
        this.actualClasses = actualClasses;
        this.actualMembers = actualMembers2;
        this.expectActualTypeAliasMap = expectActualTypeAliasMap;
        this.visitedActualClasses = new LinkedHashSet();
    }

    public final void collect(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrElement irElement = element;
        if (irElement instanceof IrModuleFragment) {
            for (IrFile file2 : ((IrModuleFragment)element).getFiles()) {
                this.collect(file2);
            }
        } else if (irElement instanceof IrTypeAlias) {
            if (!((IrTypeAlias)element).isActual()) {
                return;
            }
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrTypeAlias)element).getExpandedType());
            Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol expandedTypeSymbol = (IrClassSymbol)irClassifierSymbol;
            this.addActualClass(element, expandedTypeSymbol);
            this.collect((IrElement)expandedTypeSymbol.getOwner());
            this.expectActualTypeAliasMap.put(AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)element), AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)expandedTypeSymbol.getOwner()));
        } else if (irElement instanceof IrClass) {
            if (((IrClass)element).isExpect() || !this.visitedActualClasses.add((IrClass)element)) {
                return;
            }
            this.addActualClass(element, ((IrClass)element).getSymbol());
            for (IrDeclaration declaration : ((IrClass)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrDeclarationContainer) {
            for (IrDeclaration declaration : ((IrDeclarationContainer)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrEnumEntry) {
            this.actualMembers.add((IrDeclarationBase)element);
        } else if (irElement instanceof IrProperty) {
            if (((IrProperty)element).isExpect()) {
                return;
            }
            this.actualMembers.add((IrDeclarationBase)element);
        } else if (irElement instanceof IrFunction) {
            if (((IrFunction)element).isExpect()) {
                return;
            }
            this.actualMembers.add((IrDeclarationBase)element);
        }
    }

    private final void addActualClass(IrElement classOrTypeAlias, IrClassSymbol classSymbol) {
        this.actualClasses.put(IrActualizerUtilsKt.generateActualIrClassOrTypeAliasFullName(classOrTypeAlias), classSymbol);
    }
}

