/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendException;
import org.rrd4j.core.RrdFileBackend;

public class RrdRandomAccessFileBackend
extends RrdBackend
implements RrdFileBackend {
    protected final RandomAccessFile rafile;

    protected RrdRandomAccessFileBackend(String path, boolean readOnly) throws IOException {
        super(path);
        this.rafile = new RandomAccessFile(path, readOnly ? "r" : "rw");
    }

    @Override
    protected void close() throws IOException {
        this.rafile.close();
    }

    @Override
    protected void write(long offset, byte[] b) throws IOException {
        this.rafile.seek(offset);
        this.rafile.write(b);
    }

    @Override
    public void read(long offset, byte[] b) throws IOException {
        this.rafile.seek(offset);
        if (this.rafile.read(b) != b.length) {
            throw new RrdBackendException("Not enough bytes available in file " + this.getPath());
        }
    }

    @Override
    public String getCanonicalPath() {
        return Paths.get(this.getPath(), new String[0]).toAbsolutePath().normalize().toString();
    }

    @Override
    public long getLength() throws IOException {
        return this.rafile.length();
    }

    @Override
    protected void setLength(long length) throws IOException {
        this.rafile.setLength(length);
    }
}

