/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.ssh.keygenerator.KeyPairLoader;
import org.apache.karaf.shell.ssh.keygenerator.OpenSSHKeyPairGenerator;
import org.apache.karaf.shell.ssh.keygenerator.PemWriter;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSSHKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSSHKeyPairProvider.class);
    private Path privateKeyPath;
    private Path publicKeyPath;
    private String password;
    private KeyPair cachedKey;
    private String algorithm;
    private int keySize;

    public OpenSSHKeyPairProvider(Path privateKeyPath, Path publicKeyPath, String algorithm, int keySize, String password) {
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.password = password;
    }

    public synchronized Iterable<KeyPair> loadKeys(SessionContext sessionContext) throws IOException, GeneralSecurityException {
        Set<KeyPair> set;
        block14: {
            if (this.cachedKey != null) {
                return Collections.singleton(this.cachedKey);
            }
            if (!this.privateKeyPath.toFile().exists()) {
                this.createServerKey();
            }
            InputStream is = Files.newInputStream(this.privateKeyPath, new OpenOption[0]);
            try {
                KeyPair kp;
                this.cachedKey = kp = KeyPairLoader.getKeyPair(is, this.password);
                set = Collections.singleton(kp);
                if (is == null) break block14;
            }
            catch (Throwable kp) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            kp.addSuppressed(throwable);
                        }
                    }
                    throw kp;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to parse keypair in {}. Attempting to parse it 'directly'", (Object)this.privateKeyPath);
                    try {
                        KeyPair kp2 = this.getKeyPairUsingPublicKeyFile();
                        LOGGER.info("Successfully loaded key pair");
                        this.cachedKey = kp2;
                        return Collections.singleton(this.cachedKey);
                    }
                    catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e1) {
                        LOGGER.warn("Failed to parse keypair in {}. Attempting to parse it as a legacy 'simple' key", (Object)this.privateKeyPath);
                        try {
                            KeyPair kp3 = this.convertLegacyKey(this.privateKeyPath);
                            LOGGER.info("Successfully loaded legacy simple key. Converted to PEM format");
                            this.cachedKey = kp3;
                            return Collections.singleton(kp3);
                        }
                        catch (Exception nested) {
                            LOGGER.warn(this.privateKeyPath + " is not a 'simple' key either", (Throwable)nested);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            is.close();
        }
        return set;
    }

    private KeyPair convertLegacyKey(Path privateKeyPath) throws GeneralSecurityException, IOException {
        KeyPair keypair = null;
        SimpleGeneratorHostKeyProvider provider = new SimpleGeneratorHostKeyProvider();
        provider.setAlgorithm(this.algorithm);
        provider.setOverwriteAllowed(true);
        provider.setPath(privateKeyPath);
        provider.setKeySize(this.keySize);
        keypair = (KeyPair)provider.loadKeys(null).iterator().next();
        new PemWriter(privateKeyPath, this.publicKeyPath).writeKeyPair(this.algorithm, keypair);
        return keypair;
    }

    private KeyPair getKeyPairUsingPublicKeyFile() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
        String content = new String(Files.readAllBytes(this.privateKeyPath), StandardCharsets.UTF_8);
        content = content.replace("-----BEGIN PRIVATE KEY-----", "");
        content = content.replace("-----END PRIVATE KEY-----", "");
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(content));
        PrivateKey privateKey = keyFactory.generatePrivate(encodedKeySpec);
        content = new String(Files.readAllBytes(this.publicKeyPath), StandardCharsets.UTF_8);
        content = content.replace("-----BEGIN PUBLIC KEY-----", "");
        content = content.replace("-----END PUBLIC KEY-----", "");
        X509EncodedKeySpec encodedX509KeySpec = new X509EncodedKeySpec(Base64.getMimeDecoder().decode(content));
        PublicKey publicKey = keyFactory.generatePublic(encodedX509KeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    private KeyPair createServerKey() {
        try {
            LOGGER.info("Creating ssh server private key at " + this.privateKeyPath);
            KeyPair kp = new OpenSSHKeyPairGenerator(this.algorithm, this.keySize).generate();
            new PemWriter(this.privateKeyPath, this.publicKeyPath).writeKeyPair(this.algorithm, kp);
            LOGGER.debug("Changing key files permissions");
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            try {
                Files.setPosixFilePermissions(this.privateKeyPath, permissions);
                Files.setPosixFilePermissions(this.publicKeyPath, permissions);
            }
            catch (Exception e) {
                LOGGER.debug("Can't change file permissions", (Throwable)e);
            }
            return kp;
        }
        catch (Exception e) {
            throw new RuntimeException("Key file generation failed", e);
        }
    }
}

