/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.signatureengine;

import de.rub.nds.signatureengine.DsaWithSha1SignatureEngine;
import de.rub.nds.signatureengine.DsaWithSha256SignatureEngine;
import de.rub.nds.signatureengine.EcDsaWithSha1SignatureEngine;
import de.rub.nds.signatureengine.EcDsaWithSha256SignatureEngine;
import de.rub.nds.signatureengine.Md2WithRsaEncryptionSignatureEngine;
import de.rub.nds.signatureengine.Md4WithRsaEncryptionSignatureEngine;
import de.rub.nds.signatureengine.Md5WithRsaEncryptionSignatureEngine;
import de.rub.nds.signatureengine.Sha1WithRsaEncryptionSignatureEngine;
import de.rub.nds.signatureengine.Sha256WithRsaEncryptionSignatureEngine;
import de.rub.nds.signatureengine.Sha512WithRsaEncryptionSignatureEngine;
import de.rub.nds.signatureengine.SignatureEngineException;

public abstract class SignatureEngine {
    private static EngineTupel[] engines = new EngineTupel[]{new EngineTupel("1.2.840.113549.1.1.5", Sha1WithRsaEncryptionSignatureEngine.class), new EngineTupel("1.2.840.113549.1.1.11", Sha256WithRsaEncryptionSignatureEngine.class), new EngineTupel("1.2.840.113549.1.1.13", Sha512WithRsaEncryptionSignatureEngine.class), new EngineTupel("1.2.840.113549.1.1.1.2", Md2WithRsaEncryptionSignatureEngine.class), new EngineTupel("1.2.840.113549.1.1.1.3", Md4WithRsaEncryptionSignatureEngine.class), new EngineTupel("1.2.840.113549.1.1.1.4", Md5WithRsaEncryptionSignatureEngine.class), new EngineTupel("1.2.840.10040.4.3", DsaWithSha1SignatureEngine.class), new EngineTupel("1.2.840.10045.4.1", EcDsaWithSha1SignatureEngine.class), new EngineTupel("2.16.840.1.101.3.4.3.2", DsaWithSha256SignatureEngine.class), new EngineTupel("1.2.840.10045.4.3.2", EcDsaWithSha256SignatureEngine.class)};

    public static SignatureEngine getInstance(String objectIdentifierString) throws SignatureEngineException {
        SignatureEngine signatureEngine = null;
        Class<? extends SignatureEngine> signatureEngineClass = SignatureEngine.findSignatureEngineClass(objectIdentifierString);
        signatureEngine = SignatureEngine.invoke(signatureEngineClass);
        return signatureEngine;
    }

    private static Class<? extends SignatureEngine> findSignatureEngineClass(String objectIdentifierString) throws SignatureEngineException {
        Class<? extends SignatureEngine> signatureEngineClass = null;
        for (EngineTupel engine : engines) {
            if (!engine.objectIdentifierString.equalsIgnoreCase(objectIdentifierString)) continue;
            signatureEngineClass = engine.signatureEngine;
            break;
        }
        if (signatureEngineClass == null) {
            throw new SignatureEngineException("No signature engine found for [object identifier = " + objectIdentifierString + "]!");
        }
        return signatureEngineClass;
    }

    public static SignatureEngine invoke(Class<? extends SignatureEngine> signatureEngineClass) throws SignatureEngineException {
        SignatureEngine signatureEngine = null;
        try {
            signatureEngine = signatureEngineClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SignatureEngineException(e);
        }
        catch (IllegalAccessException e) {
            throw new SignatureEngineException(e);
        }
        return signatureEngine;
    }

    public String retrieveObjectIdentifier() throws SignatureEngineException {
        String result = null;
        for (EngineTupel engineTupel : engines) {
            if (!engineTupel.signatureEngine.isInstance(this)) continue;
            result = engineTupel.objectIdentifierString;
            break;
        }
        if (result == null) {
            throw new SignatureEngineException("Object identifier is not available in SignatureEngine's engine list!");
        }
        return result;
    }

    public abstract void init(byte[] var1, KeyType var2, byte[] var3) throws SignatureEngineException;

    public abstract byte[] sign(byte[] var1) throws SignatureEngineException;

    public static enum KeyType {
        RAW_KEY,
        DER_ENCODED,
        PEM_ENCODED;

    }

    public static class EngineTupel {
        public final String objectIdentifierString;
        public final Class<? extends SignatureEngine> signatureEngine;

        public EngineTupel(String objectIdentifierString, Class<? extends SignatureEngine> signatureEngine) {
            this.objectIdentifierString = objectIdentifierString;
            this.signatureEngine = signatureEngine;
        }
    }
}

