.\"
.\" Copyright (c) 2023 Andrea Biscuola <a@abiscuola.com>
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.Dd August 24, 2023
.Dt IRCTK-IRCTK n
.Os
.Sh NAME
.Nm irctk-irctk
.Nd core processing namespace
.Sh SYNOPSIS
.Cm irctk connect Ar network nick name pass cmd oldch
.Pp
.Cm irctk extmsg Ar msg
.Pp
.Cm irctk findnetwork Ar id
.Pp
.Cm irctk getnetwork Ar network
.Pp
.Cm irctk init
.Pp
.Cm irctk ischanrd Ar chan channel
.Pp
.Cm irctk killconnection Ar id
.Pp
.Cm irctk onexit
.Pp
.Cm irctk partch Ar chan channel
.Pp
.Cm irctk pingserver Ar chan
.Pp
.Cm irctk privatechan Ar chan nick
.Pp
.Cm irctk reconnect Ar chan
.Pp
.Cm irctk quitserver Ar chan
.Pp
.Cm irctk save Ar network nick name pass cmd
.Pp
.Cm irctk writemsg Ar chan id tags text loop
.Sh DESCRIPTION
The irctk namespace represent the heart of the whole
.Xr irctk 1
application.
Input message processing, message sending, connections and channels
management along with the gluing with all the other namespaces
take place here.
It is initialized by calling the
.Cm irctk init
command and terminated upon application exiting with
.Cm irctk onexit .
.Pp
After the initialization,
.Cm irctk connect
is called, serially, for all the IRC servers saved in the related configurations
file, also automatically joining all the channels saved from the previous
session.
A connection to an IRC server is initiated using the command specified in
.Ar cmd .
If the connection is successful, the command will proceed with requesting
IRCv3 capabilities and performing a login for the user.
.Pp
If a connection dies, a reconnection is tried automatically with the
.Cm irctk reconnect
command, with the old details and channels automatically transported
to the new connection, if successfull.
.Pp
.Cm irctk killconnection
explicitly kill an existing connection and start a reconnection process.
.Pp
Once the login process is completed and the user joined one or more
channels,
.Cm irctk writemsg
is called from the GUI to send messages to an IRC server.
The message specified in
.Ar text
is sent to the target identified by
.Ar id
in its numeric form, on the server whose connection channel is
.Ar chan .
The message will be enriched with the given
.Ar tags ,
a dictionary containing a series of key-value pairs identifying IRCv3 tags.
The
.Ar loop
variable must be set to 0, if we are sure that the message will not cause
a loop with the running extensions, or 1 if it is not the case.
The effect is, in the end, that the message will not be forwarded to the
extensions subsystem.
.Pp
.Cm irctk extmsg
is the command called by the extensions subsystem when an extension
sends an irc message to the application.
The function take care of preparing and injecting the message in the
writing flow, to be sent to the server and shown to the user in the
interface.
.Pp
.Cm irctk findnetwork
finds the communication channel associated with the network
.Ar id .
passed as argument.
.Pp
.Cm irctk partch
frees all the resources associated with a specific channel upon leaving
it.
.Pp
.Cm irctk ischanrd
Check if the
.Ar channel
in the network identified by the communication channel
.Ar chan
is of type
.Cm read only .
.Pp
.Cm irctk quitserver
is used to destroy all the resources related to a specific server connection,
both from the running application and from the disk.
The server details are deleted forever.
.Pp
.Cm irctk getnetwork
command, reads the
.Ar network
connection details from it's configurations file.
.Pp
.Cm irctk save
is called whenever the application must store a connection informations
on its configuration file.
.Pp
.Cm irctk privatechan
is called to create a private communication channel between the application
user and the IRC user identified by
.Ar nick
.Pp
.Cm irctk pingserver
is used to periodically send a PING message, to check if the connection
is still alive.
.Sh RETURN VALUES
.Cm irctk findnetwork
return the communication channel of the network identified by
.Ar id
or an empty list if nothing is found.
.Pp
.Cm irctk ischanrd
return 1 if the channel is read only, or 0 if not.
.Pp
.Cm irctk getnetwork
return the dictionary with the configurations for the given
.Ar network .
.Pp
.Cm irctk connect
return the new communication channel for the network.
.Sh FILES
.Bl -tag -compact -width "${HOME}/.config/irctk/auto/$net/connect.confXXXX"
.It Pa ${HOME}/.config/irctk/auto/$net/connect.conf
Network configuration for automatic connection at startup.
.It Pa ${HOME}/.config/irctk/auto/$net/join.conf
List of channels to join at startup.
.El
.Sh SEE ALSO
.Xr irctk 1 ,
.Xr irctk-exts n ,
.Xr irctk-gui n ,
.Xr irctk-irc n ,
.Xr irctk-log n
.Sh AUTHORS
.An Andrea Biscuola Aq Mt a@abiscuola.com
