"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRulesRoutes = setupRulesRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRulesRoutes(services, router) {
  const {
    rulesService
  } = services;
  router.post({
    path: `${_constants.API.RULES_BASE}/_search`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        prePackaged: _configSchema.schema.boolean()
      }),
      body: _configSchema.schema.any()
    }
  }, rulesService.getRules);
  router.post({
    path: `${_constants.API.RULES_BASE}`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)({
        category: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, rulesService.createRule);
  router.delete({
    path: `${_constants.API.RULES_BASE}/{ruleId}`,
    validate: {
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, rulesService.deleteRule);
  router.put({
    path: `${_constants.API.RULES_BASE}/{ruleId}`,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)({
        category: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      })
    }
  }, rulesService.updateRule);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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