/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.frame;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSession;
import com.intellij.kotlin.jupyter.core.debug.util.CommonKt;
import com.intellij.kotlin.jupyter.core.debug.util.DebugSupportUtilsKt;
import com.intellij.kotlin.jupyter.core.debug.variables.KotlinNotebookSessionVariablesService;
import com.intellij.kotlin.jupyter.core.debug.variables.NotebookVariablesPerFileStateService;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.StackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/frame/KotlinNotebookVariablesFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "debugSession", "Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSession;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/kotlin/jupyter/core/debug/session/KotlinNotebookDebugSession;)V", "evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "getEqualityObject", "", "getEvaluator", "getSourcePosition", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookVariablesFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookVariablesFrame.kt\ncom/intellij/kotlin/jupyter/core/debug/frame/KotlinNotebookVariablesFrame\n+ 2 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,115:1\n13#2:116\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookVariablesFrame.kt\ncom/intellij/kotlin/jupyter/core/debug/frame/KotlinNotebookVariablesFrame\n*L\n33#1:116\n*E\n"})
public final class KotlinNotebookVariablesFrame
extends XStackFrame {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @Nullable
    private final XSourcePosition sourcePosition;
    @NotNull
    private final KotlinNotebookDebugSession debugSession;
    @Nullable
    private XDebuggerEvaluator evaluator;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Object STACK_FRAME_EQUALITY_OBJECT;

    public KotlinNotebookVariablesFrame(@NotNull Project project, @Nullable XSourcePosition sourcePosition, @NotNull KotlinNotebookDebugSession debugSession) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        this.project = project;
        this.sourcePosition = sourcePosition;
        this.debugSession = debugSession;
    }

    @Nullable
    public Object getEqualityObject() {
        return STACK_FRAME_EQUALITY_OBJECT;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            DebuggerSession debuggerSession = this.debugSession.getDebuggerSession();
            if (debuggerSession == null || (debuggerSession = debuggerSession.getProcess()) == null) {
                return null;
            }
            DebuggerSession debugProcess = debuggerSession;
            StackFrameProxyImpl stackFrameProxyImpl = this.debugSession.getCurrentStackFrameProxy();
            StackFrame stackFrame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
            JavaStackFrame frameProxy = stackFrame instanceof JavaStackFrame ? (JavaStackFrame)stackFrame : null;
            this.evaluator = (XDebuggerEvaluator)new JavaDebuggerEvaluator((DebugProcessImpl)debugProcess, frameProxy);
        }
        return this.evaluator;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        DebugProcessImpl debugProcess;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        KotlinNotebookDebugSession.ensureSilentSessionAlive$default(this.debugSession, null, 1, null);
        if (!DebugSupportUtilsKt.getShouldShowNotebookVariables(this.project)) {
            super.computeChildren(node);
            return;
        }
        DebuggerSession debuggerSession = this.debugSession.getDebuggerSession();
        Object object = debugProcess = debuggerSession != null ? debuggerSession.getProcess() : null;
        if (node.isObsolete() || debugProcess == null) {
            node.setErrorMessage(KotlinNotebookBundle.message("kotlin.jupyter.debug.node.empty.no.connection.message", new Object[0]));
            return;
        }
        if (!debugProcess.isAttached()) {
            if (debugProcess.isInInitialState()) {
                node.setErrorMessage(KotlinNotebookBundle.message("kotlin.jupyter.debug.node.rebuild.message", new Object[0]));
                return;
            }
            node.setErrorMessage(KotlinNotebookBundle.message("kotlin.jupyter.debug.node.empty.not.attached.message", new Object[0]));
            LOG.warn("Session is not initialized");
            return;
        }
        NotebookVariablesPerFileStateService variablesService = KotlinNotebookSessionVariablesService.Companion.getForFile(this.project, this.debugSession.getVirtualFile());
        EvaluationContextImpl context = this.debugSession.getEvaluationContext();
        if (context == null) {
            node.setErrorMessage(KotlinNotebookBundle.message("kotlin.jupyter.debug.node.no.context.message", new Object[0]));
            Attachment[] attachmentArray = new Attachment[]{CommonKt.createScreeningAttachment(this.debugSession)};
            LoggingKt.errorUnderDebug(LOG, "Suspended context is null", attachmentArray);
            return;
        }
        context.getSuspendContext().getManagerThread().invoke(PrioritizedTask.Priority.HIGH, () -> KotlinNotebookVariablesFrame.computeChildren$lambda$0(context, node, variablesService, this));
        super.computeChildren(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void computeChildren$lambda$0(EvaluationContextImpl $context, XCompositeNode $node, NotebookVariablesPerFileStateService $variablesService, KotlinNotebookVariablesFrame this$0) {
        DebuggerSession debuggerSession;
        try {
            VirtualMachineProxyImpl virtualMachine = $context.getSuspendContext().getVirtualMachineProxy();
            $node.addChildren($variablesService.representVariablesStateAsXContainer((VirtualMachineProxy)virtualMachine, $context), true);
            debuggerSession = this$0.debugSession.getDebuggerSession();
        }
        catch (Exception ex) {
            DebuggerSession debuggerSession2;
            try {
                LOG.error("Error during variables state computation: ", (Throwable)ex);
                debuggerSession2 = this$0.debugSession.getDebuggerSession();
            }
            catch (Throwable throwable) {
                DebuggerSession debuggerSession3 = this$0.debugSession.getDebuggerSession();
                LoggingKt.warnUnderDebug(LOG, "Is paused: " + (debuggerSession3 != null ? debuggerSession3.isPaused() : false));
                throw throwable;
            }
            LoggingKt.warnUnderDebug(LOG, "Is paused: " + (debuggerSession2 != null ? debuggerSession2.isPaused() : false));
        }
        LoggingKt.warnUnderDebug(LOG, "Is paused: " + (debuggerSession != null ? debuggerSession.isPaused() : false));
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
        STACK_FRAME_EQUALITY_OBJECT = new Object();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/frame/KotlinNotebookVariablesFrame$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "STACK_FRAME_EQUALITY_OBJECT", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

